% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{plotsymbolsmap}
\alias{plotsymbolsmap}
\title{Plotting groups as different symbols in the t-SNE map}
\usage{
plotsymbolsmap(object, types = NULL, subset = NULL, fr = FALSE)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{types}{Vector assigning each cell to a type to be highlighted in the t-SNE map. The order has to be the same as for the
columns in slot \code{ndata} of the \code{SCseq} object. Default is \code{NULL} and each cell is highlighted by a different symbol.}

\item{subset}{Vector containing a subset of types from \code{types} to be highlighted in the map. Default is \code{NULL} and all
types are shown.}

\item{fr}{logical. If \code{TRUE} then plot t-SNE map, else plot Fruchterman-Rheingold layout.}
}
\value{
None
}
\description{
This functions highlights groups of cells by different symbols in a two-dimensional t-SNE map or a Fruchterman-Rheingold graph layout
of the singe-cell transcriptome data.
}
