  require(RXshrink)
  #
  # Read in the Portland Cement data.frame...
  data(haldport)
  #
  # Next, define a regression model formula...
  form <- heat~p3ca+p3cs+p4caf+p2cs
  #
  # First, perform QM (2-parameter) generalized Ridge Shrinkage...
  rxqmobj <- qm.ridge(form, data=haldport)
  #
  # Display all 5 qm.ridge() TRACE Diagnostics in 1 plot...
  plot(rxqmobj)
  #
  # Print qm.ridge() Summary Statistics...
  rxqmobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from qm.ridge()...
  #
  # Next, results for (augmented) Least Angle Regression,
  # aug.lars(), will be PLOTTED and PRINTED...
  #
  # Perform Augmented lars() model fitting...  
  rxlaobj <- aug.lars(form, data=haldport)
  #
  # Display all 5 aug.lars() TRACE Diagnostics in 1 plot...
  plot(rxlaobj)
  #
  # Print Summary Statistics from aug.lars()...
  rxlaobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from aug.lars()...
  #
  # Next, results from RX augmented lars() model fitting to the
  # Uncorrelated Components of the haldport data.frame, 
  # uc.lars(), will be PLOTTED and PRINTED...  
  #
  # Perform uc.lars() model fitting...  
  rxucobj <- uc.lars(form, data=haldport)
  #
  # Display all 5 uc.lars() TRACE Diagnostics in 1 plot...
  plot(rxucobj)
  #
  # Print Summary Statistics from uc.lars()...
  rxucobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from uc.lars()...
  #
  # Finally, results for EFFICIENT (p-parameter)
  # generalized ridge regression (GRR) model-fitting,
  # using eff.ridge(), will be PLOTTED and PRINTED...  
  #
  # Perform eff.ridge() model fitting...  
  rxefobj <- eff.ridge(form, data=haldport)
  #
  # Display all 5 eff.ridge() TRACE Diagnostics in 1 plot...
  plot(rxefobj)
  #
  # Print Summary Statistics from eff.ridge()...  
  rxefobj
  # SCROLL ^^^ UP ^^^ to see PRINTED output from eff.ridge()...
  #
  # Did you notice how DIFFERENT these FOUR Main Types of GRR Paths
  # [qm.ridge(), aug.lars() uc.lars() and eff.ridge()] LOOK
  # for the "haldport" data.frame?
  #
  # Since the eff.ridge() Path is "most flexible" and  always contains the
  # beta-coefficient vector with Maximum Overall Normal-theory Likelihood
  # of Minimal MSE risk, a good strategy is to explore this PATH First !!!
  #
  #################### END of "haldport" Demo...
  