% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dms2dd.R
\name{dms2dd}
\alias{dms2dd}
\title{Convert from degrees, minutes, and seconds to decimal degrees}
\usage{
dms2dd(lon, lat)
}
\arguments{
\item{lon}{a character vector of longitude coordinates in degrees, minutes,
and seconds; see \code{details}}

\item{lat}{a character vector of latitude coordinates in degrees, minutes,
and seconds; see \code{details}}
}
\value{
An \eqn{n * 2} matrix where \emph{n} is the length of \code{lon} and \code{lat}.
}
\description{
Convert latitudes and longitudes from degrees, minutes, and seconds to
decimal degrees for conversion to spatial objects.
}
\details{
\code{lon} and \code{lat} are expected to be in the format
\verb{"degrees° minutes' seconds" (direction)"} where \code{direction} is optional. If
\code{direction} is not present, \code{dms2dd} will use negative signs (\code{-}) to
determine positioning of coordinates.
}
\examples{
ll <- data.frame(lon = c("-122° 19' 55\"",
                         "71° 3' 32\" W"),
                 lat = c("47° 36' 22\"",
                         "42° 21' 36\" N"),
                 stringsAsFactors = FALSE)
dms2dd(ll[, 'lon'], ll[, 'lat'])
}
