/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="ClassAssigner", category="Evaluation", toolTipText="Designate which column is to be considered the class column in incoming data.", iconPath="weka/gui/knowledgeflow/icons/ClassAssigner.gif")
public class ClassAssigner
extends BaseStep {
    private static final long serialVersionUID = -4269063233834866140L;
    protected String m_classColumnS = "/last";
    protected String m_classCol = "/last";
    protected boolean m_classAssigned;
    protected boolean m_isInstanceStream;

    public void setClassColumn(String col) {
        this.m_classColumnS = col;
    }

    public String getClassColumn() {
        return this.m_classColumnS;
    }

    @Override
    public void stepInit() throws WekaException {
        if (this.m_classColumnS == null || this.m_classColumnS.length() == 0) {
            throw new WekaException("No class column specified!");
        }
        this.m_classCol = this.getStepManager().environmentSubstitute(this.m_classColumnS).trim();
        this.m_classAssigned = false;
        this.m_isInstanceStream = false;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        Object payload = data.getPayloadElement(data.getConnectionName());
        if (!this.m_classAssigned) {
            if (data.getConnectionName().equals("instance")) {
                this.m_isInstanceStream = true;
                Instance inst = (Instance)payload;
                if (inst != null) {
                    this.assignClass(inst.dataset());
                }
            } else {
                this.getStepManager().processing();
                if (payload == null) {
                    throw new WekaException("Incoming data is null!");
                }
                this.assignClass((Instances)payload);
            }
            this.m_classAssigned = true;
        }
        if (this.isStopRequested()) {
            if (!this.m_isInstanceStream) {
                this.getStepManager().interrupted();
            }
            return;
        }
        if (this.m_isInstanceStream) {
            if (this.getStepManager().isStreamFinished(data)) {
                this.getStepManager().throughputFinished(new Data(data.getConnectionName()));
                return;
            }
            this.getStepManager().throughputUpdateStart();
            this.getStepManager().throughputUpdateEnd();
        }
        this.getStepManager().outputData(data.getConnectionName(), data);
        if (!this.m_isInstanceStream || payload == null) {
            if (!this.isStopRequested()) {
                this.getStepManager().finished();
            } else {
                this.getStepManager().interrupted();
            }
        }
    }

    protected void assignClass(Instances dataSet) throws WekaException {
        Attribute classAtt = dataSet.attribute(this.m_classCol);
        boolean assigned = false;
        if (classAtt != null) {
            dataSet.setClass(classAtt);
            assigned = true;
        } else if (this.m_classCol.equalsIgnoreCase("last") || this.m_classCol.equalsIgnoreCase("/last")) {
            dataSet.setClassIndex(dataSet.numAttributes() - 1);
            assigned = true;
        } else if (this.m_classCol.equalsIgnoreCase("first") || this.m_classCol.equalsIgnoreCase("/first")) {
            dataSet.setClassIndex(0);
            assigned = true;
        } else {
            try {
                int classIndex = Integer.parseInt(this.m_classCol);
                if (--classIndex >= 0 && classIndex < dataSet.numAttributes()) {
                    dataSet.setClassIndex(classIndex);
                    assigned = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!assigned) {
            throw new WekaException("Unable to assign '" + this.m_classCol + "' as the class.");
        }
        this.getStepManager().logBasic("Assigned '" + dataSet.classAttribute().name() + "' as class.");
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("dataSet", "trainingSet", "testSet", "instance");
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnectionsOfType("instance") > 0) {
            result.add("instance");
        } else if (this.getStepManager().numIncomingConnectionsOfType("dataSet") > 0) {
            result.add("dataSet");
        } else if (this.getStepManager().numIncomingConnectionsOfType("trainingSet") > 0) {
            result.add("trainingSet");
        } else if (this.getStepManager().numIncomingConnectionsOfType("testSet") > 0) {
            result.add("testSet");
        }
        return result;
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        this.m_classCol = this.getStepManager().environmentSubstitute(this.m_classColumnS).trim();
        if (!connectionName.equals("dataSet") && !connectionName.equals("trainingSet") && !connectionName.equals("testSet") && !connectionName.equals("instance") || this.getStepManager().numIncomingConnections() == 0) {
            return null;
        }
        Instances strucForDatasetCon = this.getStepManager().getIncomingStructureForConnectionType("dataSet");
        if (strucForDatasetCon != null) {
            this.assignClass(strucForDatasetCon);
            return strucForDatasetCon;
        }
        Instances strucForTestsetCon = this.getStepManager().getIncomingStructureForConnectionType("testSet");
        if (strucForTestsetCon != null) {
            this.assignClass(strucForTestsetCon);
            return strucForTestsetCon;
        }
        Instances strucForTrainingCon = this.getStepManager().getIncomingStructureForConnectionType("trainingSet");
        if (strucForTrainingCon != null) {
            this.assignClass(strucForTrainingCon);
            return strucForTrainingCon;
        }
        Instances strucForInstanceCon = this.getStepManager().getIncomingStructureForConnectionType("instance");
        if (strucForInstanceCon != null) {
            this.assignClass(strucForInstanceCon);
            return strucForInstanceCon;
        }
        return null;
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.ClassAssignerStepEditorDialog";
    }
}

