/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.EnvironmentField;
import weka.gui.JListHelper;
import weka.gui.arffviewer.ArffPanel;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.knowledgeflow.steps.DataGrid;

public class DataGridStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = -7314471130292016602L;
    protected JTabbedPane m_tabbedPane = new JTabbedPane();
    protected ArffViewerPanel m_viewerPanel = new ArffViewerPanel();
    protected EnvironmentField m_attNameField = new EnvironmentField();
    protected JComboBox<String> m_attTypeField = new JComboBox();
    protected EnvironmentField m_nominalOrDateFormatField = new EnvironmentField();
    protected JList<AttDef> m_list = new JList();
    protected DefaultListModel<AttDef> m_listModel;
    protected JButton m_newBut = new JButton("New");
    protected JButton m_deleteBut = new JButton("Delete");
    protected JButton m_upBut = new JButton("Move up");
    protected JButton m_downBut = new JButton("Move down");
    protected String m_stringInstances;

    protected void initialize() {
        this.m_stringInstances = ((DataGrid)this.getStepToEdit()).getData();
        this.m_listModel = new DefaultListModel();
        this.m_list.setModel(this.m_listModel);
        if (this.m_stringInstances != null && this.m_stringInstances.length() > 0) {
            try {
                Instances insts = new Instances(new StringReader(this.m_stringInstances));
                for (int i = 0; i < insts.numAttributes(); ++i) {
                    Attribute a = insts.attribute(i);
                    String nomOrDate = "";
                    if (a.isNominal()) {
                        for (int j = 0; j < a.numValues(); ++j) {
                            nomOrDate = nomOrDate + a.value(j) + ",";
                        }
                        nomOrDate = nomOrDate.substring(0, nomOrDate.length() - 1);
                    } else if (a.isDate()) {
                        nomOrDate = a.getDateFormat();
                    }
                    AttDef def = new AttDef(a.name(), a.type(), nomOrDate);
                    this.m_listModel.addElement(def);
                }
                this.m_viewerPanel.setInstances(insts);
            }
            catch (Exception ex) {
                this.showErrorDialog(ex);
            }
        }
    }

    @Override
    protected void layoutEditor() {
        this.initialize();
        this.m_upBut.setEnabled(false);
        this.m_downBut.setEnabled(false);
        JPanel mainHolder = new JPanel(new BorderLayout());
        JPanel controlHolder = new JPanel();
        controlHolder.setLayout(new BorderLayout());
        JPanel fieldHolder = new JPanel();
        fieldHolder.setLayout(new GridLayout(1, 0));
        JPanel attNameP = new JPanel(new BorderLayout());
        attNameP.setBorder(BorderFactory.createTitledBorder("Attribute name"));
        attNameP.add((Component)this.m_attNameField, "Center");
        JPanel attTypeP = new JPanel(new BorderLayout());
        attTypeP.setBorder(BorderFactory.createTitledBorder("Attribute type"));
        attTypeP.add(this.m_attTypeField, "Center");
        this.m_attTypeField.addItem("numeric");
        this.m_attTypeField.addItem("nominal");
        this.m_attTypeField.addItem("date");
        this.m_attTypeField.addItem("string");
        JPanel nomDateP = new JPanel(new BorderLayout());
        nomDateP.setBorder(BorderFactory.createTitledBorder("Nominal vals/date format"));
        nomDateP.add((Component)this.m_nominalOrDateFormatField, "Center");
        fieldHolder.add(attNameP);
        fieldHolder.add(attTypeP);
        fieldHolder.add(nomDateP);
        controlHolder.add((Component)fieldHolder, "North");
        mainHolder.add((Component)controlHolder, "North");
        this.m_list.setVisibleRowCount(5);
        this.m_deleteBut.setEnabled(false);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 0));
        butHolder.add(this.m_newBut);
        butHolder.add(this.m_deleteBut);
        butHolder.add(this.m_upBut);
        butHolder.add(this.m_downBut);
        listPanel.add((Component)butHolder, "North");
        JScrollPane js = new JScrollPane(this.m_list);
        js.setBorder(BorderFactory.createTitledBorder("Attributes"));
        listPanel.add((Component)js, "Center");
        mainHolder.add((Component)listPanel, "Center");
        this.m_tabbedPane.addTab("Attribute definitions", mainHolder);
        this.m_tabbedPane.addTab("Data", this.m_viewerPanel);
        this.add((Component)this.m_tabbedPane, "Center");
        this.m_attNameField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AttDef a = DataGridStepEditorDialog.this.m_list.getSelectedValue();
                if (a != null) {
                    a.m_name = DataGridStepEditorDialog.this.m_attNameField.getText();
                    DataGridStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_nominalOrDateFormatField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AttDef a = DataGridStepEditorDialog.this.m_list.getSelectedValue();
                if (a != null) {
                    a.m_nomOrDate = DataGridStepEditorDialog.this.m_nominalOrDateFormatField.getText();
                    DataGridStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_attTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttDef a = DataGridStepEditorDialog.this.m_list.getSelectedValue();
                if (a != null) {
                    String type = DataGridStepEditorDialog.this.m_attTypeField.getSelectedItem().toString();
                    a.m_type = AttDef.attStringToType(type);
                    DataGridStepEditorDialog.this.m_list.repaint();
                }
            }
        });
        this.m_tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DataGridStepEditorDialog.this.m_tabbedPane.getSelectedIndex() == 1) {
                    DataGridStepEditorDialog.this.handleTabChange();
                }
            }
        });
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (!DataGridStepEditorDialog.this.m_deleteBut.isEnabled()) {
                        DataGridStepEditorDialog.this.m_deleteBut.setEnabled(true);
                    }
                    DataGridStepEditorDialog.this.checkUpDown();
                    AttDef entry = DataGridStepEditorDialog.this.m_list.getSelectedValue();
                    if (entry != null) {
                        DataGridStepEditorDialog.this.m_attNameField.setText(entry.m_name);
                        DataGridStepEditorDialog.this.m_attTypeField.setSelectedItem(Attribute.typeToString(entry.m_type));
                        DataGridStepEditorDialog.this.m_nominalOrDateFormatField.setText(entry.m_nomOrDate != null ? entry.m_nomOrDate : "");
                    }
                }
            }
        });
        this.m_newBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttDef def = new AttDef(DataGridStepEditorDialog.this.m_attNameField.getText(), AttDef.attStringToType(DataGridStepEditorDialog.this.m_attTypeField.getSelectedItem().toString()), DataGridStepEditorDialog.this.m_nominalOrDateFormatField.getText());
                DataGridStepEditorDialog.this.m_listModel.addElement(def);
                DataGridStepEditorDialog.this.m_list.setSelectedIndex(DataGridStepEditorDialog.this.m_listModel.size() - 1);
                DataGridStepEditorDialog.this.checkUpDown();
            }
        });
        this.m_deleteBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = DataGridStepEditorDialog.this.m_list.getSelectedIndex();
                if (selected >= 0) {
                    DataGridStepEditorDialog.this.m_listModel.removeElementAt(selected);
                    DataGridStepEditorDialog.this.checkUpDown();
                    if (DataGridStepEditorDialog.this.m_listModel.size() <= 1) {
                        DataGridStepEditorDialog.this.m_upBut.setEnabled(false);
                        DataGridStepEditorDialog.this.m_downBut.setEnabled(false);
                    }
                }
            }
        });
        this.m_upBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveUp(DataGridStepEditorDialog.this.m_list);
                DataGridStepEditorDialog.this.checkUpDown();
            }
        });
        this.m_downBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveDown(DataGridStepEditorDialog.this.m_list);
                DataGridStepEditorDialog.this.checkUpDown();
            }
        });
    }

    protected void checkUpDown() {
        if (this.m_list.getSelectedValue() != null && this.m_listModel.size() > 1) {
            this.m_upBut.setEnabled(this.m_list.getSelectedIndex() > 0);
            this.m_downBut.setEnabled(this.m_list.getSelectedIndex() < this.m_listModel.size() - 1);
        }
    }

    @Override
    public void okPressed() {
        Instances current = this.m_viewerPanel.getInstances();
        if (current != null) {
            ((DataGrid)this.getStepToEdit()).setData(current.toString());
        } else {
            ((DataGrid)this.getStepToEdit()).setData("");
        }
    }

    protected void handleTabChange() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (AttDef a : Collections.list(this.m_listModel.elements())) {
            if (a.m_type == 0) {
                atts.add(new Attribute(a.m_name));
                continue;
            }
            if (a.m_type == 2) {
                atts.add(new Attribute(a.m_name, (List<String>)null));
                continue;
            }
            if (a.m_type == 3) {
                atts.add(new Attribute(a.m_name, a.m_nomOrDate));
                continue;
            }
            if (a.m_type == 1) {
                ArrayList<String> vals = new ArrayList<String>();
                for (String v : a.m_nomOrDate.split(",")) {
                    vals.add(v.trim());
                }
                atts.add(new Attribute(a.m_name, vals));
                continue;
            }
            if (a.m_type != 4) continue;
        }
        Instances defInsts = new Instances("DataGrid", atts, 0);
        Instances editInsts = this.m_viewerPanel.getInstances();
        if (editInsts != null) {
            if (editInsts.numInstances() == 0) {
                this.m_viewerPanel.setInstances(defInsts);
            } else {
                HashMap<Integer, Integer> transferMap = new HashMap<Integer, Integer>();
                for (int i = 0; i < editInsts.numAttributes(); ++i) {
                    Attribute eA = editInsts.attribute(i);
                    Attribute dA = defInsts.attribute(eA.name());
                    if (dA == null || dA.type() != eA.type()) continue;
                    transferMap.put(i, dA.index());
                }
                if (transferMap.size() > 0) {
                    Instances defCopy = new Instances(defInsts, 0);
                    for (int i = 0; i < editInsts.numInstances(); ++i) {
                        double[] vals = new double[defCopy.numAttributes()];
                        Instance editInst = editInsts.instance(i);
                        for (int j = 0; j < vals.length; ++j) {
                            vals[j] = Utils.missingValue();
                        }
                        for (Map.Entry e : transferMap.entrySet()) {
                            if (editInst.attribute((Integer)e.getKey()).isNumeric()) {
                                vals[((Integer)e.getValue()).intValue()] = editInst.value((Integer)e.getKey());
                                continue;
                            }
                            if (editInst.attribute((Integer)e.getKey()).isNominal()) {
                                if (editInst.isMissing((Integer)e.getKey())) continue;
                                int defIndex = defCopy.attribute((Integer)e.getValue()).indexOfValue(editInst.stringValue((Integer)e.getKey()));
                                vals[((Integer)e.getValue()).intValue()] = defIndex >= 0 ? (double)defIndex : Utils.missingValue();
                                continue;
                            }
                            if (editInst.attribute((Integer)e.getKey()).isString()) {
                                if (editInst.isMissing((Integer)e.getKey())) continue;
                                String editVal = editInst.stringValue((Integer)e.getKey());
                                vals[((Integer)e.getValue()).intValue()] = defCopy.attribute((Integer)e.getValue()).addStringValue(editVal);
                                continue;
                            }
                            if (!editInst.attribute((Integer)e.getKey()).isRelationValued()) continue;
                        }
                        defCopy.add(new DenseInstance(1.0, vals));
                    }
                    this.m_viewerPanel.setInstances(defCopy);
                } else {
                    this.m_viewerPanel.setInstances(defInsts);
                }
            }
        } else {
            this.m_viewerPanel.setInstances(defInsts);
        }
    }

    protected static class ArffViewerPanel
    extends JPanel {
        private static final long serialVersionUID = 2965315087365186710L;
        protected JButton m_UndoButton = new JButton("Undo");
        protected JButton m_addInstanceButton = new JButton("Add instance");
        protected ArffPanel m_ArffPanel = new ArffPanel();

        public ArffViewerPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_ArffPanel, "Center");
            JPanel panel = new JPanel(new FlowLayout(2));
            panel.add(this.m_addInstanceButton);
            panel.add(this.m_UndoButton);
            this.add((Component)panel, "South");
            this.m_UndoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArffViewerPanel.this.undo();
                }
            });
            this.m_addInstanceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ArffViewerPanel.this.m_ArffPanel.addInstanceAtEnd();
                }
            });
        }

        public void setInstances(Instances inst) {
            this.m_ArffPanel.setInstances(new Instances(inst));
        }

        public Instances getInstances() {
            return this.m_ArffPanel.getInstances();
        }

        protected void setButtons() {
            this.m_UndoButton.setEnabled(this.m_ArffPanel.canUndo());
        }

        private void undo() {
            this.m_ArffPanel.undo();
        }
    }

    protected static class AttDef {
        protected String m_name = "";
        protected int m_type = 0;
        protected String m_nomOrDate = "";

        public AttDef(String name, int type, String nomOrDate) {
            this.m_name = name;
            this.m_type = type;
            this.m_nomOrDate = nomOrDate;
        }

        public String toString() {
            String result = "@attribute " + this.m_name + " " + (this.m_type != 1 ? Attribute.typeToString(this.m_type) : " {");
            if (this.m_type == 1) {
                result = result + this.m_nomOrDate + "}";
            } else if (this.m_type == 3) {
                result = result + " " + this.m_nomOrDate;
            }
            return result;
        }

        public static int attStringToType(String type) {
            if (type.equals("numeric")) {
                return 0;
            }
            if (type.equals("nominal")) {
                return 1;
            }
            if (type.equals("string")) {
                return 2;
            }
            if (type.equals("date")) {
                return 3;
            }
            if (type.equals("relational")) {
                return 4;
            }
            return 0;
        }
    }
}

