/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Utils;
import weka.gui.PropertyDialog;
import weka.gui.SettingsEditor;
import weka.gui.knowledgeflow.MainKFPerspective;
import weka.knowledgeflow.steps.Step;

public abstract class StepEditorDialog
extends JPanel
implements EnvironmentHandler {
    private static final long serialVersionUID = -4860182109190301676L;
    protected boolean m_isEdited;
    protected Environment m_env = Environment.getSystemWide();
    protected JPanel m_buttonHolder = new JPanel(new GridLayout(1, 0));
    protected JButton m_okBut = new JButton("OK");
    protected JButton m_cancelBut = new JButton("Cancel");
    protected JButton m_settingsBut = new JButton("Settings");
    protected MainKFPerspective m_mainPerspective;
    protected Window m_parent;
    protected ClosingListener m_closingListener;
    protected Step m_stepToEdit;
    protected StringBuilder m_helpText = new StringBuilder();
    protected JButton m_helpBut = new JButton("About");

    public StepEditorDialog() {
        this.setLayout(new BorderLayout());
        this.m_buttonHolder.add(this.m_okBut);
        this.m_buttonHolder.add(this.m_cancelBut);
        this.add((Component)this.m_buttonHolder, "South");
        this.m_okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StepEditorDialog.this.ok();
            }
        });
        this.m_cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StepEditorDialog.this.cancel();
            }
        });
    }

    protected void setMainPerspective(MainKFPerspective main) {
        this.m_mainPerspective = main;
    }

    protected MainKFPerspective getMainPerspective() {
        return this.m_mainPerspective;
    }

    protected void showErrorDialog(Exception cause) {
        this.m_mainPerspective.showErrorDialog(cause);
    }

    protected void showInfoDialog(Object information, String title, boolean isWarning) {
        this.m_mainPerspective.showInfoDialog(information, title, isWarning);
    }

    protected Step getStepToEdit() {
        return this.m_stepToEdit;
    }

    protected void setStepToEdit(Step step) {
        this.m_stepToEdit = step;
        this.createAboutPanel(step);
        if (step.getDefaultSettings() != null) {
            this.addSettingsButton();
        }
        this.layoutEditor();
    }

    protected void layoutEditor() {
    }

    protected void addSettingsButton() {
        this.getMainPerspective().getMainApplication().getApplicationSettings().applyDefaults(this.getStepToEdit().getDefaultSettings());
        this.m_buttonHolder.add(this.m_settingsBut);
        this.m_settingsBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SettingsEditor.showSingleSettingsEditor(StepEditorDialog.this.getMainPerspective().getMainApplication().getApplicationSettings(), StepEditorDialog.this.getStepToEdit().getDefaultSettings().getID(), StepEditorDialog.this.getStepToEdit().getName(), StepEditorDialog.this);
                }
                catch (IOException ex) {
                    StepEditorDialog.this.showErrorDialog(ex);
                }
            }
        });
    }

    protected void setParentWindow(Window parent) {
        this.m_parent = parent;
    }

    protected void setClosingListener(ClosingListener c) {
        this.m_closingListener = c;
    }

    protected boolean isEdited() {
        return this.m_isEdited;
    }

    protected void setEdited(boolean edited) {
        this.m_isEdited = edited;
    }

    private void ok() {
        this.setEdited(true);
        this.okPressed();
        if (this.m_parent != null) {
            this.m_parent.dispose();
        }
        if (this.m_closingListener != null) {
            this.m_closingListener.closing();
        }
    }

    protected void okPressed() {
    }

    protected void cancelPressed() {
    }

    private void cancel() {
        this.setEdited(false);
        this.cancelPressed();
        if (this.m_parent != null) {
            this.m_parent.dispose();
        }
        if (this.m_closingListener != null) {
            this.m_closingListener.closing();
        }
    }

    protected void createAboutPanel(Step step) {
        String globalFirstSentence = "";
        String globalInfo = Utils.getGlobalInfo(step, false);
        if (globalInfo == null) {
            globalFirstSentence = globalInfo = "No info available";
        } else {
            globalInfo = globalInfo.replace("font color=blue", "font color=black");
            try {
                Method gI = step.getClass().getMethod("globalInfo", new Class[0]);
                String globalInfoNoHTML = gI.invoke((Object)step, new Object[0]).toString();
                globalFirstSentence = globalInfoNoHTML.contains(".") ? globalInfoNoHTML.substring(0, globalInfoNoHTML.indexOf(46)) : globalInfoNoHTML;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.createAboutPanel(globalInfo, globalFirstSentence);
    }

    private void createAboutPanel(String about, String firstSentence) {
        JTextArea jt = new JTextArea();
        this.m_helpText.append(about);
        jt.setColumns(30);
        jt.setFont(new Font("SansSerif", 0, 12));
        jt.setEditable(false);
        jt.setLineWrap(true);
        jt.setWrapStyleWord(true);
        jt.setText(firstSentence);
        jt.setBackground(this.getBackground());
        String className = this.m_stepToEdit.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        this.m_helpBut.setToolTipText("More information about " + className);
        final JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("About"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jp.setLayout(new BorderLayout());
        jp.add((Component)new JScrollPane(jt), "Center");
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add((Component)this.m_helpBut, "North");
        jp.add((Component)p2, "East");
        this.add((Component)jp, "North");
        int preferredWidth = jt.getPreferredSize().width;
        jt.setSize(new Dimension(Math.min(preferredWidth, 600), Short.MAX_VALUE));
        Dimension d = jt.getPreferredSize();
        jt.setPreferredSize(new Dimension(Math.min(preferredWidth, 600), d.height));
        this.m_helpBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                StepEditorDialog.this.openHelpFrame(jp);
                StepEditorDialog.this.m_helpBut.setEnabled(false);
            }
        });
    }

    private void openHelpFrame(JPanel aboutPanel) {
        JTextPane ta = new JTextPane();
        ta.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ta.setContentType("text/html");
        ta.setEditable(false);
        ta.setText(this.m_helpText.toString());
        ta.setCaretPosition(0);
        JDialog jdtmp = PropertyDialog.getParentDialog(this) != null ? new JDialog(PropertyDialog.getParentDialog(this), "Information") : (PropertyDialog.getParentFrame(this) != null ? new JDialog(PropertyDialog.getParentFrame(this), "Information") : new JDialog((Frame)null, "Information"));
        final JDialog jd = jdtmp;
        jd.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                jd.dispose();
                StepEditorDialog.this.m_helpBut.setEnabled(true);
            }
        });
        jd.getContentPane().setLayout(new BorderLayout());
        jd.getContentPane().add((Component)new JScrollPane(ta), "Center");
        jd.pack();
        jd.setSize(400, 350);
        jd.setLocation(aboutPanel.getTopLevelAncestor().getLocationOnScreen().x + aboutPanel.getTopLevelAncestor().getSize().width, aboutPanel.getTopLevelAncestor().getLocationOnScreen().y);
        jd.setVisible(true);
    }

    public Environment getEnvironment() {
        return this.m_env;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public String environmentSubstitute(String source) {
        String result = source;
        if (result != null) {
            try {
                result = this.m_env.substitute(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static interface ClosingListener {
        public void closing();
    }
}

