/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.gui.beans.AbstractEvaluator;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.UserRequestAcceptor;

public class ClustererPerformanceEvaluator
extends AbstractEvaluator
implements BatchClustererListener,
Serializable,
UserRequestAcceptor,
EventConstraints {
    private static final long serialVersionUID = 8041163601333978584L;
    private transient ClusterEvaluation m_eval;
    private transient Clusterer m_clusterer;
    private transient Thread m_evaluateThread = null;
    private final Vector<TextListener> m_textListeners = new Vector();

    public ClustererPerformanceEvaluator() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClustererPerformanceEvaluator.gif", "weka/gui/beans/icons/ClustererPerformanceEvaluator_animated.gif");
        this.m_visual.setText("ClustererPerformanceEvaluator");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Evaluate the performance of batch trained clusterers.";
    }

    @Override
    public void acceptClusterer(final BatchClustererEvent ce) {
        if (ce.getTestSet().isStructureOnly()) {
            return;
        }
        try {
            if (this.m_evaluateThread == null) {
                this.m_evaluateThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean numericClass = false;
                        try {
                            if (ce.getSetNumber() == 1) {
                                ClustererPerformanceEvaluator.this.m_eval = new ClusterEvaluation();
                                ClustererPerformanceEvaluator.this.m_clusterer = ce.getClusterer();
                                ClustererPerformanceEvaluator.this.m_eval.setClusterer(ClustererPerformanceEvaluator.this.m_clusterer);
                            }
                            if (ce.getSetNumber() <= ce.getMaxSetNumber()) {
                                if (ClustererPerformanceEvaluator.this.m_logger != null) {
                                    ClustererPerformanceEvaluator.this.m_logger.statusMessage(ClustererPerformanceEvaluator.this.statusMessagePrefix() + "Evaluating (" + ce.getSetNumber() + ")...");
                                }
                                ClustererPerformanceEvaluator.this.m_visual.setAnimated();
                                if (ce.getTestSet().getDataSet().classIndex() != -1 && ce.getTestSet().getDataSet().classAttribute().isNumeric()) {
                                    numericClass = true;
                                    ce.getTestSet().getDataSet().setClassIndex(-1);
                                }
                                ClustererPerformanceEvaluator.this.m_eval.evaluateClusterer(ce.getTestSet().getDataSet());
                            }
                            if (ce.getSetNumber() == ce.getMaxSetNumber()) {
                                String textTitle = ClustererPerformanceEvaluator.this.m_clusterer.getClass().getName();
                                textTitle = textTitle.substring(textTitle.lastIndexOf(46) + 1, textTitle.length());
                                String test = ce.getTestOrTrain() == 0 ? "test" : "training";
                                String resultT = "=== Evaluation result for " + test + " instances ===\n\n" + "Scheme: " + textTitle + "\n" + "Relation: " + ce.getTestSet().getDataSet().relationName() + "\n\n" + ClustererPerformanceEvaluator.this.m_eval.clusterResultsToString();
                                if (numericClass) {
                                    resultT = resultT + "\n\nNo class based evaluation possible. Class attribute has to be nominal.";
                                }
                                TextEvent te = new TextEvent(ClustererPerformanceEvaluator.this, resultT, textTitle);
                                ClustererPerformanceEvaluator.this.notifyTextListeners(te);
                                if (ClustererPerformanceEvaluator.this.m_logger != null) {
                                    ClustererPerformanceEvaluator.this.m_logger.statusMessage(ClustererPerformanceEvaluator.this.statusMessagePrefix() + "Finished.");
                                }
                            }
                        }
                        catch (Exception ex) {
                            ClustererPerformanceEvaluator.this.stop();
                            if (ClustererPerformanceEvaluator.this.m_logger != null) {
                                ClustererPerformanceEvaluator.this.m_logger.statusMessage(ClustererPerformanceEvaluator.this.statusMessagePrefix() + "ERROR (see log for details");
                                ClustererPerformanceEvaluator.this.m_logger.logMessage("[ClustererPerformanceEvaluator] " + ClustererPerformanceEvaluator.this.statusMessagePrefix() + " problem while evaluating clusterer. " + ex.getMessage());
                            }
                            ex.printStackTrace();
                        }
                        finally {
                            ClustererPerformanceEvaluator.this.m_visual.setStatic();
                            ClustererPerformanceEvaluator.this.m_evaluateThread = null;
                            if (this.isInterrupted() && ClustererPerformanceEvaluator.this.m_logger != null) {
                                ClustererPerformanceEvaluator.this.m_logger.logMessage("[" + ClustererPerformanceEvaluator.this.getCustomName() + "] Evaluation interrupted!");
                                ClustererPerformanceEvaluator.this.m_logger.statusMessage(ClustererPerformanceEvaluator.this.statusMessagePrefix() + "INTERRUPTED");
                            }
                            ClustererPerformanceEvaluator.this.block(false);
                        }
                    }
                };
                this.m_evaluateThread.setPriority(1);
                this.m_evaluateThread.start();
                this.block(true);
                this.m_evaluateThread = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isBusy() {
        return this.m_evaluateThread != null;
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_evaluateThread != null) {
            this.m_evaluateThread.interrupt();
            this.m_evaluateThread.stop();
            this.m_evaluateThread = null;
            this.m_visual.setStatic();
        }
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_evaluateThread != null && this.m_evaluateThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    @Override
    public Enumeration<String> enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_evaluateThread != null) {
            newVector.addElement("Stop");
        }
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(request + " not supported (ClustererPerformanceEvaluator)");
        }
        this.stop();
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent te) {
        Vector l;
        ClustererPerformanceEvaluator clustererPerformanceEvaluator = this;
        synchronized (clustererPerformanceEvaluator) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TextListener)l.elementAt(i)).acceptText(te);
            }
        }
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("batchClusterer");
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

