/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import weka.core.PluginManager;
import weka.core.Utils;
import weka.core.WekaPackageManager;
import weka.core.logging.Logger;
import weka.core.metastore.MetaStore;
import weka.core.metastore.XMLFileBasedMetaStore;
import weka.gui.beans.OffscreenChartRenderer;

public class BeansProperties
implements Serializable {
    private static final long serialVersionUID = 7183413615090695785L;
    protected static final String PROPERTY_FILE = "weka/gui/beans/Beans.props";
    protected static final String TEMPLATE_PROPERTY_FILE = "weka/gui/beans/templates/templates.props";
    protected static List<String> TEMPLATE_PATHS;
    protected static List<String> TEMPLATE_DESCRIPTIONS;
    protected static Properties BEAN_PROPERTIES;
    protected static ArrayList<Properties> BEAN_PLUGINS_PROPERTIES;
    protected static String VISIBLE_PERSPECTIVES_PROPERTIES_FILE;
    protected static SortedSet<String> VISIBLE_PERSPECTIVES;
    private static boolean s_pluginManagerIntialized;
    protected static MetaStore s_kfMetaStore;

    public static MetaStore getMetaStore() {
        return s_kfMetaStore;
    }

    public static void addToPluginBeanProps(File beanPropsFile) throws Exception {
        Properties tempP = new Properties();
        tempP.load(new FileInputStream(beanPropsFile));
        if (!BEAN_PLUGINS_PROPERTIES.contains(tempP)) {
            BEAN_PLUGINS_PROPERTIES.add(tempP);
        }
    }

    public static void removeFromPluginBeanProps(File beanPropsFile) throws Exception {
        Properties tempP = new Properties();
        tempP.load(new FileInputStream(beanPropsFile));
        if (BEAN_PLUGINS_PROPERTIES.contains(tempP)) {
            BEAN_PLUGINS_PROPERTIES.remove(tempP);
        }
    }

    public static synchronized void loadProperties() {
        if (BEAN_PROPERTIES == null) {
            WekaPackageManager.loadPackages(false);
            Logger.log(Logger.Level.INFO, "[KnowledgeFlow] Loading properties and plugins...");
            try {
                BEAN_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
                Enumeration<?> keys = BEAN_PROPERTIES.propertyNames();
                if (!keys.hasMoreElements()) {
                    throw new Exception("Could not read a configuration file for the bean\npanel. An example file is included with the Weka distribution.\nThis file should be named \"weka/gui/beans/Beans.props\" and\nshould be placed either in your user home (which is set\nto \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n");
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "KnowledgeFlow", 0);
            }
            if (VISIBLE_PERSPECTIVES == null) {
                Properties pp = new Properties();
                pp.setProperty("weka.gui.beans.KnowledgeFlow.Perspectives", "weka.gui.beans.ScatterPlotMatrix,weka.gui.beans.AttributeSummarizer,weka.gui.beans.SQLViewerPerspective");
                BEAN_PLUGINS_PROPERTIES.add(pp);
                VISIBLE_PERSPECTIVES = new TreeSet<String>();
                try {
                    String listedPerspectives;
                    Properties visible = Utils.readProperties(VISIBLE_PERSPECTIVES_PROPERTIES_FILE);
                    Enumeration<?> keys = visible.propertyNames();
                    if (keys.hasMoreElements() && (listedPerspectives = visible.getProperty("weka.gui.beans.KnowledgeFlow.SelectedPerspectives")) != null && listedPerspectives.length() > 0) {
                        StringTokenizer st = new StringTokenizer(listedPerspectives, ", ");
                        while (st.hasMoreTokens()) {
                            String string = st.nextToken().trim();
                            Logger.log(Logger.Level.INFO, "Adding perspective " + string + " to visible list");
                            VISIBLE_PERSPECTIVES.add(string);
                        }
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "KnowledgeFlow", 0);
                }
            }
        }
        if (TEMPLATE_PATHS == null) {
            TEMPLATE_PATHS = new ArrayList<String>();
            TEMPLATE_DESCRIPTIONS = new ArrayList<String>();
            try {
                Properties templateProps = Utils.readProperties(TEMPLATE_PROPERTY_FILE);
                String paths = templateProps.getProperty("weka.gui.beans.KnowledgeFlow.templates");
                String descriptions = templateProps.getProperty("weka.gui.beans.KnowledgeFlow.templates.desc");
                if (paths == null || paths.length() == 0) {
                    Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] WARNING: no templates found in classpath");
                } else {
                    String[] desc;
                    String[] templates = paths.split(",");
                    if (templates.length != (desc = descriptions.split(",")).length) {
                        throw new Exception("Number of template descriptions does not match number of templates.");
                    }
                    for (String template : templates) {
                        TEMPLATE_PATHS.add(template.trim());
                    }
                    String[] stringArray = desc;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String d = stringArray[i];
                        TEMPLATE_DESCRIPTIONS.add(d.trim());
                    }
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "KnowledgeFlow", 0);
            }
        }
        if (!s_pluginManagerIntialized && BEAN_PLUGINS_PROPERTIES != null && BEAN_PLUGINS_PROPERTIES.size() > 0) {
            for (int i = 0; i < BEAN_PLUGINS_PROPERTIES.size(); ++i) {
                String[] desc;
                String[] stringArray;
                Properties tempP = BEAN_PLUGINS_PROPERTIES.get(i);
                String offscreenRenderers = tempP.getProperty("weka.gui.beans.OffscreenChartRenderer");
                if (offscreenRenderers != null && offscreenRenderers.length() > 0) {
                    String[] parts;
                    for (String renderer : parts = offscreenRenderers.split(",")) {
                        renderer = renderer.trim();
                        try {
                            Object p = Class.forName(renderer).newInstance();
                            if (!(p instanceof OffscreenChartRenderer)) continue;
                            String name = ((OffscreenChartRenderer)p).rendererName();
                            PluginManager.addPlugin("weka.gui.beans.OffscreenChartRenderer", name, renderer);
                            Logger.log(Logger.Level.INFO, "[KnowledgeFlow] registering chart rendering plugin: " + renderer);
                        }
                        catch (Exception ex) {
                            Logger.log(Logger.Level.WARNING, "[KnowledgeFlow] WARNING: unable to instantiate chart renderer \"" + renderer + "\"");
                            ex.printStackTrace();
                        }
                    }
                }
                String templatePaths = tempP.getProperty("weka.gui.beans.KnowledgeFlow.templates");
                String templateDesc = tempP.getProperty("weka.gui.beans.KnowledgeFlow.templates.desc");
                if (templatePaths == null || templatePaths.length() <= 0 || templateDesc == null || templateDesc.length() <= 0 || (stringArray = templatePaths.split(",")).length != (desc = templateDesc.split(",")).length) continue;
                for (int kk = 0; kk < stringArray.length; ++kk) {
                    String pth = stringArray[kk];
                    String d = desc[kk];
                    if (TEMPLATE_PATHS.contains(pth)) continue;
                    TEMPLATE_PATHS.add(pth.trim());
                    TEMPLATE_DESCRIPTIONS.add(d.trim());
                }
            }
            s_pluginManagerIntialized = true;
        }
    }

    static {
        BEAN_PLUGINS_PROPERTIES = new ArrayList();
        VISIBLE_PERSPECTIVES_PROPERTIES_FILE = "weka/gui/beans/VisiblePerspectives.props";
        s_pluginManagerIntialized = false;
        s_kfMetaStore = new XMLFileBasedMetaStore();
    }
}

