/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractDenseMatrix;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Side;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.util.intW;

abstract class AbstractTriangDenseMatrix
extends AbstractDenseMatrix {
    UpLo uplo;
    Diag diag;
    int ld;

    AbstractTriangDenseMatrix(int n, UpLo uplo, Diag diag) {
        super(n, n);
        this.ld = n;
        this.uplo = uplo;
        this.diag = diag;
    }

    AbstractTriangDenseMatrix(Matrix A, UpLo uplo, Diag diag) {
        this(A, Math.min(A.numRows(), A.numColumns()), uplo, diag);
    }

    AbstractTriangDenseMatrix(Matrix A, boolean deep, UpLo uplo, Diag diag) {
        this(A, Math.min(A.numRows(), A.numColumns()), deep, uplo, diag);
    }

    AbstractTriangDenseMatrix(Matrix A, int k, UpLo uplo, Diag diag) {
        this(A, k, true, uplo, diag);
    }

    AbstractTriangDenseMatrix(Matrix A, int k, boolean deep, UpLo uplo, Diag diag) {
        super(A, deep);
        if (deep && !A.isSquare()) {
            throw new IllegalArgumentException("deep && !A.isSquare()");
        }
        this.ld = A.numRows();
        this.numRows = this.numColumns = k;
        this.uplo = uplo;
        this.diag = diag;
    }

    @Override
    public Vector mult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.mult(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        BLAS.getInstance().dtrmv(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.diag.netlib(), this.numRows, this.data, Math.max(1, this.ld), yd, 1);
        return y;
    }

    @Override
    public Vector transMult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.transMult(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        BLAS.getInstance().dtrmv(this.uplo.netlib(), Transpose.Transpose.netlib(), this.diag.netlib(), this.numRows, this.data, Math.max(1, this.ld), yd, 1);
        return y;
    }

    @Override
    public Matrix mult(double alpha, Matrix B, Matrix C) {
        if (!(C instanceof DenseMatrix)) {
            return super.mult(alpha, B, C);
        }
        this.checkMultAdd(B, C);
        double[] Cd = ((DenseMatrix)C).getData();
        C.set(B);
        BLAS.getInstance().dtrmm(Side.Left.netlib(), this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.diag.netlib(), C.numRows(), C.numColumns(), alpha, this.data, Math.max(1, this.ld), Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix transAmult(double alpha, Matrix B, Matrix C) {
        if (!(C instanceof DenseMatrix)) {
            return super.transAmult(alpha, B, C);
        }
        this.checkTransAmultAdd(B, C);
        double[] Cd = ((DenseMatrix)C).getData();
        C.set(B);
        BLAS.getInstance().dtrmm(Side.Left.netlib(), this.uplo.netlib(), Transpose.Transpose.netlib(), this.diag.netlib(), C.numRows(), C.numColumns(), alpha, this.data, Math.max(1, this.ld), Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X) {
        return this.solve(B, X, Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X) {
        return this.solve(B, X, Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.transSolve(B, X);
        return x;
    }

    Matrix solve(Matrix B, Matrix X, Transpose trans) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        if (B.numRows() < this.numRows) {
            throw new IllegalArgumentException("B.numRows() < A.numRows()");
        }
        if (B.numColumns() != X.numColumns()) {
            throw new IllegalArgumentException("B.numColumns() != X.numColumns()");
        }
        if (X.numRows() < this.numRows) {
            throw new IllegalArgumentException("X.numRows() < A.numRows()");
        }
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        intW info = new intW(0);
        LAPACK.getInstance().dtrtrs(this.uplo.netlib(), trans.netlib(), this.diag.netlib(), this.numRows, X.numColumns(), this.data, Math.max(1, this.ld), Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    int getIndex(int row, int column) {
        this.check(row, column);
        return row + column * Math.max(this.ld, this.numRows);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new TriangDenseMatrixIterator();
    }

    private class TriangDenseMatrixIterator
    extends AbstractMatrix.RefMatrixIterator {
        private TriangDenseMatrixIterator() {
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (AbstractTriangDenseMatrix.this.uplo == UpLo.Lower) {
                if (this.row < AbstractTriangDenseMatrix.this.numRows - 1) {
                    ++this.row;
                } else {
                    ++this.column;
                    this.row = this.column;
                }
            } else if (this.row < this.column) {
                ++this.row;
            } else {
                ++this.column;
                this.row = 0;
            }
            return this.entry;
        }
    }
}

