/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Memory;
import weka.core.logging.Logger;
import weka.gui.LookAndFeel;
import weka.gui.sql.ConnectionPanel;
import weka.gui.sql.InfoPanel;
import weka.gui.sql.QueryPanel;
import weka.gui.sql.ResultPanel;
import weka.gui.sql.ResultSetHelper;
import weka.gui.sql.event.ConnectionEvent;
import weka.gui.sql.event.ConnectionListener;
import weka.gui.sql.event.HistoryChangedEvent;
import weka.gui.sql.event.HistoryChangedListener;
import weka.gui.sql.event.QueryExecuteEvent;
import weka.gui.sql.event.QueryExecuteListener;
import weka.gui.sql.event.ResultChangedEvent;
import weka.gui.sql.event.ResultChangedListener;

public class SqlViewer
extends JPanel
implements ConnectionListener,
HistoryChangedListener,
QueryExecuteListener,
ResultChangedListener {
    private static final long serialVersionUID = -4395028775566514329L;
    protected static final String HISTORY_FILE = "SqlViewerHistory.props";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    protected JFrame m_Parent;
    protected ConnectionPanel m_ConnectionPanel;
    protected QueryPanel m_QueryPanel;
    protected ResultPanel m_ResultPanel;
    protected InfoPanel m_InfoPanel;
    protected String m_URL;
    protected String m_User;
    protected String m_Password;
    protected String m_Query;
    protected Properties m_History;
    private static Memory m_Memory = new Memory(true);
    private static SqlViewer m_Viewer;

    public SqlViewer(JFrame parent) {
        this.m_Parent = parent;
        this.m_URL = "";
        this.m_User = "";
        this.m_Password = "";
        this.m_Query = "";
        this.m_History = new Properties();
        this.createPanel();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.m_ConnectionPanel = new ConnectionPanel(this.m_Parent);
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Connection"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        panel.add((Component)this.m_ConnectionPanel, "Center");
        this.m_QueryPanel = new QueryPanel(this.m_Parent);
        panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "Center");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Query"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        panel2.add((Component)this.m_QueryPanel, "North");
        panel.add((Component)panel2, "North");
        this.m_ResultPanel = new ResultPanel(this.m_Parent);
        this.m_ResultPanel.setQueryPanel(this.m_QueryPanel);
        panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Result"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        panel2.add((Component)this.m_ResultPanel, "Center");
        panel.add((Component)panel2, "Center");
        this.m_InfoPanel = new InfoPanel(this.m_Parent);
        panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "South");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Info"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        panel.add((Component)this.m_InfoPanel, "Center");
        this.addConnectionListener(this);
        this.addConnectionListener(this.m_QueryPanel);
        this.addQueryExecuteListener(this);
        this.addQueryExecuteListener(this.m_ResultPanel);
        this.addResultChangedListener(this);
        this.addHistoryChangedListener(this);
        this.loadHistory(true);
    }

    public void connectionChange(ConnectionEvent evt) {
        if (evt.getType() == 1) {
            this.m_InfoPanel.append("disconnect from: " + evt.getDbUtils().getDatabaseURL(), "information_small.gif");
        } else {
            this.m_InfoPanel.append("connecting to: " + evt.getDbUtils().getDatabaseURL() + " = " + evt.isConnected(), "information_small.gif");
        }
        if (evt.getException() != null) {
            this.m_InfoPanel.append("exception: " + evt.getException(), "error_small.gif");
        }
        if (evt.isConnected()) {
            this.m_QueryPanel.setFocus();
        } else {
            this.m_ConnectionPanel.setFocus();
        }
    }

    public void queryExecuted(QueryExecuteEvent evt) {
        if (evt.failed()) {
            this.m_InfoPanel.append("Query:" + evt.getQuery(), "error_small.gif");
            this.m_InfoPanel.append("exception: " + evt.getException(), "error_small.gif");
        } else {
            this.m_InfoPanel.append("Query: " + evt.getQuery(), "information_small.gif");
            try {
                if (evt.hasResult()) {
                    ResultSetHelper helper = new ResultSetHelper(evt.getResultSet());
                    if (evt.getMaxRows() > 0 && helper.getRowCount() >= evt.getMaxRows()) {
                        this.m_InfoPanel.append(helper.getRowCount() + " rows selected (" + evt.getMaxRows() + " displayed).", "information_small.gif");
                    } else if (helper.getRowCount() == -1) {
                        this.m_InfoPanel.append("Unknown number of rows selected (due to JDBC driver restrictions).", "information_small.gif");
                    } else {
                        this.m_InfoPanel.append(helper.getRowCount() + " rows selected.", "information_small.gif");
                    }
                }
                this.loadHistory(false);
                this.m_History.setProperty("max_rows", Integer.toString(evt.getMaxRows()));
                this.saveHistory();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void resultChanged(ResultChangedEvent evt) {
        this.m_URL = evt.getURL();
        this.m_User = evt.getUser();
        this.m_Password = evt.getPassword();
        this.m_Query = evt.getQuery();
    }

    public void historyChanged(HistoryChangedEvent evt) {
        this.loadHistory(false);
        this.m_History.setProperty(evt.getHistoryName(), this.modelToString(evt.getHistory()));
        this.saveHistory();
    }

    protected String getHistoryFilename() {
        return System.getProperties().getProperty("user.home") + File.separatorChar + HISTORY_FILE;
    }

    protected DefaultListModel stringToModel(String s) {
        String tmpStr;
        int i;
        DefaultListModel<String> result = new DefaultListModel<String>();
        String[] find = new String[]{"\"\"", "\\n", "\\r", "\\t"};
        String[] replace = new String[]{"\"", "\n", "\r", "\t"};
        for (i = 0; i < find.length; ++i) {
            tmpStr = "";
            while (s.length() > 0) {
                int index = s.indexOf(find[i]);
                if (index > -1) {
                    tmpStr = tmpStr + s.substring(0, index) + replace[i];
                    s = s.substring(index + 2);
                    continue;
                }
                tmpStr = tmpStr + s;
                s = "";
            }
            s = tmpStr;
        }
        boolean quote = false;
        tmpStr = "";
        for (i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\"') {
                quote = !quote;
                tmpStr = tmpStr + "" + s.charAt(i);
                continue;
            }
            if (s.charAt(i) == ',') {
                if (quote) {
                    tmpStr = tmpStr + "" + s.charAt(i);
                    continue;
                }
                if (tmpStr.startsWith("\"")) {
                    tmpStr = tmpStr.substring(1, tmpStr.length() - 1);
                }
                result.addElement(tmpStr);
                tmpStr = "";
                continue;
            }
            tmpStr = tmpStr + "" + s.charAt(i);
        }
        if (!tmpStr.equals("")) {
            if (tmpStr.startsWith("\"")) {
                tmpStr = tmpStr.substring(1, tmpStr.length() - 1);
            }
            result.addElement(tmpStr);
        }
        return result;
    }

    protected String modelToString(DefaultListModel m) {
        String result = "";
        for (int i = 0; i < m.size(); ++i) {
            String tmpStr;
            boolean quote;
            if (i > 0) {
                result = result + ",";
            }
            boolean bl = quote = (tmpStr = m.get(i).toString()).indexOf(",") > -1 || tmpStr.indexOf(" ") > -1;
            if (quote) {
                result = result + "\"";
            }
            for (int n = 0; n < tmpStr.length(); ++n) {
                result = tmpStr.charAt(n) == '\"' ? result + "\"\"" : result + "" + tmpStr.charAt(n);
            }
            if (!quote) continue;
            result = result + "\"";
        }
        return result;
    }

    protected void loadHistory(boolean set) {
        try {
            File file = new File(this.getHistoryFilename());
            if (file.exists()) {
                BufferedInputStream str = new BufferedInputStream(new FileInputStream(this.getHistoryFilename()));
                this.m_History.load(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (set) {
            this.m_ConnectionPanel.setHistory(this.stringToModel(this.m_History.getProperty("connection", "")));
            this.m_QueryPanel.setHistory(this.stringToModel(this.m_History.getProperty("query", "")));
            this.m_QueryPanel.setMaxRows(Integer.parseInt(this.m_History.getProperty("max_rows", "100")));
            int width = Integer.parseInt(this.m_History.getProperty(WIDTH, "0"));
            int height = Integer.parseInt(this.m_History.getProperty(HEIGHT, "0"));
            if (width != 0 && height != 0) {
                this.setPreferredSize(new Dimension(width, height));
            }
        }
    }

    protected void saveHistory() {
        try {
            BufferedOutputStream str = new BufferedOutputStream(new FileOutputStream(this.getHistoryFilename()));
            this.m_History.store(str, "SQL-Viewer-History");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveSize() {
        this.m_History.setProperty(WIDTH, "" + this.getSize().width);
        this.m_History.setProperty(HEIGHT, "" + this.getSize().height);
        this.saveHistory();
    }

    public void clear() {
        this.m_ConnectionPanel.clear();
        this.m_QueryPanel.clear();
        this.m_ResultPanel.clear();
        this.m_InfoPanel.clear();
    }

    public String getURL() {
        return this.m_URL;
    }

    public String getUser() {
        return this.m_User;
    }

    public String getPassword() {
        return this.m_Password;
    }

    public String getQuery() {
        return this.m_Query;
    }

    public void addConnectionListener(ConnectionListener l) {
        this.m_ConnectionPanel.addConnectionListener(l);
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.m_ConnectionPanel.removeConnectionListener(l);
    }

    public void addQueryExecuteListener(QueryExecuteListener l) {
        this.m_QueryPanel.addQueryExecuteListener(l);
    }

    public void removeQueryExecuteListener(QueryExecuteListener l) {
        this.m_QueryPanel.removeQueryExecuteListener(l);
    }

    public void addResultChangedListener(ResultChangedListener l) {
        this.m_ResultPanel.addResultChangedListener(l);
    }

    public void removeResultChangedListener(ResultChangedListener l) {
        this.m_ResultPanel.removeResultChangedListener(l);
    }

    public void addHistoryChangedListener(HistoryChangedListener l) {
        this.m_ConnectionPanel.addHistoryChangedListener(l);
        this.m_QueryPanel.addHistoryChangedListener(l);
    }

    public void removeHistoryChangedListener(HistoryChangedListener l) {
        this.m_ConnectionPanel.removeHistoryChangedListener(l);
        this.m_QueryPanel.removeHistoryChangedListener(l);
    }

    public static void main(String[] args) {
        Logger.log(Logger.Level.INFO, "Logging started");
        LookAndFeel.setLookAndFeel();
        try {
            final JFrame jf = new JFrame("Weka SQL-Viewer");
            m_Viewer = new SqlViewer(jf);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)m_Viewer, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    m_Viewer.saveSize();
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
            Thread memMonitor = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                2.sleep(10L);
                                if (!m_Memory.isOutOfMemory()) continue;
                                jf.dispose();
                                m_Viewer = null;
                                System.gc();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            memMonitor.setPriority(10);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

