/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class OutputZipper
implements RevisionHandler {
    File m_destination;
    DataOutputStream m_zipOut = null;
    ZipOutputStream m_zs = null;

    public OutputZipper(File destination) throws Exception {
        this.m_destination = destination;
        if (!this.m_destination.isDirectory()) {
            this.m_zs = new ZipOutputStream(new FileOutputStream(this.m_destination));
            this.m_zipOut = new DataOutputStream(this.m_zs);
        }
    }

    public void zipit(String outString, String name) throws Exception {
        if (this.m_zipOut == null) {
            File saveFile = new File(this.m_destination, name + ".gz");
            DataOutputStream dout = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(saveFile)));
            dout.writeBytes(outString);
            dout.close();
        } else {
            ZipEntry ze = new ZipEntry(name);
            this.m_zs.putNextEntry(ze);
            this.m_zipOut.writeBytes(outString);
            this.m_zs.closeEntry();
        }
    }

    public void finished() throws Exception {
        if (this.m_zipOut != null) {
            this.m_zipOut.close();
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        try {
            File testF = new File(new File(System.getProperty("user.dir")), "testOut.zip");
            OutputZipper oz = new OutputZipper(testF);
            oz.zipit("Here is some test text to be zipped", "testzip");
            oz.zipit("Here is a second entry to be zipped", "testzip2");
            oz.finished();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

