/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import weka.core.Memory;
import weka.core.converters.AbstractFileLoader;
import weka.core.logging.Logger;
import weka.gui.ComponentHelper;
import weka.gui.LookAndFeel;
import weka.gui.arffviewer.ArffViewerMainPanel;

public class ArffViewer
extends JFrame
implements WindowListener {
    static final long serialVersionUID = -7455845566922685175L;
    private ArffViewerMainPanel m_MainPanel;
    private static Memory m_Memory = new Memory(true);
    private static ArffViewer m_Viewer;
    private static boolean m_FilesLoaded;
    private static String[] m_Args;

    public ArffViewer() {
        super("ARFF-Viewer");
        this.createFrame();
    }

    protected void createFrame() {
        this.setIconImage(ComponentHelper.getImage("weka_icon.gif"));
        this.setSize(800, 600);
        this.setCenteredLocation();
        this.setDefaultCloseOperation(2);
        this.removeWindowListener(this);
        this.addWindowListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_MainPanel = new ArffViewerMainPanel(this);
        this.m_MainPanel.setConfirmExit(false);
        this.getContentPane().add((Component)this.m_MainPanel, "Center");
        this.setJMenuBar(this.m_MainPanel.getMenu());
    }

    protected int getCenteredLeft() {
        int width = this.getBounds().width;
        int x = (this.getGraphicsConfiguration().getBounds().width - width) / 2;
        if (x < 0) {
            x = 0;
        }
        return x;
    }

    protected int getCenteredTop() {
        int height = this.getBounds().height;
        int y = (this.getGraphicsConfiguration().getBounds().height - height) / 2;
        if (y < 0) {
            y = 0;
        }
        return y;
    }

    public void setCenteredLocation() {
        this.setLocation(this.getCenteredLeft(), this.getCenteredTop());
    }

    public void setConfirmExit(boolean confirm) {
        this.m_MainPanel.setConfirmExit(confirm);
    }

    public boolean getConfirmExit() {
        return this.m_MainPanel.getConfirmExit();
    }

    public void setExitOnClose(boolean value) {
        this.m_MainPanel.setExitOnClose(value);
    }

    public boolean getExitOnClose() {
        return this.m_MainPanel.getExitOnClose();
    }

    public ArffViewerMainPanel getMainPanel() {
        return this.m_MainPanel;
    }

    public void refresh() {
        this.validate();
        this.repaint();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        while (this.getMainPanel().getTabbedPane().getTabCount() > 0) {
            this.getMainPanel().closeFile(false);
        }
        if (this.getConfirmExit()) {
            int button = ComponentHelper.showMessageBox(this, "Quit - " + this.getTitle(), "Do you really want to quit?", 0, 3);
            if (button == 0) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
        if (this.getExitOnClose()) {
            System.exit(0);
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static void main(String[] args) throws Exception {
        Logger.log(Logger.Level.INFO, "Logging started");
        LookAndFeel.setLookAndFeel();
        try {
            m_Viewer = new ArffViewer();
            m_Viewer.setExitOnClose(true);
            m_Viewer.setVisible(true);
            m_FilesLoaded = false;
            m_Args = args;
            Thread memMonitor = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                if (m_Args.length > 0 && !m_FilesLoaded) {
                                    for (int i = 0; i < m_Args.length; ++i) {
                                        System.out.println("Loading " + (i + 1) + "/" + m_Args.length + ": '" + m_Args[i] + "'...");
                                        m_Viewer.getMainPanel().loadFile(m_Args[i], new AbstractFileLoader[0]);
                                    }
                                    m_Viewer.getMainPanel().getTabbedPane().setSelectedIndex(0);
                                    System.out.println("Finished!");
                                    m_FilesLoaded = true;
                                }
                                Thread.sleep(10L);
                                if (!m_Memory.isOutOfMemory()) continue;
                                m_Viewer.dispose();
                                m_Viewer = null;
                                System.gc();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nrestarting...");
                                System.gc();
                                m_Viewer = new ArffViewer();
                                m_Viewer.setExitOnClose(true);
                                m_Viewer.setVisible(true);
                            }
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            memMonitor.setPriority(5);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

