/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.EventSetDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.gui.Logger;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.HeadlessEventCollector;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextViewer
extends JPanel
implements TextListener,
DataSourceListener,
TrainingSetListener,
TestSetListener,
Visible,
UserRequestAcceptor,
BeanContextChild,
BeanCommon,
EventConstraints,
HeadlessEventCollector {
    private static final long serialVersionUID = 104838186352536832L;
    protected BeanVisual m_visual;
    private transient JFrame m_resultsFrame = null;
    protected List<EventObject> m_headlessEvents;
    private transient JTextArea m_outText = null;
    protected transient ResultHistoryPanel m_history;
    protected boolean m_design;
    protected transient BeanContext m_beanContext = null;
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);
    private Vector m_textListeners = new Vector();
    private transient Logger m_log = null;

    public TextViewer() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!ge.isHeadless()) {
            this.appearanceFinal();
        } else {
            this.m_headlessEvents = new ArrayList<EventObject>();
        }
    }

    protected void appearanceDesign() {
        this.setUpResultHistory();
        this.removeAll();
        this.m_visual = new BeanVisual("TextViewer", "weka/gui/beans/icons/DefaultText.gif", "weka/gui/beans/icons/DefaultText_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    protected void setUpFinal() {
        this.setUpResultHistory();
        JPanel holder = new JPanel();
        holder.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(this.m_outText);
        js.setBorder(BorderFactory.createTitledBorder("Text"));
        holder.add((Component)js, "Center");
        holder.add((Component)this.m_history, "West");
        this.add((Component)holder, "Center");
    }

    public String globalInfo() {
        return "General purpose text display.";
    }

    private void setUpResultHistory() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!ge.isHeadless()) {
            if (this.m_outText == null) {
                this.m_outText = new JTextArea(20, 80);
                this.m_history = new ResultHistoryPanel(this.m_outText);
            }
            this.m_outText.setEditable(false);
            this.m_outText.setFont(new Font("Monospaced", 0, 12));
            this.m_outText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_history.setBorder(BorderFactory.createTitledBorder("Result list"));
            this.m_history.setHandleRightClicks(false);
            this.m_history.getList().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                        int index = TextViewer.this.m_history.getList().locationToIndex(e.getPoint());
                        if (index != -1) {
                            String name = TextViewer.this.m_history.getNameAtIndex(index);
                            TextViewer.this.visualize(name, e.getX(), e.getY());
                        } else {
                            TextViewer.this.visualize(null, e.getX(), e.getY());
                        }
                    }
                }
            });
        }
    }

    protected void visualize(String name, int x, int y) {
        final TextViewer panel = this;
        final String selectedName = name;
        JPopupMenu resultListMenu = new JPopupMenu();
        JMenuItem visMainBuffer = new JMenuItem("View in main window");
        if (selectedName != null) {
            visMainBuffer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TextViewer.this.m_history.setSingle(selectedName);
                }
            });
        } else {
            visMainBuffer.setEnabled(false);
        }
        resultListMenu.add(visMainBuffer);
        JMenuItem visSepBuffer = new JMenuItem("View in separate window");
        if (selectedName != null) {
            visSepBuffer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TextViewer.this.m_history.openFrame(selectedName);
                }
            });
        } else {
            visSepBuffer.setEnabled(false);
        }
        resultListMenu.add(visSepBuffer);
        JMenuItem saveOutput = new JMenuItem("Save result buffer");
        if (selectedName != null) {
            saveOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SaveBuffer m_SaveOut = new SaveBuffer(null, panel);
                    StringBuffer sb = TextViewer.this.m_history.getNamedBuffer(selectedName);
                    if (sb != null) {
                        m_SaveOut.save(sb);
                    }
                }
            });
        } else {
            saveOutput.setEnabled(false);
        }
        resultListMenu.add(saveOutput);
        JMenuItem deleteOutput = new JMenuItem("Delete result buffer");
        if (selectedName != null) {
            deleteOutput.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TextViewer.this.m_history.removeResult(selectedName);
                }
            });
        } else {
            deleteOutput.setEnabled(false);
        }
        resultListMenu.add(deleteOutput);
        resultListMenu.show(this.m_history.getList(), x, y);
    }

    @Override
    public synchronized void acceptDataSet(DataSetEvent e) {
        TextEvent nt = new TextEvent(e.getSource(), e.getDataSet().toString(), e.getDataSet().relationName());
        this.acceptText(nt);
    }

    @Override
    public synchronized void acceptTrainingSet(TrainingSetEvent e) {
        TextEvent nt = new TextEvent(e.getSource(), e.getTrainingSet().toString(), e.getTrainingSet().relationName());
        this.acceptText(nt);
    }

    @Override
    public synchronized void acceptTestSet(TestSetEvent e) {
        TextEvent nt = new TextEvent(e.getSource(), e.getTestSet().toString(), e.getTestSet().relationName());
        this.acceptText(nt);
    }

    @Override
    public synchronized void acceptText(TextEvent e) {
        if (this.m_outText == null) {
            this.setUpResultHistory();
        }
        StringBuffer result = new StringBuffer();
        result.append(e.getText());
        String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
        name = name + e.getTextTitle();
        if (name.length() > 30) {
            name = name.substring(0, 30);
        }
        if (this.m_outText != null) {
            int mod = 2;
            String nameOrig = new String(name);
            while (this.m_history.getNamedBuffer(name) != null) {
                name = new String(nameOrig + "" + mod);
                ++mod;
            }
            this.m_history.addResult(name, result);
            this.m_history.setSingle(name);
        }
        if (this.m_headlessEvents != null) {
            this.m_headlessEvents.add(e);
        }
        this.notifyTextListeners(e);
    }

    @Override
    public List<EventObject> retrieveHeadlessEvents() {
        return this.m_headlessEvents;
    }

    @Override
    public void processHeadlessEvents(List<EventObject> headless) {
        if (!GraphicsEnvironment.isHeadless()) {
            for (EventObject e : headless) {
                if (!(e instanceof TextEvent)) continue;
                this.acceptText((TextEvent)e);
            }
        }
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultText.gif", "weka/gui/beans/icons/DefaultText_animated.gif");
    }

    public void showResults() {
        if (this.m_resultsFrame == null) {
            if (this.m_outText == null) {
                this.setUpResultHistory();
            }
            this.m_resultsFrame = new JFrame("Text Viewer");
            this.m_resultsFrame.getContentPane().setLayout(new BorderLayout());
            JScrollPane js = new JScrollPane(this.m_outText);
            js.setBorder(BorderFactory.createTitledBorder("Text"));
            this.m_resultsFrame.getContentPane().add((Component)js, "Center");
            this.m_resultsFrame.getContentPane().add((Component)this.m_history, "West");
            this.m_resultsFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    TextViewer.this.m_resultsFrame.dispose();
                    TextViewer.this.m_resultsFrame = null;
                }
            });
            this.m_resultsFrame.pack();
            this.m_resultsFrame.setVisible(true);
        } else {
            this.m_resultsFrame.toFront();
        }
    }

    @Override
    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        newVector.addElement("Show results");
        newVector.addElement("?Clear results");
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Show results") == 0) {
            this.showResults();
        } else if (request.compareTo("Clear results") == 0) {
            this.m_outText.setText("");
            this.m_history.clearResults();
        } else {
            throw new IllegalArgumentException(request + " not supported (TextViewer)");
        }
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bcSupport.addPropertyChangeListener(name, pcl);
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bcSupport.removePropertyChangeListener(name, pcl);
    }

    @Override
    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.addVetoableChangeListener(name, vcl);
    }

    @Override
    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.removeVetoableChangeListener(name, vcl);
    }

    @Override
    public void setBeanContext(BeanContext bc) {
        this.m_beanContext = bc;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!ge.isHeadless()) {
                this.appearanceFinal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent ge) {
        Vector l;
        TextViewer textViewer = this;
        synchronized (textViewer) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((TextListener)l.elementAt(i)).acceptText(ge);
            }
        }
    }

    @Override
    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return true;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        return eventName.equals("text");
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            TextViewer tv = new TextViewer();
            tv.acceptText(new TextEvent(tv, "Here is some test text from the main method of this class.", "The Title"));
            jf.getContentPane().add((Component)tv, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

