/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.File;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.CSVResultListener;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.OutputZipper;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;

public class RandomSplitResultProducer
implements ResultProducer,
OptionHandler,
AdditionalMeasureProducer,
RevisionHandler {
    static final long serialVersionUID = 1403798165056795073L;
    protected Instances m_Instances;
    protected ResultListener m_ResultListener = new CSVResultListener();
    protected double m_TrainPercent = 66.0;
    protected boolean m_randomize = true;
    protected SplitEvaluator m_SplitEvaluator = new ClassifierSplitEvaluator();
    protected String[] m_AdditionalMeasures = null;
    protected boolean m_debugOutput = false;
    protected OutputZipper m_ZipDest = null;
    protected File m_OutputFile = new File(new File(System.getProperty("user.dir")), "splitEvalutorOut.zip");
    public static String DATASET_FIELD_NAME = "Dataset";
    public static String RUN_FIELD_NAME = "Run";
    public static String TIMESTAMP_FIELD_NAME = "Date_time";

    public String globalInfo() {
        return "Generates a single train/test split and calls the appropriate SplitEvaluator to generate some results.";
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    public void setAdditionalMeasures(String[] additionalMeasures) {
        this.m_AdditionalMeasures = additionalMeasures;
        if (this.m_SplitEvaluator != null) {
            System.err.println("RandomSplitResultProducer: setting additional measures for split evaluator");
            this.m_SplitEvaluator.setAdditionalMeasures(this.m_AdditionalMeasures);
        }
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        if (this.m_SplitEvaluator instanceof AdditionalMeasureProducer) {
            Enumeration en = ((AdditionalMeasureProducer)((Object)this.m_SplitEvaluator)).enumerateMeasures();
            while (en.hasMoreElements()) {
                String mname = (String)en.nextElement();
                newVector.addElement(mname);
            }
        }
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (this.m_SplitEvaluator instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_SplitEvaluator)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException("RandomSplitResultProducer: Can't return value for : " + additionalMeasureName + ". " + this.m_SplitEvaluator.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    public void setResultListener(ResultListener listener) {
        this.m_ResultListener = listener;
    }

    public static Double getTimestamp() {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        double timestamp = (double)(now.get(1) * 10000 + (now.get(2) + 1) * 100 + now.get(5)) + (double)now.get(11) / 100.0 + (double)now.get(12) / 10000.0;
        return new Double(timestamp);
    }

    public void preProcess() throws Exception {
        if (this.m_SplitEvaluator == null) {
            throw new Exception("No SplitEvalutor set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        this.m_ResultListener.preProcess(this);
    }

    public void postProcess() throws Exception {
        this.m_ResultListener.postProcess(this);
        if (this.m_debugOutput && this.m_ZipDest != null) {
            this.m_ZipDest.finished();
            this.m_ZipDest = null;
        }
    }

    public void doRunKeys(int run) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        Object[] seKey = this.m_SplitEvaluator.getKey();
        Object[] key = new Object[seKey.length + 2];
        key[0] = Utils.backQuoteChars(this.m_Instances.relationName());
        key[1] = "" + run;
        System.arraycopy(seKey, 0, key, 2, seKey.length);
        if (this.m_ResultListener.isResultRequired(this, key)) {
            this.m_ResultListener.acceptResult(this, key, null);
        }
    }

    public void doRun(int run) throws Exception {
        if (this.getRawOutput() && this.m_ZipDest == null) {
            this.m_ZipDest = new OutputZipper(this.m_OutputFile);
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        Object[] seKey = this.m_SplitEvaluator.getKey();
        Object[] key = new Object[seKey.length + 2];
        key[0] = Utils.backQuoteChars(this.m_Instances.relationName());
        key[1] = "" + run;
        System.arraycopy(seKey, 0, key, 2, seKey.length);
        if (this.m_ResultListener.isResultRequired(this, key)) {
            Instances test;
            Instances train;
            Instances runInstances = new Instances(this.m_Instances);
            if (!this.m_randomize) {
                int trainSize = Utils.round((double)runInstances.numInstances() * this.m_TrainPercent / 100.0);
                int testSize = runInstances.numInstances() - trainSize;
                train = new Instances(runInstances, 0, trainSize);
                test = new Instances(runInstances, trainSize, testSize);
            } else {
                Random rand = new Random(run);
                runInstances.randomize(rand);
                if (runInstances.classAttribute().isNominal()) {
                    int i;
                    int numClasses = runInstances.numClasses();
                    Instances[] subsets = new Instances[numClasses + 1];
                    for (int i2 = 0; i2 < numClasses + 1; ++i2) {
                        subsets[i2] = new Instances(runInstances, 10);
                    }
                    Enumeration e = runInstances.enumerateInstances();
                    while (e.hasMoreElements()) {
                        Instance inst = (Instance)e.nextElement();
                        if (inst.classIsMissing()) {
                            subsets[numClasses].add(inst);
                            continue;
                        }
                        subsets[(int)inst.classValue()].add(inst);
                    }
                    for (i = 0; i < numClasses + 1; ++i) {
                        subsets[i].compactify();
                    }
                    train = new Instances(runInstances, runInstances.numInstances());
                    test = new Instances(runInstances, runInstances.numInstances());
                    for (i = 0; i < numClasses + 1; ++i) {
                        int j;
                        int trainSize = Utils.probRound((double)subsets[i].numInstances() * this.m_TrainPercent / 100.0, rand);
                        for (j = 0; j < trainSize; ++j) {
                            train.add(subsets[i].instance(j));
                        }
                        for (j = trainSize; j < subsets[i].numInstances(); ++j) {
                            test.add(subsets[i].instance(j));
                        }
                        subsets[i] = null;
                    }
                    train.compactify();
                    test.compactify();
                    train.randomize(rand);
                    test.randomize(rand);
                } else {
                    int trainSize = Utils.probRound((double)runInstances.numInstances() * this.m_TrainPercent / 100.0, rand);
                    int testSize = runInstances.numInstances() - trainSize;
                    train = new Instances(runInstances, 0, trainSize);
                    test = new Instances(runInstances, trainSize, testSize);
                }
            }
            Object[] seResults = this.m_SplitEvaluator.getResult(train, test);
            Object[] results = new Object[seResults.length + 1];
            results[0] = RandomSplitResultProducer.getTimestamp();
            System.arraycopy(seResults, 0, results, 1, seResults.length);
            if (this.m_debugOutput) {
                String resultName = ("" + run + "." + Utils.backQuoteChars(runInstances.relationName()) + "." + this.m_SplitEvaluator.toString()).replace(' ', '_');
                resultName = Utils.removeSubstring(resultName, "weka.classifiers.");
                resultName = Utils.removeSubstring(resultName, "weka.filters.");
                resultName = Utils.removeSubstring(resultName, "weka.attributeSelection.");
                this.m_ZipDest.zipit(this.m_SplitEvaluator.getRawResultOutput(), resultName);
            }
            this.m_ResultListener.acceptResult(this, key, results);
        }
    }

    public String[] getKeyNames() {
        String[] keyNames = this.m_SplitEvaluator.getKeyNames();
        String[] newKeyNames = new String[keyNames.length + 2];
        newKeyNames[0] = DATASET_FIELD_NAME;
        newKeyNames[1] = RUN_FIELD_NAME;
        System.arraycopy(keyNames, 0, newKeyNames, 2, keyNames.length);
        return newKeyNames;
    }

    public Object[] getKeyTypes() {
        Object[] keyTypes = this.m_SplitEvaluator.getKeyTypes();
        Object[] newKeyTypes = new String[keyTypes.length + 2];
        newKeyTypes[0] = new String();
        newKeyTypes[1] = new String();
        System.arraycopy(keyTypes, 0, newKeyTypes, 2, keyTypes.length);
        return newKeyTypes;
    }

    public String[] getResultNames() {
        String[] resultNames = this.m_SplitEvaluator.getResultNames();
        String[] newResultNames = new String[resultNames.length + 1];
        newResultNames[0] = TIMESTAMP_FIELD_NAME;
        System.arraycopy(resultNames, 0, newResultNames, 1, resultNames.length);
        return newResultNames;
    }

    public Object[] getResultTypes() {
        Object[] resultTypes = this.m_SplitEvaluator.getResultTypes();
        Object[] newResultTypes = new Object[resultTypes.length + 1];
        newResultTypes[0] = new Double(0.0);
        System.arraycopy(resultTypes, 0, newResultTypes, 1, resultTypes.length);
        return newResultTypes;
    }

    public String getCompatibilityState() {
        String result = "-P " + this.m_TrainPercent;
        if (!this.getRandomizeData()) {
            result = result + " -R";
        }
        result = this.m_SplitEvaluator == null ? result + " <null SplitEvaluator>" : result + " -W " + this.m_SplitEvaluator.getClass().getName();
        return result + " --";
    }

    public String outputFileTipText() {
        return "Set the destination for saving raw output. If the rawOutput option is selected, then output from the splitEvaluator for individual train-test splits is saved. If the destination is a directory, then each output is saved to an individual gzip file; if the destination is a file, then each output is saved as an entry in a zip file.";
    }

    public File getOutputFile() {
        return this.m_OutputFile;
    }

    public void setOutputFile(File newOutputFile) {
        this.m_OutputFile = newOutputFile;
    }

    public String randomizeDataTipText() {
        return "Do not randomize dataset and do not perform probabilistic rounding if false";
    }

    public boolean getRandomizeData() {
        return this.m_randomize;
    }

    public void setRandomizeData(boolean d) {
        this.m_randomize = d;
    }

    public String rawOutputTipText() {
        return "Save raw output (useful for debugging). If set, then output is sent to the destination specified by outputFile";
    }

    public boolean getRawOutput() {
        return this.m_debugOutput;
    }

    public void setRawOutput(boolean d) {
        this.m_debugOutput = d;
    }

    public String trainPercentTipText() {
        return "Set the percentage of data to use for training.";
    }

    public double getTrainPercent() {
        return this.m_TrainPercent;
    }

    public void setTrainPercent(double newTrainPercent) {
        this.m_TrainPercent = newTrainPercent;
    }

    public String splitEvaluatorTipText() {
        return "The evaluator to apply to the test data. This may be a classifier, regression scheme etc.";
    }

    public SplitEvaluator getSplitEvaluator() {
        return this.m_SplitEvaluator;
    }

    public void setSplitEvaluator(SplitEvaluator newSplitEvaluator) {
        this.m_SplitEvaluator = newSplitEvaluator;
        this.m_SplitEvaluator.setAdditionalMeasures(this.m_AdditionalMeasures);
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(5);
        newVector.addElement(new Option("\tThe percentage of instances to use for training.\n\t(default 66)", "P", 1, "-P <percent>"));
        newVector.addElement(new Option("Save raw split evaluator output.", "D", 0, "-D"));
        newVector.addElement(new Option("\tThe filename where raw output will be stored.\n\tIf a directory name is specified then then individual\n\toutputs will be gzipped, otherwise all output will be\n\tzipped to the named file. Use in conjuction with -D.\t(default splitEvalutorOut.zip)", "O", 1, "-O <file/directory name/path>"));
        newVector.addElement(new Option("\tThe full class name of a SplitEvaluator.\n\teg: weka.experiment.ClassifierSplitEvaluator", "W", 1, "-W <class name>"));
        newVector.addElement(new Option("\tSet when data is not to be randomized and the data sets' size.\n\tIs not to be determined via probabilistic rounding.", "R", 0, "-R"));
        if (this.m_SplitEvaluator != null && this.m_SplitEvaluator instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to split evaluator " + this.m_SplitEvaluator.getClass().getName() + ":"));
            Enumeration enu = ((OptionHandler)((Object)this.m_SplitEvaluator)).listOptions();
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String trainPct;
        this.setRawOutput(Utils.getFlag('D', options));
        this.setRandomizeData(!Utils.getFlag('R', options));
        String fName = Utils.getOption('O', options);
        if (fName.length() != 0) {
            this.setOutputFile(new File(fName));
        }
        if ((trainPct = Utils.getOption('P', options)).length() != 0) {
            this.setTrainPercent(new Double(trainPct));
        } else {
            this.setTrainPercent(66.0);
        }
        String seName = Utils.getOption('W', options);
        if (seName.length() == 0) {
            throw new Exception("A SplitEvaluator must be specified with the -W option.");
        }
        this.setSplitEvaluator((SplitEvaluator)Utils.forName(SplitEvaluator.class, seName, null));
        if (this.getSplitEvaluator() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getSplitEvaluator())).setOptions(Utils.partitionOptions(options));
        }
    }

    public String[] getOptions() {
        String[] seOptions = new String[]{};
        if (this.m_SplitEvaluator != null && this.m_SplitEvaluator instanceof OptionHandler) {
            seOptions = ((OptionHandler)((Object)this.m_SplitEvaluator)).getOptions();
        }
        String[] options = new String[seOptions.length + 9];
        int current = 0;
        options[current++] = "-P";
        options[current++] = "" + this.getTrainPercent();
        if (this.getRawOutput()) {
            options[current++] = "-D";
        }
        if (!this.getRandomizeData()) {
            options[current++] = "-R";
        }
        options[current++] = "-O";
        options[current++] = this.getOutputFile().getName();
        if (this.getSplitEvaluator() != null) {
            options[current++] = "-W";
            options[current++] = this.getSplitEvaluator().getClass().getName();
        }
        options[current++] = "--";
        System.arraycopy(seOptions, 0, options, current, seOptions.length);
        current += seOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        String result = "RandomSplitResultProducer: ";
        result = result + this.getCompatibilityState();
        result = this.m_Instances == null ? result + ": <null Instances>" : result + ": " + Utils.backQuoteChars(this.m_Instances.relationName());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6256 $");
    }
}

