/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.packageManagement;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.pentaho.packageManagement.DefaultPackage;
import org.pentaho.packageManagement.Dependency;
import org.pentaho.packageManagement.Package;
import org.pentaho.packageManagement.PackageConstraint;
import org.pentaho.packageManagement.PackageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPackageManager
extends PackageManager {
    static final int BUFF_SIZE = 100000;
    static final byte[] m_buffer = new byte[100000];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected File downloadPackage(URL packageURL, PrintStream ... progress) throws Exception {
        String packageArchiveName = packageURL.toString();
        packageArchiveName = packageArchiveName.substring(0, packageArchiveName.lastIndexOf(".zip") + 3);
        packageArchiveName = packageArchiveName.substring(0, packageArchiveName.lastIndexOf(46));
        packageArchiveName = packageArchiveName.substring(packageArchiveName.lastIndexOf(47), packageArchiveName.length());
        File tmpDownload = File.createTempFile(packageArchiveName, ".zip");
        int i = 0;
        while (i < progress.length) {
            progress[i].println(packageURL.toString());
            progress[i].println("[DefaultPackageManager] Tmp file: " + tmpDownload.toString());
            ++i;
        }
        URLConnection conn = null;
        conn = this.setProxyAuthentication() ? packageURL.openConnection(this.m_httpProxy) : packageURL.openConnection();
        BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
        BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(tmpDownload));
        while (true) {
            byte[] byArray = m_buffer;
            // MONITORENTER : m_buffer
            int amountRead = bi.read(m_buffer);
            if (amountRead == -1) {
                // MONITOREXIT : byArray
                break;
            }
            bo.write(m_buffer, 0, amountRead);
            // MONITOREXIT : byArray
        }
        bi.close();
        bo.close();
        return tmpDownload;
    }

    @Override
    public Package getURLPackageInfo(URL packageURL) throws Exception {
        File downloaded = this.downloadPackage(packageURL, new PrintStream[0]);
        return this.getPackageArchiveInfo(downloaded);
    }

    @Override
    public Package getRepositoryPackageInfo(String packageName) throws Exception {
        return this.getRepositoryPackageInfo(packageName, "Latest");
    }

    @Override
    public List<Object> getRepositoryPackageVersions(String packageName) throws Exception {
        String versionNumber;
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String versionsS = String.valueOf(this.m_packageRepository.toString()) + "/" + packageName + "/" + "versions.txt";
        URL packageURL = new URL(versionsS);
        URLConnection conn = null;
        conn = this.setProxyAuthentication() ? packageURL.openConnection(this.m_httpProxy) : packageURL.openConnection();
        BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        ArrayList<Object> versions = new ArrayList<Object>();
        while ((versionNumber = bi.readLine()) != null) {
            versions.add(versionNumber.trim());
        }
        bi.close();
        return versions;
    }

    @Override
    public Package getRepositoryPackageInfo(String packageName, Object version) throws Exception {
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        if (version == null) {
            version = "Latest";
        }
        String packageS = String.valueOf(this.m_packageRepository.toString()) + "/" + packageName + "/" + version.toString() + ".props";
        URL packageURL = new URL(packageS);
        URLConnection conn = null;
        conn = this.setProxyAuthentication() ? packageURL.openConnection(this.m_httpProxy) : packageURL.openConnection();
        BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
        Properties packageProperties = new Properties();
        packageProperties.load(bi);
        bi.close();
        return new DefaultPackage(this.m_packageHome, this, packageProperties);
    }

    private Package getPackageArchiveInfo(File packageArchive) throws Exception {
        return this.getPackageArchiveInfo(packageArchive.getAbsolutePath());
    }

    @Override
    public Package getPackageArchiveInfo(String packageArchivePath) throws Exception {
        ZipFile zip = new ZipFile(new File(packageArchivePath));
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().endsWith("Description.props")) continue;
            InputStream is = zip.getInputStream(entry);
            Properties packageProperties = new Properties();
            packageProperties.load(new BufferedInputStream(is));
            is.close();
            DefaultPackage pkg = new DefaultPackage(this.m_packageHome, this, packageProperties);
            return pkg;
        }
        throw new Exception("Unable to find Description file in package archive!");
    }

    @Override
    public Package getInstalledPackageInfo(String packageName) throws Exception {
        File packageDescription = new File(this.m_packageHome.getAbsoluteFile() + File.separator + packageName + File.separator + "Description.props");
        if (!packageDescription.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(packageDescription);
        Properties packageProperties = new Properties();
        packageProperties.load(fis);
        fis.close();
        DefaultPackage pkg = new DefaultPackage(this.m_packageHome, this, packageProperties);
        return pkg;
    }

    protected boolean establishPackageHome() {
        if (this.m_packageHome == null) {
            return false;
        }
        if (!this.m_packageHome.exists() && !this.m_packageHome.mkdir()) {
            System.err.println("Unable to create packages directory (" + this.m_packageHome.getAbsolutePath() + ")");
            return false;
        }
        return true;
    }

    public static void deleteDir(File dir, PrintStream ... progress) throws Exception {
        File[] contents = dir.listFiles();
        if (contents.length != 0) {
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    DefaultPackageManager.deleteDir(f, new PrintStream[0]);
                } else {
                    int i = 0;
                    while (i < progress.length) {
                        progress[i].println("[DefaultPackageManager] removing: " + f.toString());
                        ++i;
                    }
                    if (!f.delete()) {
                        System.err.println("[DefaultPackageManager] can't delete file " + f.toString());
                        f.deleteOnExit();
                    }
                }
                ++n2;
            }
        }
        if (!dir.delete()) {
            System.err.println("[DefaultPackageManager] can't delete directory " + dir.toString());
            dir.deleteOnExit();
        }
        int i = 0;
        while (i < progress.length) {
            progress[i].println("[DefaultPackageManager] removing: " + dir.toString());
            ++i;
        }
    }

    @Override
    public void uninstallPackage(String packageName, PrintStream ... progress) throws Exception {
        File packageToDel = new File(String.valueOf(this.m_packageHome.toString()) + File.separator + packageName);
        if (!packageToDel.exists()) {
            throw new Exception("[DefaultPackageManager] Can't remove " + packageName + " because it doesn't seem to be installed!");
        }
        DefaultPackageManager.deleteDir(packageToDel, progress);
    }

    @Override
    public String installPackageFromArchive(String packageArchivePath, PrintStream ... progress) throws Exception {
        Properties packageProps = (Properties)this.getPackageArchiveInfo(packageArchivePath).getPackageMetaData();
        String packageName = packageProps.getProperty("PackageName");
        if (packageName == null) {
            throw new Exception("Unable to find the name of the package in the Description file for " + packageArchivePath);
        }
        this.installPackage(packageArchivePath, packageName, progress);
        return packageName;
    }

    @Override
    public void installPackages(List<Package> toInstall, PrintStream ... progress) throws Exception {
        File[] archivePaths = new File[toInstall.size()];
        int i = 0;
        while (i < toInstall.size()) {
            Package toDownload = toInstall.get(i);
            archivePaths[i] = this.downloadPackage(toDownload.getPackageURL(), progress);
            ++i;
        }
        i = 0;
        while (i < archivePaths.length) {
            this.installPackageFromArchive(archivePaths[i].getAbsolutePath(), progress);
            ++i;
        }
    }

    protected static boolean checkDependencies(PackageConstraint toCheck, Map<String, Dependency> lookup, Map<String, List<Dependency>> conflicts) throws Exception {
        boolean ok = true;
        List<Dependency> deps = toCheck.getPackage().getDependencies();
        for (Dependency p : deps) {
            String depName = p.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString();
            if (!lookup.containsKey(depName)) {
                lookup.put(depName, p);
                ok = DefaultPackageManager.checkDependencies(p.getTarget(), lookup, conflicts);
                continue;
            }
            Dependency checkAgainst = lookup.get(depName);
            PackageConstraint result = checkAgainst.getTarget().checkConstraint(p.getTarget());
            if (result != null) {
                checkAgainst.setTarget(result);
                lookup.put(depName, checkAgainst);
                continue;
            }
            List<Dependency> conflictList = conflicts.get(depName);
            conflictList.add(p);
            ok = false;
        }
        return ok;
    }

    @Override
    public List<Dependency> getAllDependenciesForPackage(Package target, Map<String, List<Dependency>> conflicts) throws Exception {
        List<Dependency> initialList = target.getDependencies();
        HashMap<String, Dependency> lookup = new HashMap<String, Dependency>();
        for (Dependency d : initialList) {
            lookup.put(d.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString(), d);
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            deps.add(d);
            conflicts.put(d.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString(), deps);
        }
        for (Dependency d : initialList) {
            DefaultPackageManager.checkDependencies(d.getTarget(), lookup, conflicts);
        }
        ArrayList<Dependency> fullList = new ArrayList<Dependency>(lookup.values());
        ArrayList<String> removeList = new ArrayList<String>();
        for (String key : conflicts.keySet()) {
            List<Dependency> tempD = conflicts.get(key);
            if (tempD.size() != 1) continue;
            removeList.add(key);
        }
        for (String s : removeList) {
            conflicts.remove(s);
        }
        return fullList;
    }

    @Override
    public void installPackageFromRepository(String packageName, Object version, PrintStream ... progress) throws Exception {
        Package toInstall = this.getRepositoryPackageInfo(packageName, version);
        String urlString = toInstall.getPackageMetaDataElement("PackageURL").toString();
        URL packageURL = new URL(urlString);
        this.installPackageFromURL(packageURL, progress);
    }

    @Override
    public String installPackageFromURL(URL packageURL, PrintStream ... progress) throws Exception {
        File downloaded = this.downloadPackage(packageURL, progress);
        return this.installPackageFromArchive(downloaded.getAbsolutePath(), progress);
    }

    private static void copyStreams(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] data = new byte[1024];
        while ((count = input.read(data, 0, 1024)) != -1) {
            output.write(data, 0, count);
        }
    }

    protected void installPackage(String packageArchivePath, String packageName, PrintStream ... progress) throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to install " + packageArchivePath + " because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        File destDir = new File(this.m_packageHome, packageName);
        destDir.mkdir();
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        ZipFile zipFile = new ZipFile(packageArchivePath);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) {
                new File(destDir, zipEntry.getName()).mkdir();
                continue;
            }
            int i = 0;
            while (i < progress.length) {
                progress[i].println("[DefaultPackageManager] Installing: " + zipEntry.getName());
                ++i;
            }
            input = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            File destFile = new File(destDir, zipEntry.getName());
            FileOutputStream fos = new FileOutputStream(destFile);
            output = new BufferedOutputStream(fos);
            DefaultPackageManager.copyStreams(input, output);
            ((InputStream)input).close();
            ((OutputStream)output).flush();
            ((OutputStream)output).close();
        }
    }

    private URLConnection getConnection(String urlString) throws IOException {
        URL connURL = new URL(urlString);
        URLConnection conn = null;
        conn = this.setProxyAuthentication() ? connURL.openConnection(this.m_httpProxy) : connURL.openConnection();
        conn.setConnectTimeout(60000);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void transToBAOS(BufferedInputStream bi, ByteArrayOutputStream bos) throws Exception {
        while (true) {
            byte[] byArray = m_buffer;
            // MONITORENTER : m_buffer
            int amountRead = bi.read(m_buffer);
            if (amountRead == -1) {
                // MONITOREXIT : byArray
                break;
            }
            bos.write(m_buffer, 0, amountRead);
            // MONITOREXIT : byArray
        }
        bi.close();
    }

    private void writeZipEntryForPackage(String packageName, ZipOutputStream zos) throws Exception {
        ZipEntry packageDir = new ZipEntry(String.valueOf(packageName) + "/");
        zos.putNextEntry(packageDir);
        ZipEntry z = new ZipEntry(String.valueOf(packageName) + "/Latest.props");
        ZipEntry z2 = new ZipEntry(String.valueOf(packageName) + "/Latest.html");
        URLConnection conn = this.getConnection(String.valueOf(this.m_packageRepository.toString()) + "/" + packageName + "/Latest.props");
        BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z);
        zos.write(bos.toByteArray());
        conn = this.getConnection(String.valueOf(this.m_packageRepository.toString()) + "/" + packageName + "/Latest.html");
        bi = new BufferedInputStream(conn.getInputStream());
        bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z2);
        zos.write(bos.toByteArray());
        z = new ZipEntry(String.valueOf(packageName) + "/versions.txt");
        conn = this.getConnection(String.valueOf(this.m_packageRepository.toString()) + "/" + packageName + "/versions.txt");
        bi = new BufferedInputStream(conn.getInputStream());
        bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z);
        zos.write(bos.toByteArray());
        z = new ZipEntry(String.valueOf(packageName) + "/index.html");
        conn = this.getConnection(String.valueOf(this.m_packageRepository.toString()) + "/" + packageName + "/index.html");
        bi = new BufferedInputStream(conn.getInputStream());
        bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z);
        zos.write(bos.toByteArray());
        List<Object> versions = this.getRepositoryPackageVersions(packageName);
        for (Object o : versions) {
            conn = this.getConnection(String.valueOf(this.m_packageRepository.toString()) + "/" + packageName + "/" + o.toString() + ".props");
            z = new ZipEntry(String.valueOf(packageName) + "/" + o.toString() + ".props");
            bi = new BufferedInputStream(conn.getInputStream());
            bos = new ByteArrayOutputStream();
            this.transToBAOS(bi, bos);
            zos.putNextEntry(z);
            zos.write(bos.toByteArray());
            conn = this.getConnection(String.valueOf(this.m_packageRepository.toString()) + "/" + packageName + "/" + o.toString() + ".html");
            z = new ZipEntry(String.valueOf(packageName) + "/" + o.toString() + ".html");
            bi = new BufferedInputStream(conn.getInputStream());
            bos = new ByteArrayOutputStream();
            this.transToBAOS(bi, bos);
            zos.putNextEntry(z);
            zos.write(bos.toByteArray());
        }
    }

    @Override
    public byte[] getRepositoryPackageMetaDataOnlyAsZip(PrintStream ... progress) throws Exception {
        String imageName;
        String packageName;
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String packageList = String.valueOf(this.m_packageRepository.toString()) + "/packageList.txt";
        URLConnection conn = null;
        conn = this.getConnection(packageList);
        BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        while ((packageName = bi.readLine()) != null) {
            PrintStream[] printStreamArray = progress;
            int n = progress.length;
            int n2 = 0;
            while (n2 < n) {
                PrintStream p = printStreamArray[n2];
                p.println("Fetching meta data for " + packageName);
                ++n2;
            }
            this.writeZipEntryForPackage(packageName, zos);
        }
        bi.close();
        conn = this.getConnection(packageList);
        ZipEntry z = new ZipEntry("packageList.txt");
        BufferedInputStream bi2 = new BufferedInputStream(conn.getInputStream());
        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
        this.transToBAOS(bi2, bos2);
        zos.putNextEntry(z);
        zos.write(bos2.toByteArray());
        bi2.close();
        String imageList = String.valueOf(this.m_packageRepository.toString()) + "/images.txt";
        conn = this.getConnection(imageList);
        bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((imageName = bi.readLine()) != null) {
            z = new ZipEntry(imageName);
            URLConnection conn2 = this.getConnection(String.valueOf(this.m_packageRepository.toString()) + "/" + imageName);
            bi2 = new BufferedInputStream(conn2.getInputStream());
            bos2 = new ByteArrayOutputStream();
            this.transToBAOS(bi2, bos2);
            zos.putNextEntry(z);
            zos.write(bos2.toByteArray());
            bi2.close();
        }
        conn = this.getConnection(imageList);
        z = new ZipEntry("images.txt");
        bi2 = new BufferedInputStream(conn.getInputStream());
        bos2 = new ByteArrayOutputStream();
        this.transToBAOS(bi2, bos2);
        zos.putNextEntry(z);
        zos.write(bos2.toByteArray());
        bi2.close();
        zos.close();
        return bos.toByteArray();
    }

    @Override
    public List<Package> getAllPackages(PrintStream ... progress) throws Exception {
        String packageName;
        ArrayList<Package> allPackages = new ArrayList<Package>();
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String packageList = String.valueOf(this.m_packageRepository.toString()) + "/packageList.txt";
        URL packageListURL = new URL(packageList);
        URLConnection conn = null;
        conn = this.setProxyAuthentication() ? packageListURL.openConnection(this.m_httpProxy) : packageListURL.openConnection();
        BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((packageName = bi.readLine()) != null) {
            Package temp = this.getRepositoryPackageInfo(packageName);
            allPackages.add(temp);
        }
        return allPackages;
    }

    @Override
    public List<Package> getAvailablePackages() throws Exception {
        List<Package> allP = this.getAllPackages(new PrintStream[0]);
        ArrayList<Package> available = new ArrayList<Package>();
        int i = 0;
        while (i < allP.size()) {
            if (!allP.get(i).isInstalled()) {
                available.add(allP.get(i));
            }
            ++i;
        }
        return available;
    }

    @Override
    public List<Package> getInstalledPackages() throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to get list of installed packages because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        ArrayList<Package> installedP = new ArrayList<Package>();
        File[] contents = this.m_packageHome.listFiles();
        int i = 0;
        while (i < contents.length) {
            File description;
            if (contents[i].isDirectory() && (description = new File(String.valueOf(contents[i].getAbsolutePath()) + File.separator + "Description.props")).exists()) {
                try {
                    Properties packageProperties = new Properties();
                    BufferedInputStream bi = new BufferedInputStream(new FileInputStream(description));
                    packageProperties.load(bi);
                    bi.close();
                    bi = null;
                    DefaultPackage pkg = new DefaultPackage(this.m_packageHome, this, packageProperties);
                    installedP.add(pkg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return installedP;
    }

    protected static String padLeft(String inString, int length) {
        return DefaultPackageManager.fixStringLength(inString, length, false);
    }

    protected static String padRight(String inString, int length) {
        return DefaultPackageManager.fixStringLength(inString, length, true);
    }

    private static String fixStringLength(String inString, int length, boolean right) {
        if (inString.length() < length) {
            while (inString.length() < length) {
                String string = inString = right ? inString.concat(" ") : " ".concat(inString);
            }
        } else if (inString.length() > length) {
            inString = inString.substring(0, length);
        }
        return inString;
    }

    public static void main(String[] args) {
        try {
            URL url = new URL(args[0]);
            DefaultPackageManager pm = new DefaultPackageManager();
            pm.downloadPackage(url, System.out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

