/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.hierarchyvisualizer;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JFrame;
import weka.gui.visualize.PrintablePanel;

public class HierarchyVisualizer
extends PrintablePanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    String m_sNewick;
    Node m_tree;
    int m_nLeafs;
    double m_fHeight;
    double m_fScaleX = 10.0;
    double m_fScaleY = 10.0;
    double m_fTmpLength;

    public HierarchyVisualizer(String sNewick) {
        try {
            this.parseNewick(sNewick);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        this.addComponentListener(this);
    }

    int positionLeafs(Node node, int nPosX) {
        if (node.isLeaf()) {
            node.m_fPosX = (double)nPosX + 0.5;
            return ++nPosX;
        }
        for (int i = 0; i < node.m_children.length; ++i) {
            nPosX = this.positionLeafs(node.m_children[i], nPosX);
        }
        return nPosX;
    }

    double positionRest(Node node) {
        if (node.isLeaf()) {
            return node.m_fPosX;
        }
        double fPosX = 0.0;
        for (int i = 0; i < node.m_children.length; ++i) {
            fPosX += this.positionRest(node.m_children[i]);
        }
        node.m_fPosX = fPosX /= (double)node.m_children.length;
        return fPosX;
    }

    double positionHeight(Node node, double fOffSet) {
        if (node.isLeaf()) {
            node.m_fPosY = fOffSet + node.m_fLength;
            return node.m_fPosY;
        }
        double fPosY = fOffSet + node.m_fLength;
        double fYMax = 0.0;
        for (int i = 0; i < node.m_children.length; ++i) {
            fYMax = Math.max(fYMax, this.positionHeight(node.m_children[i], fPosY));
        }
        node.m_fPosY = fPosY;
        return fYMax;
    }

    int nextNode(String sStr, int i) {
        int nBraces = 0;
        char c = sStr.charAt(i);
        do {
            if (++i >= sStr.length()) continue;
            c = sStr.charAt(i);
            if (c == '[') {
                while (i < sStr.length() && sStr.charAt(i) != ']') {
                    ++i;
                }
                if (++i < sStr.length()) {
                    c = sStr.charAt(i);
                }
            }
            switch (c) {
                case '(': {
                    ++nBraces;
                    break;
                }
                case ')': {
                    --nBraces;
                    break;
                }
            }
        } while (i < sStr.length() && (nBraces > 0 || c != ',' && c != ')' && c != '('));
        if (i >= sStr.length() || nBraces < 0) {
            return -1;
        }
        if (sStr.charAt(i) == ')') {
            if (sStr.charAt(++i) == '[') {
                while (i < sStr.length() && sStr.charAt(i) != ']') {
                    ++i;
                }
                if (++i >= sStr.length()) {
                    return -1;
                }
            }
            if (sStr.charAt(i) == ':') {
                c = sStr.charAt(++i);
                while (i < sStr.length() && (c == '.' || Character.isDigit(c))) {
                    if (++i >= sStr.length()) continue;
                    c = sStr.charAt(i);
                }
            }
        }
        return i;
    }

    void parseNewick(String sNewick) throws Exception {
        this.m_sNewick = sNewick;
        int i = this.m_sNewick.indexOf(40);
        if (i > 0) {
            this.m_sNewick = this.m_sNewick.substring(i);
        }
        System.err.println(this.m_sNewick);
        this.m_tree = this.parseNewick2(this.m_sNewick);
        System.err.println(this.m_tree.toString());
        this.m_nLeafs = this.positionLeafs(this.m_tree, 0);
        this.positionRest(this.m_tree);
        this.m_fHeight = this.positionHeight(this.m_tree, 0.0);
    }

    Node parseNewick2(String sStr) throws Exception {
        if (sStr == null || sStr.length() == 0) {
            return null;
        }
        Node node = new Node();
        if (sStr.startsWith("(")) {
            int i1 = this.nextNode(sStr, 0);
            int i2 = this.nextNode(sStr, i1);
            node.m_children = new Node[2];
            node.m_children[0] = this.parseNewick2(sStr.substring(1, i1));
            node.m_children[0].m_Parent = node;
            String sStr2 = sStr.substring(i1 + 1, i2 > 0 ? i2 : sStr.length());
            node.m_children[1] = this.parseNewick2(sStr2);
            node.m_children[1].m_Parent = node;
            if (sStr.lastIndexOf(91) > sStr.lastIndexOf(41)) {
                i2 = (sStr = sStr.substring(sStr.lastIndexOf(91))).indexOf(93);
                if (i2 < 0) {
                    throw new Exception("unbalanced square bracket found:" + sStr);
                }
                node.m_sMetaData = sStr2 = sStr.substring(1, i2);
            }
            if (sStr.lastIndexOf(58) > sStr.lastIndexOf(41)) {
                sStr = sStr.substring(sStr.lastIndexOf(58));
                sStr = sStr.replaceAll("[,\\):]", "");
                node.m_fLength = new Double(sStr);
            } else {
                node.m_fLength = 1.0;
            }
        } else {
            if (sStr.contains("[")) {
                int i1 = sStr.indexOf(91);
                int i2 = sStr.indexOf(93);
                if (i2 < 0) {
                    throw new Exception("unbalanced square bracket found:" + sStr);
                }
                String sStr2 = sStr.substring(i1 + 1, i2);
                sStr = sStr.substring(0, i1) + sStr.substring(i2 + 1);
                node.m_sMetaData = sStr2;
            }
            if (sStr.indexOf(41) >= 0) {
                sStr = sStr.substring(0, sStr.indexOf(41));
            }
            if ((sStr = sStr.replaceFirst("[,\\)]", "")).length() > 0) {
                if (sStr.indexOf(58) >= 0) {
                    int iColon = sStr.indexOf(58);
                    node.m_sLabel = sStr.substring(0, iColon);
                    if (sStr.indexOf(58, iColon + 1) >= 0) {
                        int iColon2 = sStr.indexOf(58, iColon + 1);
                        node.m_fLength = new Double(sStr.substring(iColon + 1, iColon2));
                        this.m_fTmpLength = new Double(sStr.substring(iColon2 + 1));
                    } else {
                        node.m_fLength = new Double(sStr.substring(iColon + 1));
                    }
                } else {
                    node.m_sLabel = sStr;
                    node.m_fLength = 1.0;
                }
            } else {
                return null;
            }
        }
        return node;
    }

    public void fitToScreen() {
        this.m_fScaleX = 10.0;
        int nW = this.getWidth();
        if (this.m_nLeafs > 0) {
            this.m_fScaleX = nW / this.m_nLeafs;
        }
        this.m_fScaleY = 10.0;
        int nH = this.getHeight();
        if (this.m_fHeight > 0.0) {
            this.m_fScaleY = (double)(nH - 10) / this.m_fHeight;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Color oldBackground = ((Graphics2D)g).getBackground();
        ((Graphics2D)g).setBackground(Color.WHITE);
        g.clearRect(0, 0, this.getSize().width, this.getSize().height);
        ((Graphics2D)g).setBackground(oldBackground);
        g.setClip(3, 7, this.getWidth() - 6, this.getHeight() - 10);
        this.m_tree.draw(g);
        g.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.fitToScreen();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public static void main(String[] args) {
        HierarchyVisualizer a = new HierarchyVisualizer(" (((5[theta=0.121335,lxg=0.122437]:0.00742795,3[theta=0.0972485,lxg=0.152762]:0.00742795)[theta=0.490359,lxg=0.0746703]:0.0183076,((2[theta=0.0866056,lxg=0.2295]:0.00993801,4[theta=0.135512,lxg=0.146674]:0.00993801)[theta=0.897783,lxg=0.0200762]:0.00901206,1[theta=0.200265,lxg=0.18925]:0.0189501)[theta=0.0946195,lxg=0.143427]:0.00678551)[theta=0.185562,lxg=0.139681]:0.0129598,(7[theta=0.176022,lxg=0.364039]:0.0320395,((0[theta=0.224286,lxg=0.156485]:0.0175487,8[theta=0.223313,lxg=0.157166]:0.0175487)[theta=0.631287,lxg=0.024042]:0.00758871,6[theta=0.337871,lxg=0.148799]:0.0251374)[theta=0.33847,lxg=0.040784]:0.00690208)[theta=0.209238,lxg=0.0636202]:0.00665587)[theta=0.560453,lxg=-0.138086]:0.01");
        a.setSize(800, 600);
        JFrame f = new JFrame();
        Container contentPane = f.getContentPane();
        contentPane.add(a);
        f.setDefaultCloseOperation(2);
        f.setSize(800, 600);
        f.setVisible(true);
        a.fitToScreen();
    }

    class Node {
        double m_fLength = -1.0;
        double m_fPosX = 0.0;
        double m_fPosY = 0.0;
        String m_sLabel;
        String m_sMetaData;
        Node[] m_children;
        Node m_Parent = null;

        Node() {
        }

        Node getParent() {
            return this.m_Parent;
        }

        void setParent(Node parent) {
            this.m_Parent = parent;
        }

        boolean isRoot() {
            return this.m_Parent == null;
        }

        boolean isLeaf() {
            return this.m_children == null;
        }

        int getChildCount() {
            if (this.m_children == null) {
                return 0;
            }
            return this.m_children.length;
        }

        Node getChild(int iChild) {
            return this.m_children[iChild];
        }

        int getNodeCount() {
            if (this.m_children == null) {
                return 1;
            }
            int n = 1;
            for (int i = 0; i < this.m_children.length; ++i) {
                n += this.m_children[i].getNodeCount();
            }
            return n;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.m_children != null) {
                buf.append("(");
                for (int i = 0; i < this.m_children.length - 1; ++i) {
                    buf.append(this.m_children[i].toString());
                    buf.append(',');
                }
                buf.append(this.m_children[this.m_children.length - 1].toString());
                buf.append(")");
            } else {
                buf.append(this.m_sLabel);
            }
            if (this.m_sMetaData != null) {
                buf.append('[');
                buf.append(this.m_sMetaData);
                buf.append(']');
            }
            buf.append(":" + this.m_fLength);
            return buf.toString();
        }

        double draw(Graphics g) {
            if (this.isLeaf()) {
                int x = (int)(this.m_fPosX * HierarchyVisualizer.this.m_fScaleX);
                int y = (int)(this.m_fPosY * HierarchyVisualizer.this.m_fScaleY);
                g.drawString(this.m_sLabel, x, y);
                g.drawLine((int)(this.m_fPosX * HierarchyVisualizer.this.m_fScaleX), (int)(this.m_fPosY * HierarchyVisualizer.this.m_fScaleY), (int)(this.m_fPosX * HierarchyVisualizer.this.m_fScaleX), (int)((this.m_fPosY - this.m_fLength) * HierarchyVisualizer.this.m_fScaleY));
            } else {
                double fPosX1 = Double.MAX_VALUE;
                double fPosX2 = -1.7976931348623157E308;
                for (int i = 0; i < this.m_children.length; ++i) {
                    double f = this.m_children[i].draw(g);
                    if (f < fPosX1) {
                        fPosX1 = f;
                    }
                    if (!(f > fPosX2)) continue;
                    fPosX2 = f;
                }
                g.drawLine((int)(this.m_fPosX * HierarchyVisualizer.this.m_fScaleX), (int)(this.m_fPosY * HierarchyVisualizer.this.m_fScaleY), (int)(this.m_fPosX * HierarchyVisualizer.this.m_fScaleX), (int)((this.m_fPosY - this.m_fLength) * HierarchyVisualizer.this.m_fScaleY));
                g.drawLine((int)(fPosX1 * HierarchyVisualizer.this.m_fScaleX), (int)(this.m_fPosY * HierarchyVisualizer.this.m_fScaleY), (int)(fPosX2 * HierarchyVisualizer.this.m_fScaleX), (int)(this.m_fPosY * HierarchyVisualizer.this.m_fScaleY));
            }
            return this.m_fPosX;
        }
    }
}

