/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.ClassDiscovery;
import weka.core.CustomDisplayStringProvider;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.WekaPackageManager;
import weka.core.logging.Logger;
import weka.gui.CheckBoxList;
import weka.gui.CustomPanelSupplier;
import weka.gui.GenericObjectEditorHistory;
import weka.gui.GenericPropertiesCreator;
import weka.gui.HierarchyPropertyParser;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.PluginManager;

public class GenericObjectEditor
implements PropertyEditor,
CustomPanelSupplier {
    protected Object m_Object;
    protected Object m_Backup;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Class<?> m_ClassType;
    protected Hashtable<String, HierarchyPropertyParser> m_ObjectNames;
    protected GOEPanel m_EditorComponent;
    protected boolean m_Enabled = true;
    protected static String PROPERTY_FILE = "weka/gui/GenericObjectEditor.props";
    protected static Properties EDITOR_PROPERTIES;
    public static final String GUIEDITORS_PROPERTY_FILE = "weka/gui/GUIEditors.props";
    protected GOETreeNode m_treeNodeOfCurrentObject;
    protected PropertyPanel m_ObjectPropertyPanel;
    protected boolean m_canChangeClassInDialog;
    protected GenericObjectEditorHistory m_History;
    protected static boolean m_EditorsRegistered;
    protected Capabilities m_CapabilitiesFilter = null;

    public static void determineClasses() {
        try {
            WekaPackageManager.loadPackages(false);
            if (WekaPackageManager.m_initialPackageLoadingInProcess) {
                return;
            }
            EDITOR_PROPERTIES = GenericPropertiesCreator.getGlobalOutputProperties();
            if (EDITOR_PROPERTIES == null) {
                GenericPropertiesCreator creator = new GenericPropertiesCreator();
                if (creator.useDynamic()) {
                    try {
                        creator.execute(false);
                        EDITOR_PROPERTIES = creator.getOutputProperties();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Could not determine the properties for the generic object\neditor. This exception was produced:\n" + e.toString(), "GenericObjectEditor", 0);
                    }
                } else {
                    try {
                        EDITOR_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
                        Enumeration<?> keys = EDITOR_PROPERTIES.propertyNames();
                        if (!keys.hasMoreElements()) {
                            throw new Exception("Failed to read a property file for the generic object editor");
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Could not read a configuration file for the generic object\neditor. An example file is included with the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\" and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "GenericObjectEditor", 0);
                    }
                }
            }
            if (EDITOR_PROPERTIES == null) {
                JOptionPane.showMessageDialog(null, "Could not initialize the GenericPropertiesCreator. ", "GenericObjectEditor", 0);
            } else {
                PluginManager.addFromProperties(EDITOR_PROPERTIES);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not initialize the GenericPropertiesCreator. This exception was produced:\n" + e.toString(), "GenericObjectEditor", 0);
        }
    }

    public GenericObjectEditor() {
        this(false);
    }

    public GenericObjectEditor(boolean canChangeClassInDialog) {
        this.m_canChangeClassInDialog = canChangeClassInDialog;
        this.m_History = new GenericObjectEditorHistory();
        ToolTipManager.sharedInstance().setDismissDelay(7000);
    }

    public static void registerEditors() {
        Properties props;
        if (m_EditorsRegistered) {
            return;
        }
        Logger.log(Logger.Level.INFO, "---Registering Weka Editors---");
        m_EditorsRegistered = true;
        try {
            props = Utils.readProperties(GUIEDITORS_PROPERTY_FILE);
        }
        catch (Exception e) {
            props = new Properties();
            e.printStackTrace();
        }
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            String name = enm.nextElement().toString();
            String value = props.getProperty(name, "");
            GenericObjectEditor.registerEditor(name, value);
        }
    }

    public static void registerEditor(String name, String value) {
        try {
            Class<?> cls;
            if (name.endsWith("[]")) {
                Class<?> baseCls = Class.forName(name.substring(0, name.indexOf("[]")));
                cls = Array.newInstance(baseCls, 1).getClass();
            } else {
                cls = Class.forName(name);
            }
            PropertyEditorManager.registerEditor(cls, Class.forName(value));
        }
        catch (Exception e) {
            Logger.log(Logger.Level.WARNING, "Problem registering " + name + "/" + value + ": " + e);
        }
    }

    public void setCanChangeClassInDialog(boolean value) {
        this.m_canChangeClassInDialog = value;
    }

    public boolean getCanChangeClassInDialog() {
        return this.m_canChangeClassInDialog;
    }

    public Object getBackup() {
        return this.m_Backup;
    }

    protected static String getRootFromClass(String clsname, String separator) {
        if (clsname.indexOf(separator) > -1) {
            return clsname.substring(0, clsname.indexOf(separator));
        }
        return null;
    }

    public static Hashtable<String, String> sortClassesByRoot(String classes) {
        Vector list;
        String root;
        if (classes == null) {
            return null;
        }
        Hashtable<String, Vector> roots = new Hashtable<String, Vector>();
        HierarchyPropertyParser hpp = new HierarchyPropertyParser();
        String separator = hpp.getSeperator();
        StringTokenizer tok = new StringTokenizer(classes, ", ");
        while (tok.hasMoreElements()) {
            String clsname = tok.nextToken();
            root = GenericObjectEditor.getRootFromClass(clsname, separator);
            if (root == null) continue;
            if (!roots.containsKey(root)) {
                list = new Vector();
                roots.put(root, list);
            } else {
                list = (Vector)roots.get(root);
            }
            list.add(clsname);
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration enm = roots.keys();
        while (enm.hasMoreElements()) {
            root = (String)enm.nextElement();
            list = (Vector)roots.get(root);
            String tmpStr = "";
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    tmpStr = tmpStr + ",";
                }
                tmpStr = tmpStr + (String)list.get(i);
            }
            result.put(root, tmpStr);
        }
        return result;
    }

    protected Hashtable<String, HierarchyPropertyParser> getClassesFromProperties() {
        Hashtable<String, HierarchyPropertyParser> hpps = new Hashtable<String, HierarchyPropertyParser>();
        String className = this.m_ClassType.getName();
        Set<String> cls = PluginManager.getPluginNamesOfType(className);
        if (cls == null) {
            return hpps;
        }
        ArrayList<String> toSort = new ArrayList<String>(cls);
        Collections.sort(toSort, new ClassDiscovery.StringCompare());
        StringBuilder b = new StringBuilder();
        for (String s : toSort) {
            b.append(s).append(",");
        }
        String listS = b.substring(0, b.length() - 1);
        Hashtable<String, String> typeOptions = GenericObjectEditor.sortClassesByRoot(listS);
        if (typeOptions != null) {
            try {
                Enumeration<String> enm = typeOptions.keys();
                while (enm.hasMoreElements()) {
                    String root = enm.nextElement();
                    String typeOption = typeOptions.get(root);
                    HierarchyPropertyParser hpp = new HierarchyPropertyParser();
                    hpp.build(typeOption, ", ");
                    hpps.put(root, hpp);
                }
            }
            catch (Exception ex) {
                Logger.log(Logger.Level.WARNING, "Invalid property: " + typeOptions);
            }
        }
        return hpps;
    }

    protected void updateObjectNames() {
        String className;
        String root;
        HierarchyPropertyParser hpp;
        if (this.m_ObjectNames == null) {
            this.m_ObjectNames = this.getClassesFromProperties();
        }
        if (this.m_Object != null && (hpp = this.m_ObjectNames.get(root = GenericObjectEditor.getRootFromClass(className = this.m_Object.getClass().getName(), new HierarchyPropertyParser().getSeperator()))) != null && !hpp.contains(className)) {
            hpp.add(className);
        }
    }

    public void setEnabled(boolean newVal) {
        if (newVal != this.m_Enabled) {
            this.m_Enabled = newVal;
        }
    }

    public void setClassType(Class<?> type) {
        this.m_ClassType = type;
        this.m_ObjectNames = this.getClassesFromProperties();
    }

    public void setDefaultValue() {
        if (this.m_ClassType == null) {
            Logger.log(Logger.Level.WARNING, "No ClassType set up for GenericObjectEditor!!");
            return;
        }
        Hashtable<String, HierarchyPropertyParser> hpps = this.getClassesFromProperties();
        HierarchyPropertyParser hpp = null;
        Enumeration<HierarchyPropertyParser> enm = hpps.elements();
        try {
            while (enm.hasMoreElements()) {
                hpp = enm.nextElement();
                if (hpp.depth() <= 0) continue;
                hpp.goToRoot();
                while (!hpp.isLeafReached()) {
                    hpp.goToChild(0);
                }
                String defaultValue = hpp.fullValue();
                this.setValue(Class.forName(defaultValue).newInstance());
            }
        }
        catch (Exception ex) {
            Logger.log(Logger.Level.WARNING, "Problem loading the first class: " + hpp.fullValue());
            ex.printStackTrace();
        }
    }

    @Override
    public void setValue(Object o) {
        if (this.m_ClassType == null) {
            Logger.log(Logger.Level.WARNING, "No ClassType set up for GenericObjectEditor!!");
            return;
        }
        if (!this.m_ClassType.isAssignableFrom(o.getClass())) {
            Logger.log(Logger.Level.WARNING, "setValue object not of correct type!");
            return;
        }
        this.setObject(o);
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.repaint();
        }
        this.updateObjectNames();
    }

    protected void setObject(Object c) {
        boolean trueChange = this.getValue() != null ? !c.equals(this.getValue()) : true;
        this.m_Backup = this.m_Object;
        this.m_Object = c;
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.updateChildPropertySheet();
        }
        if (trueChange) {
            this.m_Support.firePropertyChange("", null, null);
        }
    }

    @Override
    public Object getValue() {
        Object result = null;
        try {
            result = GenericObjectEditor.makeCopy(this.m_Object);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public String getJavaInitializationString() {
        return "new " + this.m_Object.getClass().getName() + "()";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.m_Enabled) {
            String rep;
            if (this.m_Object != null) {
                if (this.m_Object instanceof CustomDisplayStringProvider) {
                    rep = ((CustomDisplayStringProvider)this.m_Object).toDisplay();
                } else {
                    rep = this.m_Object.getClass().getName();
                    int dotPos = rep.lastIndexOf(46);
                    if (dotPos != -1) {
                        rep = rep.substring(dotPos + 1);
                    }
                }
            } else {
                rep = "None";
            }
            Font originalFont = gfx.getFont();
            gfx.setFont(originalFont.deriveFont(1));
            FontMetrics fm = gfx.getFontMetrics();
            int vpad = box.height - fm.getHeight();
            gfx.drawString(rep, 2, fm.getAscent() + vpad);
            int repwidth = fm.stringWidth(rep);
            gfx.setFont(originalFont);
            if (this.m_Object instanceof OptionHandler && !(this.m_Object instanceof CustomDisplayStringProvider)) {
                gfx.drawString(" " + Utils.joinOptions(((OptionHandler)this.m_Object).getOptions()), repwidth + 2, fm.getAscent() + vpad);
            }
        }
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.m_EditorComponent == null) {
            this.m_EditorComponent = new GOEPanel();
        }
        return this.m_EditorComponent;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    @Override
    public JPanel getCustomPanel() {
        final JButton chooseButton = this.createChooseClassButton();
        this.m_ObjectPropertyPanel = new PropertyPanel(this, true);
        JPanel customPanel = new JPanel(){
            private static final long serialVersionUID = 1024049543672124980L;

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                chooseButton.setEnabled(enabled);
            }
        };
        customPanel.setLayout(new BorderLayout());
        customPanel.add((Component)chooseButton, "West");
        customPanel.add((Component)this.m_ObjectPropertyPanel, "Center");
        return customPanel;
    }

    protected JButton createChooseClassButton() {
        JButton setButton = new JButton("Choose");
        setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = GenericObjectEditor.this.getChooseClassPopupMenu();
                if (e.getSource() instanceof Component) {
                    Component comp = (Component)e.getSource();
                    popup.show(comp, comp.getX(), comp.getY());
                    popup.pack();
                    popup.repaint();
                }
            }
        });
        return setButton;
    }

    protected String getClassnameFromPath(TreePath path) {
        StringBuffer classname = new StringBuffer();
        int start = 0;
        if (this.m_ObjectNames.size() > 1) {
            start = 1;
        }
        for (int i = start; i < path.getPathCount(); ++i) {
            if (i > start) {
                classname.append(".");
            }
            classname.append((String)((GOETreeNode)path.getPathComponent(i)).getUserObject());
        }
        return classname.toString();
    }

    public JPopupMenu getChooseClassPopupMenu() {
        this.updateObjectNames();
        this.m_treeNodeOfCurrentObject = null;
        final JTree tree = this.createTree(this.m_ObjectNames);
        if (this.m_treeNodeOfCurrentObject != null) {
            tree.setSelectionPath(new TreePath(this.m_treeNodeOfCurrentObject.getPath()));
        }
        tree.getSelectionModel().setSelectionMode(1);
        final JTreePopupMenu popup = new JTreePopupMenu(tree);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                GOETreeNode node = (GOETreeNode)tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node.isLeaf()) {
                    GenericObjectEditor.this.classSelected(GenericObjectEditor.this.getClassnameFromPath(tree.getSelectionPath()));
                    popup.setVisible(false);
                }
            }
        });
        return popup;
    }

    protected JTree createTree(Hashtable<String, HierarchyPropertyParser> hpps) {
        GOETreeNode superRoot = hpps.size() > 1 ? new GOETreeNode("root") : null;
        Enumeration<HierarchyPropertyParser> enm = hpps.elements();
        while (enm.hasMoreElements()) {
            HierarchyPropertyParser hpp = enm.nextElement();
            hpp.goToRoot();
            GOETreeNode root = new GOETreeNode(hpp.getValue());
            this.addChildrenToTree(root, hpp);
            if (superRoot == null) {
                superRoot = root;
                continue;
            }
            superRoot.add(root);
        }
        JTree tree = new JTree(superRoot){
            private static final long serialVersionUID = 6991903188102450549L;

            @Override
            public String getToolTipText(MouseEvent e) {
                DefaultMutableTreeNode node;
                if (this.getRowForLocation(e.getX(), e.getY()) == -1) {
                    return null;
                }
                TreePath currPath = this.getPathForLocation(e.getX(), e.getY());
                if (currPath.getLastPathComponent() instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)currPath.getLastPathComponent()).isLeaf()) {
                    return ((GOETreeNode)node).getToolTipText();
                }
                return null;
            }
        };
        tree.setToolTipText("");
        return tree;
    }

    protected void addChildrenToTree(GOETreeNode tree, HierarchyPropertyParser hpp) {
        try {
            for (int i = 0; i < hpp.numChildren(); ++i) {
                hpp.goToChild(i);
                GOETreeNode child = new GOETreeNode(hpp.getValue());
                if (this.m_Object != null && this.m_Object.getClass().getName().equals(hpp.fullValue())) {
                    this.m_treeNodeOfCurrentObject = child;
                }
                tree.add(child);
                if (hpp.isLeafReached()) {
                    String algName = hpp.fullValue();
                    try {
                        Object alg = Class.forName(algName).newInstance();
                        String toolTip = Utils.getGlobalInfo(alg, true);
                        if (toolTip != null) {
                            child.setToolTipText(toolTip);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.addChildrenToTree(child, hpp);
                hpp.goToParent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void classSelected(String className) {
        try {
            if (this.m_Object != null && this.m_Object.getClass().getName().equals(className)) {
                return;
            }
            this.setValue(Class.forName(className).newInstance());
            if (this.m_EditorComponent != null) {
                this.m_EditorComponent.updateChildPropertySheet();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not create an example of\n" + className + "\n" + "from the current classpath", "Class load failed", 0);
            ex.printStackTrace();
            try {
                if (this.m_Backup != null) {
                    this.setValue(this.m_Backup);
                } else {
                    this.setDefaultValue();
                }
            }
            catch (Exception e) {
                Logger.log(Logger.Level.WARNING, ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public void setCapabilitiesFilter(Capabilities value) {
        this.m_CapabilitiesFilter = new Capabilities(null);
        this.m_CapabilitiesFilter.assign(value);
    }

    public Capabilities getCapabilitiesFilter() {
        return this.m_CapabilitiesFilter;
    }

    public void removeCapabilitiesFilter() {
        this.m_CapabilitiesFilter = null;
    }

    public static Object makeCopy(Object source) throws Exception {
        SerializedObject so = new SerializedObject(source);
        Object result = so.getObject();
        return result;
    }

    public static Vector<String> getClassnames(String property) {
        Set<String> r = PluginManager.getPluginNamesOfType(property);
        Vector<String> result = new Vector<String>();
        if (r != null) {
            result.addAll(r);
        }
        Collections.sort(result, new ClassDiscovery.StringCompare());
        return result;
    }

    public GenericObjectEditorHistory getHistory() {
        return this.m_History;
    }

    public static void main(String[] args) {
        try {
            GenericObjectEditor.registerEditors();
            GenericObjectEditor ce = new GenericObjectEditor(true);
            ce.setClassType(Classifier.class);
            ZeroR initial = new ZeroR();
            if (args.length > 0) {
                ce.setClassType(Class.forName(args[0]));
                if (args.length > 1) {
                    initial = Class.forName(args[1]).newInstance();
                    ce.setValue(initial);
                } else {
                    ce.setDefaultValue();
                }
            } else {
                ce.setValue(initial);
            }
            PropertyDialog pd = new PropertyDialog((Frame)null, (PropertyEditor)ce, 100, 100);
            pd.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PropertyEditor pe = ((PropertyDialog)e.getSource()).getEditor();
                    Object c = pe.getValue();
                    String options = "";
                    if (c instanceof OptionHandler) {
                        options = Utils.joinOptions(((OptionHandler)c).getOptions());
                    }
                    System.out.println(c.getClass().getName() + " " + options);
                    System.exit(0);
                }
            });
            pd.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        GenericObjectEditor.determineClasses();
    }

    public class GOEPanel
    extends JPanel {
        static final long serialVersionUID = 3656028520876011335L;
        protected PropertySheetPanel m_ChildPropertySheet;
        protected JLabel m_ClassNameLabel;
        protected JButton m_OpenBut;
        protected JButton m_SaveBut;
        protected JButton m_okBut;
        protected JButton m_cancelBut;
        protected JFileChooser m_FileChooser;

        public GOEPanel() {
            GenericObjectEditor.this.m_Backup = this.copyObject(GenericObjectEditor.this.m_Object);
            this.m_ClassNameLabel = new JLabel("None");
            this.m_ClassNameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_ChildPropertySheet = new PropertySheetPanel();
            this.m_ChildPropertySheet.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GenericObjectEditor.this.m_Support.firePropertyChange("", null, null);
                }
            });
            this.m_OpenBut = new JButton("Open...");
            this.m_OpenBut.setToolTipText("Load a configured object");
            this.m_OpenBut.setEnabled(true);
            this.m_OpenBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object object = GOEPanel.this.openObject();
                    if (object != null) {
                        GenericObjectEditor.this.setValue(object);
                        GenericObjectEditor.this.setValue(object);
                    }
                }
            });
            this.m_SaveBut = new JButton("Save...");
            this.m_SaveBut.setToolTipText("Save the current configured object");
            this.m_SaveBut.setEnabled(true);
            this.m_SaveBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GOEPanel.this.saveObject(GenericObjectEditor.this.m_Object);
                }
            });
            this.m_okBut = new JButton("OK");
            this.m_okBut.setEnabled(true);
            this.m_okBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GOEPanel.this.m_ChildPropertySheet.closingOK();
                    GenericObjectEditor.this.m_Backup = GOEPanel.this.copyObject(GenericObjectEditor.this.m_Object);
                    if (GOEPanel.this.getTopLevelAncestor() != null && GOEPanel.this.getTopLevelAncestor() instanceof Window) {
                        Window w = (Window)GOEPanel.this.getTopLevelAncestor();
                        w.dispose();
                    }
                }
            });
            this.m_cancelBut = new JButton("Cancel");
            this.m_cancelBut.setEnabled(true);
            this.m_cancelBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GOEPanel.this.m_ChildPropertySheet.closingCancel();
                    if (GenericObjectEditor.this.m_Backup != null) {
                        GenericObjectEditor.this.m_Object = GOEPanel.this.copyObject(GenericObjectEditor.this.m_Backup);
                        GenericObjectEditor.this.m_Support.firePropertyChange("", null, null);
                        GenericObjectEditor.this.m_ObjectNames = GenericObjectEditor.this.getClassesFromProperties();
                        GenericObjectEditor.this.updateObjectNames();
                        GOEPanel.this.updateChildPropertySheet();
                    }
                    if (GOEPanel.this.getTopLevelAncestor() != null && GOEPanel.this.getTopLevelAncestor() instanceof Window) {
                        Window w = (Window)GOEPanel.this.getTopLevelAncestor();
                        w.dispose();
                    }
                }
            });
            this.setLayout(new BorderLayout());
            if (GenericObjectEditor.this.m_canChangeClassInDialog) {
                JButton chooseButton = GenericObjectEditor.this.createChooseClassButton();
                JPanel top = new JPanel();
                top.setLayout(new BorderLayout());
                top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                top.add((Component)chooseButton, "West");
                top.add((Component)this.m_ClassNameLabel, "Center");
                this.add((Component)top, "North");
            } else {
                this.add((Component)this.m_ClassNameLabel, "North");
            }
            this.add((Component)this.m_ChildPropertySheet, "Center");
            JPanel okcButs = new JPanel();
            okcButs.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            okcButs.setLayout(new GridLayout(1, 4, 5, 5));
            okcButs.add(this.m_OpenBut);
            okcButs.add(this.m_SaveBut);
            okcButs.add(this.m_okBut);
            okcButs.add(this.m_cancelBut);
            this.add((Component)okcButs, "South");
            if (GenericObjectEditor.this.m_ClassType != null) {
                GenericObjectEditor.this.m_ObjectNames = GenericObjectEditor.this.getClassesFromProperties();
                if (GenericObjectEditor.this.m_Object != null) {
                    GenericObjectEditor.this.updateObjectNames();
                    this.updateChildPropertySheet();
                }
            }
        }

        protected void setCancelButton(boolean flag) {
            if (this.m_cancelBut != null) {
                this.m_cancelBut.setEnabled(flag);
            }
        }

        protected Object openObject() {
            int returnVal;
            if (this.m_FileChooser == null) {
                this.createFileChooser();
            }
            if ((returnVal = this.m_FileChooser.showOpenDialog(this)) == 0) {
                File selected = this.m_FileChooser.getSelectedFile();
                try {
                    ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(new FileInputStream(selected)));
                    Object obj = oi.readObject();
                    oi.close();
                    if (!GenericObjectEditor.this.m_ClassType.isAssignableFrom(obj.getClass())) {
                        throw new Exception("Object not of type: " + GenericObjectEditor.this.m_ClassType.getName());
                    }
                    return obj;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Couldn't read object: " + selected.getName() + "\n" + ex.getMessage(), "Open object file", 0);
                }
            }
            return null;
        }

        protected void saveObject(Object object) {
            int returnVal;
            if (this.m_FileChooser == null) {
                this.createFileChooser();
            }
            if ((returnVal = this.m_FileChooser.showSaveDialog(this)) == 0) {
                File sFile = this.m_FileChooser.getSelectedFile();
                try {
                    ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(sFile)));
                    oo.writeObject(object);
                    oo.close();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Couldn't write to file: " + sFile.getName() + "\n" + ex.getMessage(), "Save object", 0);
                }
            }
        }

        protected void createFileChooser() {
            this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
            this.m_FileChooser.setFileSelectionMode(0);
        }

        protected Object copyObject(Object source) {
            Object result = null;
            try {
                result = GenericObjectEditor.makeCopy(source);
                this.setCancelButton(true);
            }
            catch (Exception ex) {
                this.setCancelButton(false);
                Logger.log(Logger.Level.WARNING, "GenericObjectEditor: Problem making backup object");
                Logger.log(Logger.Level.WARNING, ex);
            }
            return result;
        }

        public void setOkButtonText(String newLabel) {
            this.m_okBut.setText(newLabel);
        }

        public void addOkListener(ActionListener a) {
            this.m_okBut.addActionListener(a);
        }

        public void addCancelListener(ActionListener a) {
            this.m_cancelBut.addActionListener(a);
        }

        public void removeOkListener(ActionListener a) {
            this.m_okBut.removeActionListener(a);
        }

        public void removeCancelListener(ActionListener a) {
            this.m_cancelBut.removeActionListener(a);
        }

        public void updateChildPropertySheet() {
            String className = "None";
            if (GenericObjectEditor.this.m_Object != null) {
                className = GenericObjectEditor.this.m_Object.getClass().getName();
            }
            this.m_ClassNameLabel.setText(className);
            this.m_ChildPropertySheet.setTarget(GenericObjectEditor.this.m_Object);
            if (this.getTopLevelAncestor() != null && this.getTopLevelAncestor() instanceof Window) {
                ((Window)this.getTopLevelAncestor()).pack();
            }
        }
    }

    public class JTreePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -3404546329655057387L;
        private final JPopupMenu m_Self;
        private final JTree m_tree;
        private final JScrollPane m_scroller;
        private final JButton m_FilterButton = new JButton("Filter...");
        private final JButton m_RemoveFilterButton = new JButton("Remove filter");
        private final JButton m_CloseButton = new JButton("Close");

        public JTreePopupMenu(JTree tree) {
            this.m_Self = this;
            this.setLayout(new BorderLayout());
            JPanel panel = new JPanel(new FlowLayout(2));
            this.add((Component)panel, "South");
            if (ClassDiscovery.hasInterface(CapabilitiesHandler.class, GenericObjectEditor.this.m_ClassType)) {
                this.m_FilterButton.setMnemonic('F');
                this.m_FilterButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() == JTreePopupMenu.this.m_FilterButton) {
                            CapabilitiesFilterDialog dialog = new CapabilitiesFilterDialog();
                            dialog.setCapabilities(GenericObjectEditor.this.m_CapabilitiesFilter);
                            dialog.setPopup(JTreePopupMenu.this.m_Self);
                            dialog.setVisible(true);
                            GenericObjectEditor.this.m_Support.firePropertyChange("", null, null);
                            JTreePopupMenu.this.repaint();
                        }
                    }
                });
                panel.add(this.m_FilterButton);
                this.m_RemoveFilterButton.setMnemonic('R');
                this.m_RemoveFilterButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() == JTreePopupMenu.this.m_RemoveFilterButton) {
                            GenericObjectEditor.this.m_CapabilitiesFilter = null;
                            GenericObjectEditor.this.m_Support.firePropertyChange("", null, null);
                            JTreePopupMenu.this.repaint();
                        }
                    }
                });
                panel.add(this.m_RemoveFilterButton);
            }
            this.m_CloseButton.setMnemonic('C');
            this.m_CloseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == JTreePopupMenu.this.m_CloseButton) {
                        JTreePopupMenu.this.m_Self.setVisible(false);
                    }
                }
            });
            panel.add(this.m_CloseButton);
            this.m_tree = tree;
            JPanel treeView = new JPanel();
            treeView.setLayout(new BorderLayout());
            treeView.add((Component)this.m_tree, "North");
            treeView.setBackground(this.m_tree.getBackground());
            this.m_scroller = new JScrollPane(treeView);
            this.m_scroller.setPreferredSize(new Dimension(300, 400));
            this.m_scroller.getVerticalScrollBar().setUnitIncrement(20);
            this.add(this.m_scroller);
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x, y);
            Point location = this.getLocationOnScreen();
            Dimension screenSize = this.getToolkit().getScreenSize();
            int maxWidth = (int)(screenSize.getWidth() - location.getX());
            int maxHeight = (int)(screenSize.getHeight() - location.getY());
            Dimension scrollerSize = this.m_scroller.getPreferredSize();
            int height = (int)scrollerSize.getHeight();
            int width = (int)scrollerSize.getWidth();
            if (width > maxWidth) {
                width = maxWidth;
            }
            if (height > maxHeight) {
                height = maxHeight;
            }
            this.m_scroller.setPreferredSize(new Dimension(width, height));
            this.revalidate();
            this.pack();
        }
    }

    public class CapabilitiesFilterDialog
    extends JDialog {
        static final long serialVersionUID = -7845503345689646266L;
        protected JDialog m_Self;
        protected JPopupMenu m_Popup = null;
        protected Capabilities m_Capabilities = new Capabilities(null);
        protected JLabel m_InfoLabel = new JLabel();
        protected CheckBoxList m_List = new CheckBoxList();
        protected JButton m_OkButton = new JButton("OK");
        protected JButton m_CancelButton = new JButton("Cancel");

        public CapabilitiesFilterDialog() {
            this.m_Self = this;
            this.initGUI();
        }

        protected void initGUI() {
            this.setTitle("Filtering Capabilities...");
            this.setLayout(new BorderLayout());
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)panel, "North");
            this.m_InfoLabel.setText("<html>" + GenericObjectEditor.this.m_ClassType.getName().replaceAll(".*\\.", "") + "s" + " have to support <i>at least</i> the following capabilities <br>" + "(the ones highlighted <font color=\"" + "silver" + "\">" + "silver" + "</font> don't meet these requirements <br>" + "the ones highlighted  <font color=\"" + "blue" + "\">" + "blue" + "</font> possibly meet them):" + "</html>");
            panel.add((Component)this.m_InfoLabel, "Center");
            this.getContentPane().add((Component)new JScrollPane(this.m_List), "Center");
            CheckBoxList.CheckBoxListModel model = (CheckBoxList.CheckBoxListModel)this.m_List.getModel();
            for (Capabilities.Capability cap : Capabilities.Capability.values()) {
                model.addElement((Object)cap);
            }
            panel = new JPanel(new FlowLayout(1));
            this.getContentPane().add((Component)panel, "South");
            this.m_OkButton.setMnemonic('O');
            this.m_OkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CapabilitiesFilterDialog.this.updateCapabilities();
                    if (GenericObjectEditor.this.m_CapabilitiesFilter == null) {
                        GenericObjectEditor.this.m_CapabilitiesFilter = new Capabilities(null);
                    }
                    GenericObjectEditor.this.m_CapabilitiesFilter.assign(CapabilitiesFilterDialog.this.m_Capabilities);
                    CapabilitiesFilterDialog.this.m_Self.setVisible(false);
                    CapabilitiesFilterDialog.this.showPopup();
                }
            });
            panel.add(this.m_OkButton);
            this.m_CancelButton.setMnemonic('C');
            this.m_CancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CapabilitiesFilterDialog.this.m_Self.setVisible(false);
                    CapabilitiesFilterDialog.this.showPopup();
                }
            });
            panel.add(this.m_CancelButton);
            this.pack();
        }

        protected void updateList() {
            CheckBoxList.CheckBoxListModel model = (CheckBoxList.CheckBoxListModel)this.m_List.getModel();
            for (Capabilities.Capability cap : Capabilities.Capability.values()) {
                model.setChecked(model.indexOf((Object)cap), this.m_Capabilities.handles(cap));
            }
        }

        protected void updateCapabilities() {
            CheckBoxList.CheckBoxListModel model = (CheckBoxList.CheckBoxListModel)this.m_List.getModel();
            for (Capabilities.Capability cap : Capabilities.Capability.values()) {
                if (model.getChecked(model.indexOf((Object)cap))) {
                    this.m_Capabilities.enable(cap);
                    continue;
                }
                this.m_Capabilities.disable(cap);
            }
        }

        public void setCapabilities(Capabilities value) {
            if (value != null) {
                this.m_Capabilities.assign(value);
            } else {
                this.m_Capabilities = new Capabilities(null);
            }
            this.updateList();
        }

        public Capabilities getCapabilities() {
            return this.m_Capabilities;
        }

        public void setPopup(JPopupMenu value) {
            this.m_Popup = value;
        }

        public JPopupMenu getPopup() {
            return this.m_Popup;
        }

        public void showPopup() {
            if (this.getPopup() != null) {
                this.getPopup().setVisible(true);
            }
        }
    }

    public class GOETreeNode
    extends DefaultMutableTreeNode {
        static final long serialVersionUID = -1707872446682150133L;
        public static final String NO_SUPPORT = "silver";
        public static final String MAYBE_SUPPORT = "blue";
        protected Capabilities m_Capabilities;
        protected String m_toolTipText;

        public GOETreeNode() {
            this.m_Capabilities = null;
        }

        public GOETreeNode(Object userObject) {
            super(userObject);
            this.m_Capabilities = null;
        }

        public GOETreeNode(Object userObject, boolean allowsChildren) {
            super(userObject, allowsChildren);
            this.m_Capabilities = null;
        }

        public void setToolTipText(String tip) {
            this.m_toolTipText = tip;
        }

        public String getToolTipText() {
            return this.m_toolTipText;
        }

        protected void initCapabilities() {
            if (this.m_Capabilities != null) {
                return;
            }
            if (!this.isLeaf()) {
                return;
            }
            String classname = GenericObjectEditor.this.getClassnameFromPath(new TreePath(this.getPath()));
            try {
                Class<?> cls = Class.forName(classname);
                if (!ClassDiscovery.hasInterface(CapabilitiesHandler.class, cls)) {
                    return;
                }
                Object obj = cls.newInstance();
                this.m_Capabilities = ((CapabilitiesHandler)obj).getCapabilities();
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        @Override
        public String toString() {
            String result = super.toString();
            if (GenericObjectEditor.this.m_CapabilitiesFilter != null) {
                this.initCapabilities();
                if (this.m_Capabilities != null) {
                    if (this.m_Capabilities.supportsMaybe(GenericObjectEditor.this.m_CapabilitiesFilter) && !this.m_Capabilities.supports(GenericObjectEditor.this.m_CapabilitiesFilter)) {
                        result = "<html><font color=\"blue\">" + result + "</font></i><html>";
                    } else if (!this.m_Capabilities.supports(GenericObjectEditor.this.m_CapabilitiesFilter)) {
                        result = "<html><font color=\"silver\">" + result + "</font></i><html>";
                    }
                }
            }
            return result;
        }
    }
}

