/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.classifiers.UpdateableClassifier;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.Classifier;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.FileEnvironmentField;

public class ClassifierCustomizer
extends JPanel
implements BeanCustomizer,
CustomizerClosingListener,
CustomizerCloseRequester,
EnvironmentHandler {
    private static final long serialVersionUID = -6688000820160821429L;
    private final PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Classifier m_dsClassifier;
    private final PropertySheetPanel m_ClassifierEditor = new PropertySheetPanel();
    private final JPanel m_incrementalPanel = new JPanel();
    private final JCheckBox m_resetIncrementalClassifier = new JCheckBox("Reset classifier at the start of the stream");
    private final JCheckBox m_updateIncrementalClassifier = new JCheckBox("Update classifier on incoming instance stream");
    private boolean m_panelVisible = false;
    private final JPanel m_holderPanel = new JPanel();
    private final JTextField m_executionSlotsText = new JTextField();
    private final JLabel m_executionSlotsLabel;
    private final JPanel m_executionSlotsPanel;
    private final JCheckBox m_blockOnLastFold = new JCheckBox("Block on last fold of last run");
    private FileEnvironmentField m_loadModelField;
    private Window m_parentWindow;
    protected weka.classifiers.Classifier m_backup;
    private Environment m_env = Environment.getSystemWide();
    private BeanCustomizer.ModifyListener m_modifyListener;

    public ClassifierCustomizer() {
        this.m_ClassifierEditor.setBorder(BorderFactory.createTitledBorder("Classifier options"));
        this.m_incrementalPanel.setLayout(new GridLayout(0, 1));
        this.m_resetIncrementalClassifier.setToolTipText("Reset the classifier before processing the first incoming instance");
        this.m_updateIncrementalClassifier.setToolTipText("Train the classifier on each individual incoming streamed instance.");
        this.m_updateIncrementalClassifier.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setUpdateIncrementalClassifier(ClassifierCustomizer.this.m_updateIncrementalClassifier.isSelected());
                }
            }
        });
        this.m_resetIncrementalClassifier.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setResetIncrementalClassifier(ClassifierCustomizer.this.m_resetIncrementalClassifier.isSelected());
                }
            }
        });
        this.m_incrementalPanel.add(this.m_resetIncrementalClassifier);
        this.m_incrementalPanel.add(this.m_updateIncrementalClassifier);
        this.m_executionSlotsText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null && ClassifierCustomizer.this.m_executionSlotsText.getText().length() > 0) {
                    int newSlots = Integer.parseInt(ClassifierCustomizer.this.m_executionSlotsText.getText());
                    ClassifierCustomizer.this.m_dsClassifier.setExecutionSlots(newSlots);
                }
            }
        });
        this.m_executionSlotsText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null && ClassifierCustomizer.this.m_executionSlotsText.getText().length() > 0) {
                    int newSlots = Integer.parseInt(ClassifierCustomizer.this.m_executionSlotsText.getText());
                    ClassifierCustomizer.this.m_dsClassifier.setExecutionSlots(newSlots);
                }
            }
        });
        this.m_blockOnLastFold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setBlockOnLastFold(ClassifierCustomizer.this.m_blockOnLastFold.isSelected());
                }
            }
        });
        this.m_executionSlotsPanel = new JPanel();
        this.m_executionSlotsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_executionSlotsLabel = new JLabel("Execution slots");
        this.m_executionSlotsPanel.setLayout(new BorderLayout());
        this.m_executionSlotsPanel.add((Component)this.m_executionSlotsLabel, "West");
        this.m_executionSlotsPanel.add((Component)this.m_executionSlotsText, "Center");
        this.m_holderPanel.setBorder(BorderFactory.createTitledBorder("More options"));
        this.m_holderPanel.setLayout(new BorderLayout());
        this.m_holderPanel.add((Component)this.m_executionSlotsPanel, "North");
        this.m_holderPanel.add((Component)this.m_blockOnLastFold, "South");
        JPanel holder2 = new JPanel();
        holder2.setLayout(new BorderLayout());
        holder2.add((Component)this.m_holderPanel, "North");
        JButton OKBut = new JButton("OK");
        JButton CancelBut = new JButton("Cancel");
        OKBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierCustomizer.this.m_dsClassifier.setClassifierTemplate(ClassifierCustomizer.this.m_dsClassifier.getClassifierTemplate());
                if (ClassifierCustomizer.this.m_loadModelField != null) {
                    String loadFName = ClassifierCustomizer.this.m_loadModelField.getText();
                    if (loadFName != null && loadFName.length() > 0) {
                        ClassifierCustomizer.this.m_dsClassifier.setLoadClassifierFileName(ClassifierCustomizer.this.m_loadModelField.getText());
                    } else {
                        ClassifierCustomizer.this.m_dsClassifier.setLoadClassifierFileName("");
                    }
                }
                if (ClassifierCustomizer.this.m_modifyListener != null) {
                    ClassifierCustomizer.this.m_modifyListener.setModifiedStatus(ClassifierCustomizer.this, true);
                }
                ClassifierCustomizer.this.m_parentWindow.dispose();
            }
        });
        CancelBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_backup != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setClassifierTemplate(ClassifierCustomizer.this.m_backup);
                }
                if (ClassifierCustomizer.this.m_modifyListener != null) {
                    ClassifierCustomizer.this.m_modifyListener.setModifiedStatus(ClassifierCustomizer.this, false);
                }
                ClassifierCustomizer.this.m_parentWindow.dispose();
            }
        });
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(OKBut);
        butHolder.add(CancelBut);
        holder2.add((Component)butHolder, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_ClassifierEditor, "Center");
        this.add((Component)holder2, "South");
    }

    private void checkOnClassifierType() {
        weka.classifiers.Classifier editedC = this.m_dsClassifier.getClassifierTemplate();
        if (editedC instanceof UpdateableClassifier && this.m_dsClassifier.hasIncomingStreamInstances()) {
            if (!this.m_panelVisible) {
                this.m_holderPanel.add((Component)this.m_incrementalPanel, "South");
                this.m_panelVisible = true;
                this.m_executionSlotsText.setEnabled(false);
                this.m_loadModelField = new FileEnvironmentField("Load model from file", this.m_env);
                this.m_incrementalPanel.add(this.m_loadModelField);
                this.m_loadModelField.setText(this.m_dsClassifier.getLoadClassifierFileName());
            }
        } else {
            if (this.m_panelVisible) {
                this.m_holderPanel.remove(this.m_incrementalPanel);
            }
            if (this.m_dsClassifier.hasIncomingStreamInstances()) {
                this.m_loadModelField = new FileEnvironmentField("Load model from file", this.m_env);
                this.m_executionSlotsPanel.add((Component)this.m_loadModelField, "South");
                this.m_executionSlotsText.setEnabled(false);
                this.m_blockOnLastFold.setEnabled(false);
                this.m_loadModelField.setText(this.m_dsClassifier.getLoadClassifierFileName());
            } else {
                this.m_executionSlotsText.setEnabled(true);
                this.m_blockOnLastFold.setEnabled(true);
            }
            this.m_panelVisible = false;
            if (this.m_dsClassifier.hasIncomingBatchInstances() && !((Hashtable)((Object)this.m_dsClassifier.m_listenees)).containsKey("trainingSet")) {
                this.m_holderPanel.remove(this.m_blockOnLastFold);
                this.m_holderPanel.remove(this.m_executionSlotsPanel);
                this.m_loadModelField = new FileEnvironmentField("Load model from file", this.m_env);
                this.m_holderPanel.add((Component)this.m_loadModelField, "South");
                this.m_loadModelField.setText(this.m_dsClassifier.getLoadClassifierFileName());
            }
        }
    }

    public void setObject(Object object) {
        this.m_dsClassifier = (Classifier)object;
        try {
            this.m_backup = (weka.classifiers.Classifier)GenericObjectEditor.makeCopy(this.m_dsClassifier.getClassifierTemplate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_ClassifierEditor.setEnvironment(this.m_env);
        this.m_ClassifierEditor.setTarget(this.m_dsClassifier.getClassifierTemplate());
        this.m_resetIncrementalClassifier.setSelected(this.m_dsClassifier.getResetIncrementalClassifier());
        this.m_updateIncrementalClassifier.setSelected(this.m_dsClassifier.getUpdateIncrementalClassifier());
        this.m_executionSlotsText.setText("" + this.m_dsClassifier.getExecutionSlots());
        this.m_blockOnLastFold.setSelected(this.m_dsClassifier.getBlockOnLastFold());
        this.checkOnClassifierType();
    }

    public void customizerClosing() {
        if (this.m_executionSlotsText.getText().length() > 0) {
            int newSlots = Integer.parseInt(this.m_executionSlotsText.getText());
            this.m_dsClassifier.setExecutionSlots(newSlots);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    public void setParentWindow(Window parent) {
        this.m_parentWindow = parent;
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

