/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.ClassDiscovery;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.gui.CheckBoxList;
import weka.gui.CustomPanelSupplier;
import weka.gui.GenericPropertiesCreator;
import weka.gui.HierarchyPropertyParser;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.PropertySheetPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericObjectEditor
implements PropertyEditor,
CustomPanelSupplier {
    protected Object m_Object;
    protected Object m_Backup;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Class m_ClassType;
    protected Hashtable m_ObjectNames;
    protected GOEPanel m_EditorComponent;
    protected boolean m_Enabled = true;
    protected static String PROPERTY_FILE;
    protected static Properties EDITOR_PROPERTIES;
    public static final String GUIEDITORS_PROPERTY_FILE = "weka/gui/GUIEditors.props";
    protected GOETreeNode m_treeNodeOfCurrentObject;
    protected PropertyPanel m_ObjectPropertyPanel;
    protected boolean m_canChangeClassInDialog;
    protected static boolean m_EditorsRegistered;
    protected Capabilities m_CapabilitiesFilter = null;

    public GenericObjectEditor() {
        this(false);
    }

    public GenericObjectEditor(boolean bl) {
        this.m_canChangeClassInDialog = bl;
    }

    public static void registerEditors() {
        Properties properties;
        if (m_EditorsRegistered) {
            return;
        }
        System.err.println("---Registering Weka Editors---");
        m_EditorsRegistered = true;
        try {
            properties = Utils.readProperties(GUIEDITORS_PROPERTY_FILE);
        }
        catch (Exception exception) {
            properties = new Properties();
            exception.printStackTrace();
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = properties.getProperty(string, "");
            try {
                Class<?> clazz;
                if (string.endsWith("[]")) {
                    Class<?> clazz2 = Class.forName(string.substring(0, string.indexOf("[]")));
                    clazz = Array.newInstance(clazz2, 1).getClass();
                } else {
                    clazz = Class.forName(string);
                }
                PropertyEditorManager.registerEditor(clazz, Class.forName(string2));
            }
            catch (Exception exception) {
                System.err.println("Problem registering " + string + "/" + string2 + ": " + exception);
            }
        }
    }

    public Object getBackup() {
        return this.m_Backup;
    }

    protected static String getRootFromClass(String string, String string2) {
        if (string.indexOf(string2) > -1) {
            return string.substring(0, string.indexOf(string2));
        }
        return null;
    }

    public static Hashtable sortClassesByRoot(String string) {
        Vector vector;
        String string2;
        if (string == null) {
            return null;
        }
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        HierarchyPropertyParser hierarchyPropertyParser = new HierarchyPropertyParser();
        String string3 = hierarchyPropertyParser.getSeperator();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            string2 = GenericObjectEditor.getRootFromClass(string4, string3);
            if (string2 == null) continue;
            if (!hashtable.containsKey(string2)) {
                vector = new Vector();
                hashtable.put(string2, vector);
            } else {
                vector = (Vector)hashtable.get(string2);
            }
            vector.add(string4);
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            vector = (Vector)hashtable.get(string2);
            String string5 = "";
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    string5 = string5 + ",";
                }
                string5 = string5 + (String)vector.get(i);
            }
            hashtable2.put(string2, string5);
        }
        return hashtable2;
    }

    protected Hashtable getClassesFromProperties() {
        Hashtable<String, HierarchyPropertyParser> hashtable = new Hashtable<String, HierarchyPropertyParser>();
        String string = this.m_ClassType.getName();
        Hashtable hashtable2 = GenericObjectEditor.sortClassesByRoot(EDITOR_PROPERTIES.getProperty(string));
        if (hashtable2 != null) {
            try {
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)hashtable2.get(string2);
                    HierarchyPropertyParser hierarchyPropertyParser = new HierarchyPropertyParser();
                    hierarchyPropertyParser.build(string3, ", ");
                    hashtable.put(string2, hierarchyPropertyParser);
                }
            }
            catch (Exception exception) {
                System.err.println("Invalid property: " + hashtable2);
            }
        }
        return hashtable;
    }

    protected void updateObjectNames() {
        String string;
        String string2;
        HierarchyPropertyParser hierarchyPropertyParser;
        if (this.m_ObjectNames == null) {
            this.m_ObjectNames = this.getClassesFromProperties();
        }
        if (this.m_Object != null && (hierarchyPropertyParser = (HierarchyPropertyParser)this.m_ObjectNames.get(string2 = GenericObjectEditor.getRootFromClass(string = this.m_Object.getClass().getName(), new HierarchyPropertyParser().getSeperator()))) != null && !hierarchyPropertyParser.contains(string)) {
            hierarchyPropertyParser.add(string);
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.m_Enabled) {
            this.m_Enabled = bl;
        }
    }

    public void setClassType(Class clazz) {
        this.m_ClassType = clazz;
        this.m_ObjectNames = this.getClassesFromProperties();
    }

    public void setDefaultValue() {
        if (this.m_ClassType == null) {
            System.err.println("No ClassType set up for GenericObjectEditor!!");
            return;
        }
        Hashtable hashtable = this.getClassesFromProperties();
        HierarchyPropertyParser hierarchyPropertyParser = null;
        Enumeration enumeration = hashtable.elements();
        try {
            while (enumeration.hasMoreElements()) {
                hierarchyPropertyParser = (HierarchyPropertyParser)enumeration.nextElement();
                if (hierarchyPropertyParser.depth() <= 0) continue;
                hierarchyPropertyParser.goToRoot();
                while (!hierarchyPropertyParser.isLeafReached()) {
                    hierarchyPropertyParser.goToChild(0);
                }
                String string = hierarchyPropertyParser.fullValue();
                this.setValue(Class.forName(string).newInstance());
            }
        }
        catch (Exception exception) {
            System.err.println("Problem loading the first class: " + hierarchyPropertyParser.fullValue());
            exception.printStackTrace();
        }
    }

    @Override
    public void setValue(Object object) {
        if (this.m_ClassType == null) {
            System.err.println("No ClassType set up for GenericObjectEditor!!");
            return;
        }
        if (!this.m_ClassType.isAssignableFrom(object.getClass())) {
            System.err.println("setValue object not of correct type!");
            return;
        }
        this.setObject(object);
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.repaint();
        }
        this.updateObjectNames();
    }

    protected void setObject(Object object) {
        boolean bl = this.getValue() != null ? !object.equals(this.getValue()) : true;
        this.m_Backup = this.m_Object;
        this.m_Object = object;
        if (this.m_EditorComponent != null) {
            this.m_EditorComponent.updateChildPropertySheet();
        }
        if (bl) {
            this.m_Support.firePropertyChange("", null, null);
        }
    }

    @Override
    public Object getValue() {
        Object object = null;
        try {
            object = this.makeCopy(this.m_Object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    @Override
    public String getJavaInitializationString() {
        return "new " + this.m_Object.getClass().getName() + "()";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        if (this.m_Enabled) {
            String string = this.m_Object != null ? this.m_Object.getClass().getName() : "None";
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            Font font = graphics.getFont();
            graphics.setFont(font.deriveFont(1));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = (rectangle.height - fontMetrics.getHeight()) / 2;
            graphics.drawString(string, 2, fontMetrics.getHeight() + n2);
            int n3 = fontMetrics.stringWidth(string);
            graphics.setFont(font);
            if (this.m_Object instanceof OptionHandler) {
                graphics.drawString(" " + Utils.joinOptions(((OptionHandler)this.m_Object).getOptions()), n3 + 2, fontMetrics.getHeight() + n2);
            }
        }
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String string) {
        throw new IllegalArgumentException(string);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.m_EditorComponent == null) {
            this.m_EditorComponent = new GOEPanel();
        }
        return this.m_EditorComponent;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public JPanel getCustomPanel() {
        JButton jButton = this.createChooseClassButton();
        this.m_ObjectPropertyPanel = new PropertyPanel(this, true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jButton, "West");
        jPanel.add((Component)this.m_ObjectPropertyPanel, "Center");
        return jPanel;
    }

    protected JButton createChooseClassButton() {
        JButton jButton = new JButton("Choose");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = GenericObjectEditor.this.getChooseClassPopupMenu();
                if (actionEvent.getSource() instanceof Component) {
                    Component component = (Component)actionEvent.getSource();
                    jPopupMenu.show(component, component.getX(), component.getY());
                    jPopupMenu.pack();
                }
            }
        });
        return jButton;
    }

    protected String getClassnameFromPath(TreePath treePath) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (this.m_ObjectNames.size() > 1) {
            n = 1;
        }
        for (int i = n; i < treePath.getPathCount(); ++i) {
            if (i > n) {
                stringBuffer.append(".");
            }
            stringBuffer.append((String)((GOETreeNode)treePath.getPathComponent(i)).getUserObject());
        }
        return stringBuffer.toString();
    }

    public JPopupMenu getChooseClassPopupMenu() {
        this.updateObjectNames();
        this.m_treeNodeOfCurrentObject = null;
        final JTree jTree = this.createTree(this.m_ObjectNames);
        if (this.m_treeNodeOfCurrentObject != null) {
            jTree.setSelectionPath(new TreePath(this.m_treeNodeOfCurrentObject.getPath()));
        }
        jTree.getSelectionModel().setSelectionMode(1);
        final JTreePopupMenu jTreePopupMenu = new JTreePopupMenu(jTree);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                GOETreeNode gOETreeNode = (GOETreeNode)jTree.getLastSelectedPathComponent();
                if (gOETreeNode == null) {
                    return;
                }
                if (gOETreeNode.isLeaf()) {
                    GenericObjectEditor.this.classSelected(GenericObjectEditor.this.getClassnameFromPath(jTree.getSelectionPath()));
                    jTreePopupMenu.setVisible(false);
                }
            }
        });
        return jTreePopupMenu;
    }

    protected JTree createTree(Hashtable hashtable) {
        Serializable serializable;
        Serializable serializable2 = hashtable.size() > 1 ? new GOETreeNode("root") : null;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            HierarchyPropertyParser hierarchyPropertyParser = (HierarchyPropertyParser)enumeration.nextElement();
            hierarchyPropertyParser.goToRoot();
            serializable = new GOETreeNode(hierarchyPropertyParser.getValue());
            this.addChildrenToTree((GOETreeNode)serializable, hierarchyPropertyParser);
            if (serializable2 == null) {
                serializable2 = serializable;
                continue;
            }
            serializable2.add((MutableTreeNode)((Object)serializable));
        }
        serializable = new JTree((TreeNode)((Object)serializable2));
        return serializable;
    }

    protected void addChildrenToTree(GOETreeNode gOETreeNode, HierarchyPropertyParser hierarchyPropertyParser) {
        try {
            for (int i = 0; i < hierarchyPropertyParser.numChildren(); ++i) {
                hierarchyPropertyParser.goToChild(i);
                GOETreeNode gOETreeNode2 = new GOETreeNode(hierarchyPropertyParser.getValue());
                if (this.m_Object != null && this.m_Object.getClass().getName().equals(hierarchyPropertyParser.fullValue())) {
                    this.m_treeNodeOfCurrentObject = gOETreeNode2;
                }
                gOETreeNode.add(gOETreeNode2);
                this.addChildrenToTree(gOETreeNode2, hierarchyPropertyParser);
                hierarchyPropertyParser.goToParent();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void classSelected(String string) {
        try {
            if (this.m_Object != null && this.m_Object.getClass().getName().equals(string)) {
                return;
            }
            this.setValue(Class.forName(string).newInstance());
            if (this.m_EditorComponent != null) {
                this.m_EditorComponent.updateChildPropertySheet();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Could not create an example of\n" + string + "\n" + "from the current classpath", "Class load failed", 0);
            exception.printStackTrace();
            try {
                if (this.m_Backup != null) {
                    this.setValue(this.m_Backup);
                } else {
                    this.setDefaultValue();
                }
            }
            catch (Exception exception2) {
                System.err.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public void setCapabilitiesFilter(Capabilities capabilities) {
        this.m_CapabilitiesFilter = new Capabilities(null);
        this.m_CapabilitiesFilter.assign(capabilities);
    }

    public Capabilities getCapabilitiesFilter() {
        return this.m_CapabilitiesFilter;
    }

    public void removeCapabilitiesFilter() {
        this.m_CapabilitiesFilter = null;
    }

    public Object makeCopy(Object object) throws Exception {
        SerializedObject serializedObject = new SerializedObject(object);
        Object object2 = serializedObject.getObject();
        return object2;
    }

    public static Vector<String> getClassnames(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = EDITOR_PROPERTIES.getProperty(string, "").replaceAll(" ", "").trim();
        if (string2.length() > 0) {
            String[] stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        try {
            GenericObjectEditor.registerEditors();
            GenericObjectEditor genericObjectEditor = new GenericObjectEditor(true);
            genericObjectEditor.setClassType(Classifier.class);
            ZeroR zeroR = new ZeroR();
            if (stringArray.length > 0) {
                genericObjectEditor.setClassType(Class.forName(stringArray[0]));
                if (stringArray.length > 1) {
                    zeroR = Class.forName(stringArray[1]).newInstance();
                    genericObjectEditor.setValue(zeroR);
                } else {
                    genericObjectEditor.setDefaultValue();
                }
            } else {
                genericObjectEditor.setValue(zeroR);
            }
            PropertyDialog propertyDialog = new PropertyDialog(genericObjectEditor, 100, 100);
            propertyDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PropertyEditor propertyEditor = ((PropertyDialog)windowEvent.getSource()).getEditor();
                    Object object = propertyEditor.getValue();
                    String string = "";
                    if (object instanceof OptionHandler) {
                        string = Utils.joinOptions(((OptionHandler)object).getOptions());
                    }
                    System.out.println(object.getClass().getName() + " " + string);
                    System.exit(0);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        block8: {
            PROPERTY_FILE = "weka/gui/GenericObjectEditor.props";
            try {
                GenericPropertiesCreator genericPropertiesCreator = new GenericPropertiesCreator();
                if (genericPropertiesCreator.useDynamic()) {
                    try {
                        genericPropertiesCreator.execute(false);
                        EDITOR_PROPERTIES = genericPropertiesCreator.getOutputProperties();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, "Could not determine the properties for the generic object\neditor. This exception was produced:\n" + exception.toString(), "GenericObjectEditor", 0);
                    }
                    break block8;
                }
                try {
                    EDITOR_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
                    Enumeration<?> enumeration = EDITOR_PROPERTIES.propertyNames();
                    if (!enumeration.hasMoreElements()) {
                        throw new Exception("Failed to read a property file for the generic object editor");
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Could not read a configuration file for the generic object\neditor. An example file is included with the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\" and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "GenericObjectEditor", 0);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Could not initialize the GenericPropertiesCreator. This exception was produced:\n" + exception.toString(), "GenericObjectEditor", 0);
            }
        }
    }

    public class GOEPanel
    extends JPanel {
        static final long serialVersionUID = 3656028520876011335L;
        protected PropertySheetPanel m_ChildPropertySheet;
        protected JLabel m_ClassNameLabel;
        protected JButton m_OpenBut;
        protected JButton m_SaveBut;
        protected JButton m_okBut;
        protected JButton m_cancelBut;
        protected JFileChooser m_FileChooser;

        public GOEPanel() {
            JComponent jComponent;
            GenericObjectEditor.this.m_Backup = this.copyObject(GenericObjectEditor.this.m_Object);
            this.m_ClassNameLabel = new JLabel("None");
            this.m_ClassNameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_ChildPropertySheet = new PropertySheetPanel();
            this.m_ChildPropertySheet.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    GenericObjectEditor.this.m_Support.firePropertyChange("", null, null);
                }
            });
            this.m_OpenBut = new JButton("Open...");
            this.m_OpenBut.setToolTipText("Load a configured object");
            this.m_OpenBut.setEnabled(true);
            this.m_OpenBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = GOEPanel.this.openObject();
                    if (object != null) {
                        GenericObjectEditor.this.setValue(object);
                        GenericObjectEditor.this.setValue(object);
                    }
                }
            });
            this.m_SaveBut = new JButton("Save...");
            this.m_SaveBut.setToolTipText("Save the current configured object");
            this.m_SaveBut.setEnabled(true);
            this.m_SaveBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GOEPanel.this.saveObject(GenericObjectEditor.this.m_Object);
                }
            });
            this.m_okBut = new JButton("OK");
            this.m_okBut.setEnabled(true);
            this.m_okBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GenericObjectEditor.this.m_Backup = GOEPanel.this.copyObject(GenericObjectEditor.this.m_Object);
                    if (GOEPanel.this.getTopLevelAncestor() != null && GOEPanel.this.getTopLevelAncestor() instanceof Window) {
                        Window window = (Window)GOEPanel.this.getTopLevelAncestor();
                        window.dispose();
                    }
                }
            });
            this.m_cancelBut = new JButton("Cancel");
            this.m_cancelBut.setEnabled(true);
            this.m_cancelBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (GenericObjectEditor.this.m_Backup != null) {
                        GenericObjectEditor.this.m_Object = GOEPanel.this.copyObject(GenericObjectEditor.this.m_Backup);
                        GenericObjectEditor.this.m_Support.firePropertyChange("", null, null);
                        GenericObjectEditor.this.m_ObjectNames = GenericObjectEditor.this.getClassesFromProperties();
                        GenericObjectEditor.this.updateObjectNames();
                        GOEPanel.this.updateChildPropertySheet();
                    }
                    if (GOEPanel.this.getTopLevelAncestor() != null && GOEPanel.this.getTopLevelAncestor() instanceof Window) {
                        Window window = (Window)GOEPanel.this.getTopLevelAncestor();
                        window.dispose();
                    }
                }
            });
            this.setLayout(new BorderLayout());
            if (GenericObjectEditor.this.m_canChangeClassInDialog) {
                jComponent = GenericObjectEditor.this.createChooseClassButton();
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                jPanel.add((Component)jComponent, "West");
                jPanel.add((Component)this.m_ClassNameLabel, "Center");
                this.add((Component)jPanel, "North");
            } else {
                this.add((Component)this.m_ClassNameLabel, "North");
            }
            this.add((Component)this.m_ChildPropertySheet, "Center");
            jComponent = new JPanel();
            jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jComponent.setLayout(new GridLayout(1, 4, 5, 5));
            jComponent.add(this.m_OpenBut);
            jComponent.add(this.m_SaveBut);
            jComponent.add(this.m_okBut);
            jComponent.add(this.m_cancelBut);
            this.add((Component)jComponent, "South");
            if (GenericObjectEditor.this.m_ClassType != null) {
                GenericObjectEditor.this.m_ObjectNames = GenericObjectEditor.this.getClassesFromProperties();
                if (GenericObjectEditor.this.m_Object != null) {
                    GenericObjectEditor.this.updateObjectNames();
                    this.updateChildPropertySheet();
                }
            }
        }

        protected void setCancelButton(boolean bl) {
            if (this.m_cancelBut != null) {
                this.m_cancelBut.setEnabled(bl);
            }
        }

        protected Object openObject() {
            int n;
            if (this.m_FileChooser == null) {
                this.createFileChooser();
            }
            if ((n = this.m_FileChooser.showOpenDialog(this)) == 0) {
                File file = this.m_FileChooser.getSelectedFile();
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                    Object object = objectInputStream.readObject();
                    objectInputStream.close();
                    if (!GenericObjectEditor.this.m_ClassType.isAssignableFrom(object.getClass())) {
                        throw new Exception("Object not of type: " + GenericObjectEditor.this.m_ClassType.getName());
                    }
                    return object;
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Couldn't read object: " + file.getName() + "\n" + exception.getMessage(), "Open object file", 0);
                }
            }
            return null;
        }

        protected void saveObject(Object object) {
            int n;
            if (this.m_FileChooser == null) {
                this.createFileChooser();
            }
            if ((n = this.m_FileChooser.showSaveDialog(this)) == 0) {
                File file = this.m_FileChooser.getSelectedFile();
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    objectOutputStream.writeObject(object);
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Couldn't write to file: " + file.getName() + "\n" + exception.getMessage(), "Save object", 0);
                }
            }
        }

        protected void createFileChooser() {
            this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
            this.m_FileChooser.setFileSelectionMode(0);
        }

        protected Object copyObject(Object object) {
            Object object2 = null;
            try {
                object2 = GenericObjectEditor.this.makeCopy(object);
                this.setCancelButton(true);
            }
            catch (Exception exception) {
                this.setCancelButton(false);
                System.err.println("GenericObjectEditor: Problem making backup object");
                System.err.println(exception);
            }
            return object2;
        }

        public void setOkButtonText(String string) {
            this.m_okBut.setText(string);
        }

        public void addOkListener(ActionListener actionListener) {
            this.m_okBut.addActionListener(actionListener);
        }

        public void addCancelListener(ActionListener actionListener) {
            this.m_cancelBut.addActionListener(actionListener);
        }

        public void removeOkListener(ActionListener actionListener) {
            this.m_okBut.removeActionListener(actionListener);
        }

        public void removeCancelListener(ActionListener actionListener) {
            this.m_cancelBut.removeActionListener(actionListener);
        }

        public void updateChildPropertySheet() {
            String string = "None";
            if (GenericObjectEditor.this.m_Object != null) {
                string = GenericObjectEditor.this.m_Object.getClass().getName();
            }
            this.m_ClassNameLabel.setText(string);
            this.m_ChildPropertySheet.setTarget(GenericObjectEditor.this.m_Object);
            if (this.getTopLevelAncestor() != null && this.getTopLevelAncestor() instanceof Window) {
                ((Window)this.getTopLevelAncestor()).pack();
            }
        }
    }

    public class JTreePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -3404546329655057387L;
        private JPopupMenu m_Self;
        private JTree m_tree;
        private JScrollPane m_scroller;
        private JButton m_FilterButton = new JButton("Filter...");
        private JButton m_RemoveFilterButton = new JButton("Remove filter");
        private JButton m_CloseButton = new JButton("Close");

        public JTreePopupMenu(JTree jTree) {
            this.m_Self = this;
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(2));
            this.add((Component)jPanel, "South");
            if (ClassDiscovery.hasInterface(CapabilitiesHandler.class, GenericObjectEditor.this.m_ClassType)) {
                this.m_FilterButton.setMnemonic('F');
                this.m_FilterButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getSource() == JTreePopupMenu.this.m_FilterButton) {
                            CapabilitiesFilterDialog capabilitiesFilterDialog = new CapabilitiesFilterDialog();
                            capabilitiesFilterDialog.setCapabilities(GenericObjectEditor.this.m_CapabilitiesFilter);
                            capabilitiesFilterDialog.setPopup(JTreePopupMenu.this.m_Self);
                            capabilitiesFilterDialog.setVisible(true);
                            JTreePopupMenu.this.repaint();
                        }
                    }
                });
                jPanel.add(this.m_FilterButton);
                this.m_RemoveFilterButton.setMnemonic('R');
                this.m_RemoveFilterButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getSource() == JTreePopupMenu.this.m_RemoveFilterButton) {
                            GenericObjectEditor.this.m_CapabilitiesFilter = null;
                            JTreePopupMenu.this.repaint();
                        }
                    }
                });
                jPanel.add(this.m_RemoveFilterButton);
            }
            this.m_CloseButton.setMnemonic('C');
            this.m_CloseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == JTreePopupMenu.this.m_CloseButton) {
                        JTreePopupMenu.this.m_Self.setVisible(false);
                    }
                }
            });
            jPanel.add(this.m_CloseButton);
            this.m_tree = jTree;
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)this.m_tree, "North");
            jPanel2.setBackground(this.m_tree.getBackground());
            this.m_scroller = new JScrollPane(jPanel2);
            this.m_scroller.setPreferredSize(new Dimension(300, 400));
            this.m_scroller.getVerticalScrollBar().setUnitIncrement(20);
            this.add(this.m_scroller);
        }

        public void show(Component component, int n, int n2) {
            super.show(component, n, n2);
            Point point = this.getLocationOnScreen();
            Dimension dimension = this.getToolkit().getScreenSize();
            int n3 = (int)(dimension.getWidth() - point.getX());
            int n4 = (int)(dimension.getHeight() - point.getY());
            Dimension dimension2 = this.m_scroller.getPreferredSize();
            int n5 = (int)dimension2.getHeight();
            int n6 = (int)dimension2.getWidth();
            if (n6 > n3) {
                n6 = n3;
            }
            if (n5 > n4) {
                n5 = n4;
            }
            this.m_scroller.setPreferredSize(new Dimension(n6, n5));
            this.revalidate();
            this.pack();
        }
    }

    public class CapabilitiesFilterDialog
    extends JDialog {
        static final long serialVersionUID = -7845503345689646266L;
        protected JDialog m_Self;
        protected JPopupMenu m_Popup = null;
        protected Capabilities m_Capabilities = new Capabilities(null);
        protected JLabel m_InfoLabel = new JLabel();
        protected CheckBoxList m_List = new CheckBoxList();
        protected JButton m_OkButton = new JButton("OK");
        protected JButton m_CancelButton = new JButton("Cancel");

        public CapabilitiesFilterDialog() {
            this.m_Self = this;
            this.initGUI();
        }

        protected void initGUI() {
            this.setTitle("Filtering Capabilities...");
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)jPanel, "North");
            this.m_InfoLabel.setText("<html>" + GenericObjectEditor.this.m_ClassType.getName().replaceAll(".*\\.", "") + "s" + " have to support <i>at least</i> the following capabilities <br>" + "(the ones highlighted <font color=\"" + "red" + "\">" + "red" + "</font> don't meet these requirements <br>" + "the ones highlighted  <font color=\"" + "blue" + "\">" + "blue" + "</font> possibly meet them):" + "</html>");
            jPanel.add((Component)this.m_InfoLabel, "Center");
            this.getContentPane().add((Component)new JScrollPane(this.m_List), "Center");
            CheckBoxList.CheckBoxListModel checkBoxListModel = (CheckBoxList.CheckBoxListModel)this.m_List.getModel();
            for (Capabilities.Capability capability : Capabilities.Capability.values()) {
                checkBoxListModel.addElement((Object)capability);
            }
            jPanel = new JPanel(new FlowLayout(1));
            this.getContentPane().add((Component)jPanel, "South");
            this.m_OkButton.setMnemonic('O');
            this.m_OkButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CapabilitiesFilterDialog.this.updateCapabilities();
                    if (GenericObjectEditor.this.m_CapabilitiesFilter == null) {
                        GenericObjectEditor.this.m_CapabilitiesFilter = new Capabilities(null);
                    }
                    GenericObjectEditor.this.m_CapabilitiesFilter.assign(CapabilitiesFilterDialog.this.m_Capabilities);
                    CapabilitiesFilterDialog.this.m_Self.setVisible(false);
                    CapabilitiesFilterDialog.this.showPopup();
                }
            });
            jPanel.add(this.m_OkButton);
            this.m_CancelButton.setMnemonic('C');
            this.m_CancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CapabilitiesFilterDialog.this.m_Self.setVisible(false);
                    CapabilitiesFilterDialog.this.showPopup();
                }
            });
            jPanel.add(this.m_CancelButton);
            this.pack();
        }

        protected void updateList() {
            CheckBoxList.CheckBoxListModel checkBoxListModel = (CheckBoxList.CheckBoxListModel)this.m_List.getModel();
            for (Capabilities.Capability capability : Capabilities.Capability.values()) {
                checkBoxListModel.setChecked(checkBoxListModel.indexOf((Object)capability), this.m_Capabilities.handles(capability));
            }
        }

        protected void updateCapabilities() {
            CheckBoxList.CheckBoxListModel checkBoxListModel = (CheckBoxList.CheckBoxListModel)this.m_List.getModel();
            for (Capabilities.Capability capability : Capabilities.Capability.values()) {
                if (checkBoxListModel.getChecked(checkBoxListModel.indexOf((Object)capability))) {
                    this.m_Capabilities.enable(capability);
                    continue;
                }
                this.m_Capabilities.disable(capability);
            }
        }

        public void setCapabilities(Capabilities capabilities) {
            if (capabilities != null) {
                this.m_Capabilities.assign(capabilities);
            } else {
                this.m_Capabilities = new Capabilities(null);
            }
            this.updateList();
        }

        public Capabilities getCapabilities() {
            return this.m_Capabilities;
        }

        public void setPopup(JPopupMenu jPopupMenu) {
            this.m_Popup = jPopupMenu;
        }

        public JPopupMenu getPopup() {
            return this.m_Popup;
        }

        public void showPopup() {
            if (this.getPopup() != null) {
                this.getPopup().setVisible(true);
            }
        }
    }

    public class GOETreeNode
    extends DefaultMutableTreeNode {
        static final long serialVersionUID = -1707872446682150133L;
        public static final String NO_SUPPORT = "red";
        public static final String MAYBE_SUPPORT = "blue";
        protected Capabilities m_Capabilities;

        public GOETreeNode() {
            this.m_Capabilities = null;
        }

        public GOETreeNode(Object object) {
            super(object);
            this.m_Capabilities = null;
        }

        public GOETreeNode(Object object, boolean bl) {
            super(object, bl);
            this.m_Capabilities = null;
        }

        protected void initCapabilities() {
            if (this.m_Capabilities != null) {
                return;
            }
            if (!this.isLeaf()) {
                return;
            }
            String string = GenericObjectEditor.this.getClassnameFromPath(new TreePath(this.getPath()));
            try {
                Class<?> clazz = Class.forName(string);
                if (!ClassDiscovery.hasInterface(CapabilitiesHandler.class, clazz)) {
                    return;
                }
                Object obj = clazz.newInstance();
                this.m_Capabilities = ((CapabilitiesHandler)obj).getCapabilities();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            String string = super.toString();
            if (GenericObjectEditor.this.m_CapabilitiesFilter != null) {
                this.initCapabilities();
                if (this.m_Capabilities != null) {
                    if (this.m_Capabilities.supportsMaybe(GenericObjectEditor.this.m_CapabilitiesFilter) && !this.m_Capabilities.supports(GenericObjectEditor.this.m_CapabilitiesFilter)) {
                        string = "<html><font color=\"blue\">" + string + "</font></i><html>";
                    } else if (!this.m_Capabilities.supports(GenericObjectEditor.this.m_CapabilitiesFilter)) {
                        string = "<html><font color=\"red\">" + string + "</font></i><html>";
                    }
                }
            }
            return string;
        }
    }
}

