/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.gui.sql.SqlViewer;
import weka.gui.sql.event.ResultChangedEvent;
import weka.gui.sql.event.ResultChangedListener;

public class SqlViewerDialog
extends JDialog
implements ResultChangedListener {
    private static final long serialVersionUID = -31619864037233099L;
    protected JFrame m_Parent;
    protected SqlViewer m_Viewer;
    protected JPanel m_PanelButtons;
    protected JButton m_ButtonOK = new JButton("OK");
    protected JButton m_ButtonCancel = new JButton("Cancel");
    protected JLabel m_LabelQuery = new JLabel("");
    protected int m_ReturnValue = 2;
    protected String m_URL;
    protected String m_User;
    protected String m_Password;
    protected String m_Query;

    public SqlViewerDialog(JFrame jFrame) {
        super(jFrame, "SQL-Viewer", true);
        this.m_Parent = jFrame;
        this.m_URL = "";
        this.m_User = "";
        this.m_Password = "";
        this.m_Query = "";
        this.createDialog();
    }

    protected void createDialog() {
        final SqlViewerDialog sqlViewerDialog = this;
        this.setLayout(new BorderLayout());
        this.m_Viewer = new SqlViewer(this.m_Parent);
        this.add((Component)this.m_Viewer, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel.add((Component)jPanel2, "East");
        this.m_ButtonOK.setMnemonic('O');
        jPanel2.add(this.m_ButtonOK);
        this.m_ButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SqlViewerDialog.this.m_ReturnValue = 0;
                SqlViewerDialog.this.m_Viewer.removeResultChangedListener(sqlViewerDialog);
                SqlViewerDialog.this.m_Viewer.saveSize();
                sqlViewerDialog.dispose();
            }
        });
        this.m_ButtonCancel.setMnemonic('C');
        jPanel2.add(this.m_ButtonCancel);
        this.m_ButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SqlViewerDialog.this.m_ReturnValue = 2;
                SqlViewerDialog.this.m_Viewer.removeResultChangedListener(sqlViewerDialog);
                SqlViewerDialog.this.m_Viewer.saveSize();
                sqlViewerDialog.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SqlViewerDialog.this.m_Viewer.saveSize();
            }
        });
        jPanel2 = new JPanel(new FlowLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.add(this.m_LabelQuery);
        this.pack();
        this.getRootPane().setDefaultButton(this.m_ButtonOK);
        this.setResizable(true);
        this.m_Viewer.addResultChangedListener(this);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.m_ReturnValue = 2;
        }
        super.setVisible(bl);
        if (bl) {
            this.m_Viewer.clear();
        }
    }

    public int getReturnValue() {
        return this.m_ReturnValue;
    }

    public String getURL() {
        return this.m_URL;
    }

    public String getUser() {
        return this.m_User;
    }

    public String getPassword() {
        return this.m_Password;
    }

    public String getQuery() {
        return this.m_Query;
    }

    public void resultChanged(ResultChangedEvent resultChangedEvent) {
        this.m_URL = resultChangedEvent.getURL();
        this.m_User = resultChangedEvent.getUser();
        this.m_Password = resultChangedEvent.getPassword();
        this.m_Query = resultChangedEvent.getQuery();
        this.m_LabelQuery.setText("Current query: " + this.m_Query);
    }

    public static void main(String[] stringArray) {
        SqlViewerDialog sqlViewerDialog = new SqlViewerDialog(null);
        sqlViewerDialog.setDefaultCloseOperation(2);
        sqlViewerDialog.setVisible(true);
        System.out.println("ReturnValue = " + sqlViewerDialog.getReturnValue());
        if (sqlViewerDialog.getReturnValue() == 0) {
            System.out.println("URL      = " + sqlViewerDialog.getURL());
            System.out.println("User     = " + sqlViewerDialog.getUser());
            System.out.println("Password = " + sqlViewerDialog.getPassword().replaceAll(".", "*"));
            System.out.println("Query    = " + sqlViewerDialog.getQuery());
        }
    }
}

