/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.io.Serializable;
import weka.core.matrix.Matrix;

public class CholeskyDecomposition
implements Serializable {
    private static final long serialVersionUID = -8739775942782694701L;
    private double[][] L;
    private int n;
    private boolean isspd;

    public CholeskyDecomposition(Matrix matrix) {
        double[][] dArray = matrix.getArray();
        this.n = matrix.getRowDimension();
        this.L = new double[this.n][this.n];
        this.isspd = matrix.getColumnDimension() == this.n;
        for (int i = 0; i < this.n; ++i) {
            int n;
            double[] dArray2 = this.L[i];
            double d = 0.0;
            for (n = 0; n < i; ++n) {
                double[] dArray3 = this.L[n];
                double d2 = 0.0;
                for (int j = 0; j < n; ++j) {
                    d2 += dArray3[j] * dArray2[j];
                }
                dArray2[n] = d2 = (dArray[i][n] - d2) / this.L[n][n];
                d += d2 * d2;
                this.isspd &= dArray[n][i] == dArray[i][n];
            }
            this.isspd &= (d = dArray[i][i] - d) > 0.0;
            this.L[i][i] = Math.sqrt(Math.max(d, 0.0));
            for (n = i + 1; n < this.n; ++n) {
                this.L[i][n] = 0.0;
            }
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix getL() {
        return new Matrix(this.L, this.n, this.n);
    }

    public Matrix solve(Matrix matrix) {
        int n;
        int n2;
        int n3;
        if (matrix.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] dArray = matrix.getArrayCopy();
        int n4 = matrix.getColumnDimension();
        for (n3 = 0; n3 < this.n; ++n3) {
            for (n2 = n3 + 1; n2 < this.n; ++n2) {
                for (n = 0; n < n4; ++n) {
                    double[] dArray2 = dArray[n2];
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] - dArray[n3][n] * this.L[n2][n3];
                }
            }
            n2 = 0;
            while (n2 < n4) {
                double[] dArray3 = dArray[n3];
                int n6 = n2++;
                dArray3[n6] = dArray3[n6] / this.L[n3][n3];
            }
        }
        for (n3 = this.n - 1; n3 >= 0; --n3) {
            n2 = 0;
            while (n2 < n4) {
                double[] dArray4 = dArray[n3];
                int n7 = n2++;
                dArray4[n7] = dArray4[n7] / this.L[n3][n3];
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    double[] dArray5 = dArray[n2];
                    int n8 = n;
                    dArray5[n8] = dArray5[n8] - dArray[n3][n] * this.L[n3][n2];
                }
            }
        }
        return new Matrix(dArray, this.n, n4);
    }
}

