/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RelationalLocator;
import weka.core.StringLocator;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class PropositionalToMultiInstance
extends Filter
implements OptionHandler,
UnsupervisedFilter {
    private static final long serialVersionUID = 5825873573912102482L;
    protected int m_Seed = 1;
    protected boolean m_Randomize = false;
    protected StringLocator m_BagStringAtts = null;
    protected RelationalLocator m_BagRelAtts = null;

    public String globalInfo() {
        return "Converts the propositional instance dataset into multi-instance dataset (with relational attribute). When normalize or standardize a multi-instance dataset, a MIToSingleInstance filter can be applied first to convert the multi-instance dataset into propositional instance dataset. After normalization or standardization, may use this PropositionalToMultiInstance filter to convert the data back to multi-instance format.\n\nNote: the first attribute of the original propositional instance dataset must be a nominal attribute which is expected to be bagId attribute.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe seed for the randomization of the order of bags.\t(default 1)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tRandomizes the order of the produced bags after the generation.\t(default off)", "R", 0, "-R"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setRandomize(Utils.getFlag('R', stringArray));
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        } else {
            this.setSeed(1);
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-S");
        vector.add("" + this.getSeed());
        if (this.m_Randomize) {
            vector.add("-R");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String seedTipText() {
        return "The random seed used by the random number generator";
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setRandomize(boolean bl) {
        this.m_Randomize = bl;
    }

    public boolean getRandomize() {
        return this.m_Randomize;
    }

    public String randomizeTipText() {
        return "Whether the order of the generated data is randomized.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        if (instances.attribute(0).type() != 1) {
            throw new Exception("The first attribute type of the original propositional instance dataset must be Nominal!");
        }
        super.setInputFormat(instances);
        Instances instances2 = instances.stringFreeStructure();
        Attribute attribute = (Attribute)instances2.attribute(0).copy();
        Attribute attribute2 = (Attribute)instances2.classAttribute().copy();
        instances2.deleteAttributeAt(0);
        instances2.setClassIndex(-1);
        instances2.deleteAttributeAt(instances2.numAttributes() - 1);
        FastVector fastVector = new FastVector(3);
        fastVector.addElement(attribute);
        fastVector.addElement(new Attribute("bag", instances2));
        fastVector.addElement(attribute2);
        Instances instances3 = new Instances("Multi-Instance-Dataset", fastVector, 0);
        instances3.setClassIndex(instances3.numAttributes() - 1);
        super.setOutputFormat(instances3.stringFreeStructure());
        this.m_BagStringAtts = new StringLocator(instances3.attribute(1).relation());
        this.m_BagRelAtts = new RelationalLocator(instances3.attribute(1).relation());
        return true;
    }

    protected void addBag(Instances instances, Instances instances2, Instances instances3, int n, double d, double d2) {
        int n2;
        for (n2 = 0; n2 < instances3.numInstances(); ++n2) {
            RelationalLocator.copyRelationalValues(instances3.instance(n2), false, instances, this.m_InputRelAtts, instances3, this.m_BagRelAtts);
            StringLocator.copyStringValues(instances3.instance(n2), false, instances, this.m_InputStringAtts, instances3, this.m_BagStringAtts);
        }
        n2 = instances2.attribute(1).addRelation(instances3);
        Instance instance = new Instance(instances2.numAttributes());
        instance.setValue(0, (double)n);
        instance.setValue(2, d);
        instance.setValue(1, (double)n2);
        instance.setWeight(d2);
        instance.setDataset(instances2);
        instances2.add(instance);
    }

    protected void push(Instance instance) {
        if (instance != null) {
            super.push(instance);
        }
    }

    public boolean batchFinished() {
        int n;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        Instances instances = this.getInputFormat();
        instances.sort(0);
        Instances instances2 = this.getOutputFormat();
        Instances instances3 = instances2.attribute(1).relation();
        Instance instance = new Instance(instances3.numAttributes());
        instance.setDataset(instances3);
        double d = instances.instance(0).value(0);
        double d2 = instances.instance(0).classValue();
        double d3 = 0.0;
        for (n = 0; n < instances.numInstances(); ++n) {
            double d4 = instances.instance(n).value(0);
            for (int i = 0; i < instances.numAttributes() - 2; ++i) {
                instance.setValue(i, instances.instance(n).value(i + 1));
            }
            instance.setWeight(instances.instance(n).weight());
            if (d4 == d) {
                instances3.add(instance);
                d3 += instance.weight();
                continue;
            }
            this.addBag(instances, instances2, instances3, (int)d, d2, d3);
            instances3 = instances3.stringFreeStructure();
            instances3.add(instance);
            d = d4;
            d2 = instances.instance(n).classValue();
            d3 = instance.weight();
        }
        this.addBag(instances, instances2, instances3, (int)d, d2, d3);
        if (this.getRandomize()) {
            instances2.randomize(new Random(this.getSeed()));
        }
        for (n = 0; n < instances2.numInstances(); ++n) {
            this.push(instances2.instance(n));
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public static void main(String[] stringArray) {
        PropositionalToMultiInstance.runFilter(new PropositionalToMultiInstance(), stringArray);
    }
}

