/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AdditionalMeasureProducer;

public class PerformanceStats
implements AdditionalMeasureProducer,
Serializable {
    private static final long serialVersionUID = -7215110351388368092L;
    protected int m_NumQueries;
    public double m_MinP;
    public double m_MaxP;
    public double m_SumP;
    public double m_SumSqP;
    public double m_PointCount;
    public double m_MinC;
    public double m_MaxC;
    public double m_SumC;
    public double m_SumSqC;
    public double m_CoordCount;

    public PerformanceStats() {
        this.reset();
    }

    public void reset() {
        this.m_NumQueries = 0;
        this.m_PointCount = 0.0;
        this.m_SumSqP = 0.0;
        this.m_SumP = 0.0;
        this.m_MinP = 2.147483647E9;
        this.m_MaxP = -2.147483648E9;
        this.m_CoordCount = 0.0;
        this.m_SumSqC = 0.0;
        this.m_SumC = 0.0;
        this.m_MinC = 2.147483647E9;
        this.m_MaxC = -2.147483648E9;
    }

    public void searchStart() {
        this.m_PointCount = 0.0;
        this.m_CoordCount = 0.0;
    }

    public void searchFinish() {
        ++this.m_NumQueries;
        this.m_SumP += this.m_PointCount;
        this.m_SumSqP += this.m_PointCount * this.m_PointCount;
        if (this.m_PointCount < this.m_MinP) {
            this.m_MinP = this.m_PointCount;
        }
        if (this.m_PointCount > this.m_MaxP) {
            this.m_MaxP = this.m_PointCount;
        }
        double d = this.m_CoordCount / this.m_PointCount;
        this.m_SumC += d;
        this.m_SumSqC += d * d;
        if (d < this.m_MinC) {
            this.m_MinC = d;
        }
        if (d > this.m_MaxC) {
            this.m_MaxC = d;
        }
    }

    public void incrPointCount() {
        this.m_PointCount += 1.0;
    }

    public void incrCoordCount() {
        this.m_CoordCount += 1.0;
    }

    public void updatePointCount(int n) {
        this.m_PointCount += (double)n;
    }

    public int getNumQueries() {
        return this.m_NumQueries;
    }

    public double getTotalPointsVisited() {
        return this.m_SumP;
    }

    public double getMeanPointsVisited() {
        return this.m_SumP / (double)this.m_NumQueries;
    }

    public double getStdDevPointsVisited() {
        return Math.sqrt((this.m_SumSqP - this.m_SumP * this.m_SumP / (double)this.m_NumQueries) / (double)(this.m_NumQueries - 1));
    }

    public double getMinPointsVisited() {
        return this.m_MinP;
    }

    public double getMaxPointsVisited() {
        return this.m_MaxP;
    }

    public double getTotalCoordsPerPoint() {
        return this.m_SumC;
    }

    public double getMeanCoordsPerPoint() {
        return this.m_SumC / (double)this.m_NumQueries;
    }

    public double getStdDevCoordsPerPoint() {
        return Math.sqrt((this.m_SumSqC - this.m_SumC * this.m_SumC / (double)this.m_NumQueries) / (double)(this.m_NumQueries - 1));
    }

    public double getMinCoordsPerPoint() {
        return this.m_MinC;
    }

    public double getMaxCoordsPerPoint() {
        return this.m_MaxC;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("measureTotal_points_visited");
        vector.addElement("measureMean_points_visited");
        vector.addElement("measureStdDev_points_visited");
        vector.addElement("measureMin_points_visited");
        vector.addElement("measureMax_points_visited");
        vector.addElement("measureTotalCoordsPerPoint");
        vector.addElement("measureMeanCoordsPerPoint");
        vector.addElement("measureStdDevCoordsPerPoint");
        vector.addElement("measureMinCoordsPerPoint");
        vector.addElement("measureMaxCoordsPerPoint");
        return vector.elements();
    }

    public double getMeasure(String string) throws IllegalArgumentException {
        if (string.compareToIgnoreCase("measureTotal_points_visited") == 0) {
            return this.getTotalPointsVisited();
        }
        if (string.compareToIgnoreCase("measureMean_points_visited") == 0) {
            return this.getMeanPointsVisited();
        }
        if (string.compareToIgnoreCase("measureStdDev_points_visited") == 0) {
            return this.getStdDevPointsVisited();
        }
        if (string.compareToIgnoreCase("measureMin_points_visited") == 0) {
            return this.getMinPointsVisited();
        }
        if (string.compareToIgnoreCase("measureMax_points_visited") == 0) {
            return this.getMaxPointsVisited();
        }
        if (string.compareToIgnoreCase("measureTotalCoordsPerPoint") == 0) {
            return this.getTotalCoordsPerPoint();
        }
        if (string.compareToIgnoreCase("measureMeanCoordsPerPoint") == 0) {
            return this.getMeanCoordsPerPoint();
        }
        if (string.compareToIgnoreCase("measureStdDevCoordsPerPoint") == 0) {
            return this.getStdDevCoordsPerPoint();
        }
        if (string.compareToIgnoreCase("measureMinCoordsPerPoint") == 0) {
            return this.getMinCoordsPerPoint();
        }
        if (string.compareToIgnoreCase("measureMaxCoordsPerPoint") == 0) {
            return this.getMaxCoordsPerPoint();
        }
        throw new IllegalArgumentException(string + " not supported by PerformanceStats.");
    }

    public String getStats() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("           min, max, total, mean, stddev\n");
        stringBuffer.append("Points:    " + this.getMinPointsVisited() + ", " + this.getMaxPointsVisited() + "," + this.getTotalPointsVisited() + "," + this.getMeanPointsVisited() + ", " + this.getStdDevPointsVisited() + "\n");
        return stringBuffer.toString();
    }
}

