/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.adtree;

import java.util.Enumeration;
import weka.classifiers.trees.adtree.PredictionNode;
import weka.classifiers.trees.adtree.ReferenceInstances;
import weka.classifiers.trees.adtree.Splitter;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class TwoWayNumericSplit
extends Splitter {
    private int attIndex;
    private double splitPoint;
    private PredictionNode[] children;

    public TwoWayNumericSplit(int n, double d) {
        this.attIndex = n;
        this.splitPoint = d;
        this.children = new PredictionNode[2];
    }

    public int getNumOfBranches() {
        return 2;
    }

    public int branchInstanceGoesDown(Instance instance) {
        if (instance.isMissing(this.attIndex)) {
            return -1;
        }
        if (instance.value(this.attIndex) < this.splitPoint) {
            return 0;
        }
        return 1;
    }

    public ReferenceInstances instancesDownBranch(int n, Instances instances) {
        ReferenceInstances referenceInstances = new ReferenceInstances(instances, 1);
        if (n == -1) {
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                Instance instance = (Instance)enumeration.nextElement();
                if (!instance.isMissing(this.attIndex)) continue;
                referenceInstances.addReference(instance);
            }
        } else if (n == 0) {
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                Instance instance = (Instance)enumeration.nextElement();
                if (instance.isMissing(this.attIndex) || !(instance.value(this.attIndex) < this.splitPoint)) continue;
                referenceInstances.addReference(instance);
            }
        } else {
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                Instance instance = (Instance)enumeration.nextElement();
                if (instance.isMissing(this.attIndex) || !(instance.value(this.attIndex) >= this.splitPoint)) continue;
                referenceInstances.addReference(instance);
            }
        }
        return referenceInstances;
    }

    public String attributeString(Instances instances) {
        return instances.attribute(this.attIndex).name();
    }

    public String comparisonString(int n, Instances instances) {
        return (n == 0 ? "< " : ">= ") + Utils.doubleToString(this.splitPoint, 3);
    }

    public boolean equalTo(Splitter splitter) {
        if (splitter instanceof TwoWayNumericSplit) {
            TwoWayNumericSplit twoWayNumericSplit = (TwoWayNumericSplit)splitter;
            return this.attIndex == twoWayNumericSplit.attIndex && this.splitPoint == twoWayNumericSplit.splitPoint;
        }
        return false;
    }

    public void setChildForBranch(int n, PredictionNode predictionNode) {
        this.children[n] = predictionNode;
    }

    public PredictionNode getChildForBranch(int n) {
        return this.children[n];
    }

    public Object clone() {
        TwoWayNumericSplit twoWayNumericSplit = new TwoWayNumericSplit(this.attIndex, this.splitPoint);
        twoWayNumericSplit.orderAdded = this.orderAdded;
        if (this.children[0] != null) {
            twoWayNumericSplit.setChildForBranch(0, (PredictionNode)this.children[0].clone());
        }
        if (this.children[1] != null) {
            twoWayNumericSplit.setChildForBranch(1, (PredictionNode)this.children[1].clone());
        }
        return twoWayNumericSplit;
    }
}

