/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.AttributeSetEvaluator;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class SymmetricalUncertAttributeSetEval
extends AttributeSetEvaluator
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 8351377335495873202L;
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private int m_numClasses;
    private boolean m_missing_merge;

    public String globalInfo() {
        return "SymmetricalUncertAttributeSetEval :\n\nEvaluates the worth of a set attributes by measuring the symmetrical uncertainty with respect to another set of attributes. \n\n SymmU(AttributeSet2, AttributeSet1) = 2 * (H(AttributeSet2) - H(AttributeSet1 | AttributeSet2)) / H(AttributeSet2) + H(AttributeSet1).\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Lei Yu and Huan Liu");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Feature Selection for High-Dimensional Data: A Fast Correlation-Based Filter Solution");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the Twentieth International Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "856-863");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "AAAI Press");
        return technicalInformation;
    }

    public SymmetricalUncertAttributeSetEval() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\ttreat missing values as a seperate value.", "M", 0, "-M"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        this.setMissingMerge(!Utils.getFlag('M', stringArray));
    }

    public String missingMergeTipText() {
        return "Distribute counts for missing values. Counts are distributed across other values in proportion to their frequency. Otherwise, missing is treated as a separate value.";
    }

    public void setMissingMerge(boolean bl) {
        this.m_missing_merge = bl;
    }

    public boolean getMissingMerge() {
        return this.m_missing_merge;
    }

    public String[] getOptions() {
        String[] stringArray = new String[1];
        int n = 0;
        if (!this.getMissingMerge()) {
            stringArray[n++] = "-M";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_trainInstances = instances;
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        Discretize discretize = new Discretize();
        discretize.setUseBetterEncoding(true);
        discretize.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, discretize);
        this.m_numClasses = this.m_trainInstances.attribute(this.m_classIndex).numValues();
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_missing_merge = true;
    }

    public double evaluateAttribute(int n) throws Exception {
        int n2;
        int n3;
        double d = 0.0;
        int n4 = this.m_trainInstances.attribute(n).numValues() + 1;
        int n5 = this.m_numClasses + 1;
        double d2 = 0.0;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n5];
        double[][] dArray3 = new double[n4][n5];
        dArray = new double[n4];
        dArray2 = new double[n5];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = 0.0;
            for (n2 = 0; n2 < n5; ++n2) {
                dArray2[n2] = 0.0;
                dArray3[n3][n2] = 0.0;
            }
        }
        for (n3 = 0; n3 < this.m_numInstances; ++n3) {
            Instance instance = this.m_trainInstances.instance(n3);
            int n6 = instance.isMissing(n) ? n4 - 1 : (int)instance.value(n);
            int n7 = instance.isMissing(this.m_classIndex) ? n5 - 1 : (int)instance.value(this.m_classIndex);
            double[] dArray4 = dArray3[n6];
            int n8 = n7;
            dArray4[n8] = dArray4[n8] + 1.0;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = 0.0;
            for (n2 = 0; n2 < n5; ++n2) {
                int n9 = n3;
                dArray[n9] = dArray[n9] + dArray3[n3][n2];
                d += dArray3[n3][n2];
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            dArray2[n2] = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                int n10 = n2;
                dArray2[n10] = dArray2[n10] + dArray3[n3][n2];
            }
        }
        if (this.m_missing_merge && dArray[n4 - 1] < (double)this.m_numInstances && dArray2[n5 - 1] < (double)this.m_numInstances) {
            double[] dArray5 = new double[dArray.length];
            double[] dArray6 = new double[dArray2.length];
            double[][] dArray7 = new double[dArray.length][dArray2.length];
            for (n3 = 0; n3 < n4; ++n3) {
                System.arraycopy(dArray3[n3], 0, dArray7[n3], 0, dArray2.length);
            }
            System.arraycopy(dArray, 0, dArray5, 0, dArray.length);
            System.arraycopy(dArray2, 0, dArray6, 0, dArray2.length);
            double d3 = dArray[n4 - 1] + dArray2[n5 - 1] - dArray3[n4 - 1][n5 - 1];
            if (dArray[n4 - 1] > 0.0) {
                for (n2 = 0; n2 < n5 - 1; ++n2) {
                    if (!(dArray3[n4 - 1][n2] > 0.0)) continue;
                    n3 = 0;
                    while (n3 < n4 - 1) {
                        d2 = dArray5[n3] / (d - dArray5[n4 - 1]) * dArray3[n4 - 1][n2];
                        double[] dArray8 = dArray3[n3];
                        int n11 = n2;
                        dArray8[n11] = dArray8[n11] + d2;
                        int n12 = n3++;
                        dArray[n12] = dArray[n12] + d2;
                    }
                    dArray3[n4 - 1][n2] = 0.0;
                }
            }
            dArray[n4 - 1] = 0.0;
            if (dArray2[n5 - 1] > 0.0) {
                for (n3 = 0; n3 < n4 - 1; ++n3) {
                    if (!(dArray3[n3][n5 - 1] > 0.0)) continue;
                    n2 = 0;
                    while (n2 < n5 - 1) {
                        d2 = dArray6[n2] / (d - dArray6[n5 - 1]) * dArray3[n3][n5 - 1];
                        double[] dArray9 = dArray3[n3];
                        int n13 = n2;
                        dArray9[n13] = dArray9[n13] + d2;
                        int n14 = n2++;
                        dArray2[n14] = dArray2[n14] + d2;
                    }
                    dArray3[n3][n5 - 1] = 0.0;
                }
            }
            dArray2[n5 - 1] = 0.0;
            if (dArray3[n4 - 1][n5 - 1] > 0.0 && d3 != d) {
                for (n3 = 0; n3 < n4 - 1; ++n3) {
                    n2 = 0;
                    while (n2 < n5 - 1) {
                        d2 = dArray7[n3][n2] / (d - d3) * dArray7[n4 - 1][n5 - 1];
                        double[] dArray10 = dArray3[n3];
                        int n15 = n2;
                        dArray10[n15] = dArray10[n15] + d2;
                        int n16 = n3;
                        dArray[n16] = dArray[n16] + d2;
                        int n17 = n2++;
                        dArray2[n17] = dArray2[n17] + d2;
                    }
                }
                dArray3[n4 - 1][n5 - 1] = 0.0;
            }
        }
        return ContingencyTables.symmetricalUncertainty(dArray3);
    }

    public double evaluateAttribute(int[] nArray, int[] nArray2) throws Exception {
        int n;
        int n2;
        double d = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        if (nArray.length == 0) {
            throw new Exception("the parameter attributes[] is empty;SEQ:W-FS-Eval-SUAS-001");
        }
        if (nArray2.length == 0) {
            throw new Exception("the parameter classAttributes[] is empty;SEQ:W-FS-Eval-SUAS-002");
        }
        int n3 = this.m_trainInstances.attribute(nArray[0]).numValues();
        if (n3 == 0) {
            throw new Exception("an attribute is empty;SEQ:W-FS-Eval-SUAS-003;1");
        }
        for (n2 = 1; n2 < nArray.length; ++n2) {
            if (this.m_trainInstances.attribute(nArray[n2]).numValues() == 0) {
                throw new Exception("an attribute is empty;SEQ:W-FS-Eval-SUAS-003;" + (n2 + 1));
            }
            n3 *= this.m_trainInstances.attribute(nArray[n2]).numValues();
        }
        ++n3;
        int n4 = this.m_trainInstances.attribute(nArray2[0]).numValues();
        if (n4 == 0) {
            throw new Exception("the a classAttribute is empty;SEQ:W-FS-Eval-SUAS-004;1");
        }
        for (n2 = 1; n2 < nArray2.length; ++n2) {
            if (this.m_trainInstances.attribute(nArray2[n2]).numValues() == 0) {
                throw new Exception("the a classAttribute is empty;SEQ:W-FS-Eval-SUAS-004;" + (n2 + 1));
            }
            n4 *= this.m_trainInstances.attribute(nArray2[n2]).numValues();
        }
        double d2 = 0.0;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[++n4];
        double[][] dArray3 = new double[n3][n4];
        dArray = new double[n3];
        dArray2 = new double[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = 0.0;
            for (n = 0; n < n4; ++n) {
                dArray2[n] = 0.0;
                dArray3[n2][n] = 0.0;
            }
        }
        for (n2 = 0; n2 < this.m_numInstances; ++n2) {
            int n5;
            Instance instance = this.m_trainInstances.instance(n2);
            bl = false;
            bl2 = false;
            int n6 = 1;
            int n7 = 0;
            for (n5 = nArray.length - 1; n5 >= 0; --n5) {
                if (instance.isMissing(nArray[n5])) {
                    bl = true;
                }
                n7 = (int)instance.value(nArray[n5]) * n6 + n7;
                if (n5 < nArray.length - 1) {
                    n6 *= this.m_trainInstances.attribute(nArray[n5]).numValues();
                    continue;
                }
                n6 = this.m_trainInstances.attribute(nArray[n5]).numValues();
            }
            if (bl) {
                n7 = n3 - 1;
            }
            int n8 = 1;
            int n9 = 0;
            for (n5 = nArray2.length - 1; n5 >= 0; --n5) {
                if (instance.isMissing(nArray2[n5])) {
                    bl2 = true;
                }
                n9 = (int)instance.value(nArray2[n5]) * n8 + n9;
                if (n5 < nArray.length - 1) {
                    n8 *= this.m_trainInstances.attribute(nArray2[n5]).numValues();
                    continue;
                }
                n8 = this.m_trainInstances.attribute(nArray2[n5]).numValues();
            }
            if (bl2) {
                n9 = n4 - 1;
            }
            double[] dArray4 = dArray3[n7];
            int n10 = n9;
            dArray4[n10] = dArray4[n10] + 1.0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = 0.0;
            for (n = 0; n < n4; ++n) {
                int n11 = n2;
                dArray[n11] = dArray[n11] + dArray3[n2][n];
                d += dArray3[n2][n];
            }
        }
        for (n = 0; n < n4; ++n) {
            dArray2[n] = 0.0;
            for (n2 = 0; n2 < n3; ++n2) {
                int n12 = n;
                dArray2[n12] = dArray2[n12] + dArray3[n2][n];
            }
        }
        if (this.m_missing_merge && dArray[n3 - 1] < (double)this.m_numInstances && dArray2[n4 - 1] < (double)this.m_numInstances) {
            double[] dArray5 = new double[dArray.length];
            double[] dArray6 = new double[dArray2.length];
            double[][] dArray7 = new double[dArray.length][dArray2.length];
            for (n2 = 0; n2 < n3; ++n2) {
                System.arraycopy(dArray3[n2], 0, dArray7[n2], 0, dArray2.length);
            }
            System.arraycopy(dArray, 0, dArray5, 0, dArray.length);
            System.arraycopy(dArray2, 0, dArray6, 0, dArray2.length);
            double d3 = dArray[n3 - 1] + dArray2[n4 - 1] - dArray3[n3 - 1][n4 - 1];
            if (dArray[n3 - 1] > 0.0) {
                for (n = 0; n < n4 - 1; ++n) {
                    if (!(dArray3[n3 - 1][n] > 0.0)) continue;
                    n2 = 0;
                    while (n2 < n3 - 1) {
                        d2 = dArray5[n2] / (d - dArray5[n3 - 1]) * dArray3[n3 - 1][n];
                        double[] dArray8 = dArray3[n2];
                        int n13 = n;
                        dArray8[n13] = dArray8[n13] + d2;
                        int n14 = n2++;
                        dArray[n14] = dArray[n14] + d2;
                    }
                    dArray3[n3 - 1][n] = 0.0;
                }
            }
            dArray[n3 - 1] = 0.0;
            if (dArray2[n4 - 1] > 0.0) {
                for (n2 = 0; n2 < n3 - 1; ++n2) {
                    if (!(dArray3[n2][n4 - 1] > 0.0)) continue;
                    n = 0;
                    while (n < n4 - 1) {
                        d2 = dArray6[n] / (d - dArray6[n4 - 1]) * dArray3[n2][n4 - 1];
                        double[] dArray9 = dArray3[n2];
                        int n15 = n;
                        dArray9[n15] = dArray9[n15] + d2;
                        int n16 = n++;
                        dArray2[n16] = dArray2[n16] + d2;
                    }
                    dArray3[n2][n4 - 1] = 0.0;
                }
            }
            dArray2[n4 - 1] = 0.0;
            if (dArray3[n3 - 1][n4 - 1] > 0.0 && d3 != d) {
                for (n2 = 0; n2 < n3 - 1; ++n2) {
                    n = 0;
                    while (n < n4 - 1) {
                        d2 = dArray7[n2][n] / (d - d3) * dArray7[n3 - 1][n4 - 1];
                        double[] dArray10 = dArray3[n2];
                        int n17 = n;
                        dArray10[n17] = dArray10[n17] + d2;
                        int n18 = n2;
                        dArray[n18] = dArray[n18] + d2;
                        int n19 = n++;
                        dArray2[n19] = dArray2[n19] + d2;
                    }
                }
                dArray3[n3 - 1][n4 - 1] = 0.0;
            }
        }
        return ContingencyTables.symmetricalUncertainty(dArray3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_trainInstances == null) {
            stringBuffer.append("\tSymmetrical Uncertainty evaluator has not been built");
        } else {
            stringBuffer.append("\tSymmetrical Uncertainty Ranking Filter");
            if (!this.m_missing_merge) {
                stringBuffer.append("\n\tMissing values treated as seperate");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5511 $");
    }

    public static void main(String[] stringArray) {
        SymmetricalUncertAttributeSetEval.runEvaluator(new SymmetricalUncertAttributeSetEval(), stringArray);
    }
}

