/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.ci;

import java.io.FileReader;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.ci.CISearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ICSSearchAlgorithm
extends CISearchAlgorithm {
    static final long serialVersionUID = -2510985917284798576L;
    private int m_nMaxCardinality = 2;

    String name(int n) {
        return this.m_instances.attribute(n).name();
    }

    int maxn() {
        return this.m_instances.numAttributes();
    }

    public void setMaxCardinality(int n) {
        this.m_nMaxCardinality = n;
    }

    public int getMaxCardinality() {
        return this.m_nMaxCardinality;
    }

    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        int n;
        this.m_BayesNet = bayesNet;
        this.m_instances = instances;
        boolean[][] blArrayArray = new boolean[this.maxn() + 1][];
        boolean[][] blArrayArray2 = new boolean[this.maxn() + 1][];
        SeparationSet[][] separationSetArray = new SeparationSet[this.maxn() + 1][];
        for (n = 0; n < this.maxn() + 1; ++n) {
            blArrayArray[n] = new boolean[this.maxn()];
            blArrayArray2[n] = new boolean[this.maxn()];
            separationSetArray[n] = new SeparationSet[this.maxn()];
        }
        this.calcDependencyGraph(blArrayArray, separationSetArray);
        this.calcVeeNodes(blArrayArray, blArrayArray2, separationSetArray);
        this.calcArcDirections(blArrayArray, blArrayArray2);
        for (n = 0; n < this.maxn(); ++n) {
            ParentSet parentSet = this.m_BayesNet.getParentSet(n);
            while (parentSet.getNrOfParents() > 0) {
                parentSet.deleteLastParent(this.m_instances);
            }
            for (int i = 0; i < this.maxn(); ++i) {
                if (!blArrayArray2[i][n]) continue;
                parentSet.addParent(i, this.m_instances);
            }
        }
    }

    void calcDependencyGraph(boolean[][] blArray, SeparationSet[][] separationSetArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.maxn(); ++n2) {
            for (n = 0; n < this.maxn(); ++n) {
                blArray[n2][n] = true;
            }
        }
        for (n2 = 0; n2 < this.maxn(); ++n2) {
            blArray[n2][n2] = false;
        }
        for (n2 = 0; n2 <= this.getMaxCardinality(); ++n2) {
            int n3;
            for (n = 0; n <= this.maxn() - 2; ++n) {
                for (n3 = n + 1; n3 < this.maxn(); ++n3) {
                    SeparationSet separationSet;
                    if (!blArray[n][n3] || (separationSet = this.existsSepSet(n, n3, n2, blArray)) == null) continue;
                    blArray[n][n3] = false;
                    blArray[n3][n] = false;
                    separationSetArray[n][n3] = separationSet;
                    separationSetArray[n3][n] = separationSet;
                    System.err.print("I(" + this.name(n) + ", {");
                    for (int i = 0; i < n2; ++i) {
                        System.err.print(this.name(separationSet.m_set[i]) + " ");
                    }
                    System.err.print("} ," + this.name(n3) + ")\n");
                }
            }
            System.err.print(n2 + " ");
            for (n = 0; n < this.maxn(); ++n) {
                System.err.print(this.name(n) + " ");
            }
            System.err.print('\n');
            for (n = 0; n < this.maxn(); ++n) {
                for (n3 = 0; n3 < this.maxn(); ++n3) {
                    if (blArray[n][n3]) {
                        System.err.print("X ");
                        continue;
                    }
                    System.err.print(". ");
                }
                System.err.print(this.name(n) + " ");
                System.err.print('\n');
            }
        }
    }

    SeparationSet existsSepSet(int n, int n2, int n3, boolean[][] blArray) {
        int n4;
        SeparationSet separationSet = new SeparationSet();
        separationSet.m_set[n3] = -1;
        if (n3 > 0) {
            separationSet.m_set[0] = this.next(-1, n, n2, blArray);
            for (n4 = 1; n4 < n3; ++n4) {
                separationSet.m_set[n4] = this.next(separationSet.m_set[n4 - 1], n, n2, blArray);
            }
        }
        int n5 = n3 > 0 ? this.maxn() - separationSet.m_set[n3 - 1] - 1 : 0;
        block1: while (n5 >= 0) {
            if (this.isConditionalIndependent(n2, n, separationSet.m_set, n3)) {
                return separationSet;
            }
            if (n3 > 0) {
                separationSet.m_set[n3 - 1] = this.next(separationSet.m_set[n3 - 1], n, n2, blArray);
            }
            n5 = n3 - 1;
            while (n5 >= 0 && separationSet.m_set[n5] >= this.maxn()) {
                for (n5 = n3 - 1; n5 >= 0 && separationSet.m_set[n5] >= this.maxn(); --n5) {
                }
                if (n5 < 0) continue block1;
                separationSet.m_set[n5] = this.next(separationSet.m_set[n5], n, n2, blArray);
                for (n4 = n5 + 1; n4 < n3; ++n4) {
                    separationSet.m_set[n4] = this.next(separationSet.m_set[n4 - 1], n, n2, blArray);
                }
                n5 = n3 - 1;
            }
        }
        return null;
    }

    int next(int n, int n2, int n3, boolean[][] blArray) {
        ++n;
        while (!(n >= this.maxn() || blArray[n2][n] && blArray[n3][n] && n != n3)) {
            ++n;
        }
        return n;
    }

    void calcVeeNodes(boolean[][] blArray, boolean[][] blArray2, SeparationSet[][] separationSetArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.maxn(); ++n2) {
            for (n = 0; n < this.maxn(); ++n) {
                blArray2[n2][n] = false;
            }
        }
        for (n2 = 0; n2 < this.maxn() - 1; ++n2) {
            for (n = n2 + 1; n < this.maxn(); ++n) {
                if (blArray[n2][n]) continue;
                for (int i = 0; i < this.maxn(); ++i) {
                    if (!((i != n2 && i != n && blArray[n2][i] && blArray[n][i]) & !separationSetArray[n2][n].contains(i))) continue;
                    blArray2[n2][i] = true;
                    blArray2[n][i] = true;
                }
            }
        }
    }

    void calcArcDirections(boolean[][] blArray, boolean[][] blArray2) {
        boolean bl;
        do {
            int n;
            int n2;
            int n3;
            int n4;
            bl = false;
            for (n4 = 0; n4 < this.maxn(); ++n4) {
                for (n3 = 0; n3 < this.maxn(); ++n3) {
                    if (n4 == n3 || !blArray2[n4][n3]) continue;
                    for (n2 = 0; n2 < this.maxn(); ++n2) {
                        if (n4 == n2 || n3 == n2 || !blArray[n3][n2] || blArray[n4][n2] || blArray2[n3][n2] || blArray2[n2][n3]) continue;
                        blArray2[n3][n2] = true;
                        bl = true;
                    }
                }
            }
            for (n4 = 0; n4 < this.maxn(); ++n4) {
                for (n3 = 0; n3 < this.maxn(); ++n3) {
                    if (n4 == n3 || !blArray2[n4][n3]) continue;
                    for (n2 = 0; n2 < this.maxn(); ++n2) {
                        if (n4 == n2 || n3 == n2 || !blArray[n4][n2] || !blArray2[n3][n2] || blArray2[n4][n2] || blArray2[n2][n4]) continue;
                        blArray2[n4][n2] = true;
                        bl = true;
                    }
                }
            }
            for (n4 = 0; n4 < this.maxn(); ++n4) {
                for (n3 = 0; n3 < this.maxn(); ++n3) {
                    if (n4 == n3 || !blArray2[n4][n3]) continue;
                    for (n2 = 0; n2 < this.maxn(); ++n2) {
                        if (n2 == n4 || n2 == n3 || !blArray2[n2][n3] || blArray[n2][n4]) continue;
                        for (n = 0; n < this.maxn(); ++n) {
                            if (n == n4 || n == n3 || n == n2 || !blArray[n][n4] || blArray2[n][n4] || blArray2[n4][n] || !blArray[n][n3] || blArray2[n][n3] || blArray2[n3][n] || !blArray[n][n2] || blArray2[n][n2] || blArray2[n2][n]) continue;
                            blArray2[n][n3] = true;
                            bl = true;
                        }
                    }
                }
            }
            for (n4 = 0; n4 < this.maxn(); ++n4) {
                for (n3 = 0; n3 < this.maxn(); ++n3) {
                    if (n4 == n3 || !blArray2[n3][n4]) continue;
                    for (n2 = 0; n2 < this.maxn(); ++n2) {
                        if (n2 == n4 || n2 == n3 || !blArray[n2][n3] || blArray2[n2][n3] || blArray2[n3][n2] || !blArray[n2][n4] || blArray2[n2][n4] || blArray2[n4][n2]) continue;
                        for (n = 0; n < this.maxn(); ++n) {
                            if (n == n4 || n == n3 || n == n2 || !blArray[n][n4] || blArray2[n][n4] || blArray2[n4][n] || !blArray[n][n2] || blArray2[n][n2] || blArray2[n2][n]) continue;
                            blArray2[n4][n] = true;
                            blArray2[n2][n] = true;
                            bl = true;
                        }
                    }
                }
            }
            if (bl) continue;
            for (n4 = 0; !bl && n4 < this.maxn(); ++n4) {
                for (n3 = 0; !bl && n3 < this.maxn(); ++n3) {
                    if (!blArray[n4][n3] || blArray2[n4][n3] || blArray2[n3][n4]) continue;
                    blArray2[n4][n3] = true;
                    bl = true;
                }
            }
        } while (bl);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tWhen determining whether an edge exists a search is performed \n\tfor a set Z that separates the nodes. MaxCardinality determines \n\tthe maximum size of the set Z. This greatly influences the \n\tlength of the search. (default 2)", "cardinality", 1, "-cardinality <num>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption("cardinality", stringArray);
        if (string.length() != 0) {
            this.setMaxCardinality(Integer.parseInt(string));
        } else {
            this.setMaxCardinality(2);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-cardinality");
        vector.add("" + this.getMaxCardinality());
        return vector.toArray(new String[vector.size()]);
    }

    public String maxCardinalityTipText() {
        return "When determining whether an edge exists a search is performed for a set Z that separates the nodes. MaxCardinality determines the maximum size of the set Z. This greatly influences the length of the search. Default value is 2.";
    }

    public String globalInfo() {
        return "This Bayes Network learning algorithm uses conditional independence tests to find a skeleton, finds V-nodes and applies a set of rules to find the directions of the remaining arrows.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] stringArray) {
        try {
            BayesNet bayesNet = new BayesNet();
            bayesNet.setSearchAlgorithm(new ICSSearchAlgorithm());
            Instances instances = new Instances(new FileReader("C:\\eclipse\\workspace\\weka\\data\\contact-lenses.arff"));
            instances.setClassIndex(instances.numAttributes() - 1);
            bayesNet.buildClassifier(instances);
            System.out.println(bayesNet.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class SeparationSet
    implements RevisionHandler {
        public int[] m_set;

        public SeparationSet() {
            this.m_set = new int[ICSSearchAlgorithm.this.getMaxCardinality() + 1];
        }

        public boolean contains(int n) {
            for (int i = 0; i < ICSSearchAlgorithm.this.getMaxCardinality() && this.m_set[i] != -1; ++i) {
                if (this.m_set[i] != n) continue;
                return true;
            }
            return false;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.8 $");
        }
    }
}

