/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.SVMLightLoader;

public class SVMLightSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter {
    private static final long serialVersionUID = 2605714599263995835L;
    public static String FILE_EXTENSION = SVMLightLoader.FILE_EXTENSION;
    public static int MAX_DIGITS = 18;
    protected SingleIndex m_ClassIndex = new SingleIndex("last");

    public SVMLightSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in svm light format.\n\nFor more information about svm light see:\n\nhttp://svmlight.joachims.org/";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe class index\n\t(default: last)", "c", 1, "-c <class index>"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-c");
        vector.add(this.getClassIndex());
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('c', stringArray);
        if (string.length() != 0) {
            this.setClassIndex(string);
        } else {
            this.setClassIndex("last");
        }
    }

    public String getFileDescription() {
        return "svm light data files";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(SVMLightLoader.FILE_EXTENSION);
    }

    public String classIndexTipText() {
        return "Sets the class index (\"first\" and \"last\" are valid values)";
    }

    public String getClassIndex() {
        return this.m_ClassIndex.getSingleIndex();
    }

    public void setClassIndex(String string) {
        this.m_ClassIndex.setSingleIndex(string);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.BINARY_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        return capabilities;
    }

    public void setInstances(Instances instances) {
        this.m_ClassIndex.setUpper(instances.numAttributes() - 1);
        instances.setClassIndex(this.m_ClassIndex.getIndex());
        super.setInstances(instances);
    }

    protected String instanceToSvmlight(Instance instance) {
        StringBuffer stringBuffer = new StringBuffer();
        if (instance.classAttribute().isNominal()) {
            if (instance.classValue() == 0.0) {
                stringBuffer.append("1");
            } else if (instance.classValue() == 1.0) {
                stringBuffer.append("-1");
            }
        } else {
            stringBuffer.append("" + Utils.doubleToString(instance.classValue(), MAX_DIGITS));
        }
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex() || instance.value(i) == 0.0) continue;
            stringBuffer.append(" " + (i + 1) + ":" + Utils.doubleToString(instance.value(i), MAX_DIGITS));
        }
        return stringBuffer.toString();
    }

    public void writeIncremental(Instance instance) throws IOException {
        int n = this.getWriteMode();
        Instances instances = this.getInstances();
        PrintWriter printWriter = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            printWriter = new PrintWriter(this.getWriter());
        }
        if (n == 1) {
            if (instances == null) {
                this.setWriteMode(2);
                if (instance != null) {
                    System.err.println("Structure (Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            n = this.getWriteMode();
        }
        if (n == 2) {
            if (printWriter != null) {
                printWriter.close();
            }
            this.cancel();
        }
        if (n == 3) {
            this.setWriteMode(0);
            n = this.getWriteMode();
        }
        if (n == 0) {
            if (instances == null) {
                throw new IOException("No instances information available.");
            }
            if (instance != null) {
                if (this.retrieveFile() == null || printWriter == null) {
                    System.out.println(this.instanceToSvmlight(instance));
                } else {
                    printWriter.println(this.instanceToSvmlight(instance));
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        printWriter.flush();
                    }
                }
            } else {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                printWriter = null;
                this.resetWriter();
            }
        }
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            for (int i = 0; i < this.getInstances().numInstances(); ++i) {
                System.out.println(this.instanceToSvmlight(this.getInstances().instance(i)));
            }
            this.setWriteMode(1);
        } else {
            PrintWriter printWriter = new PrintWriter(this.getWriter());
            for (int i = 0; i < this.getInstances().numInstances(); ++i) {
                printWriter.println(this.instanceToSvmlight(this.getInstances().instance(i)));
            }
            printWriter.flush();
            printWriter.close();
            this.setWriteMode(1);
            printWriter = null;
            this.resetWriter();
            this.setWriteMode(2);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4854 $");
    }

    public static void main(String[] stringArray) {
        SVMLightSaver.runFileSaver(new SVMLightSaver(), stringArray);
    }
}

