/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XStream;
import weka.gui.Logger;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.Visible;

public class SerializedModelSaver
extends JPanel
implements BeanCommon,
Visible,
BatchClassifierListener,
IncrementalClassifierListener,
BatchClustererListener,
EnvironmentHandler,
Serializable {
    private static final long serialVersionUID = 3956528599473814287L;
    protected BeanVisual m_visual = new BeanVisual("AbstractDataSink", "weka/gui/beans/icons/SerializedModelSaver.gif", "weka/gui/beans/icons/SerializedModelSaver_animated.gif");
    protected Object m_listenee = null;
    protected transient Logger m_logger = null;
    private String m_filenamePrefix = "";
    private File m_directory = new File(System.getProperty("user.dir"));
    private Tag m_fileFormat;
    public static final int BINARY = 0;
    public static final int KOMLV = 1;
    public static final int XSTREAM = 2;
    public static final String FILE_EXTENSION = "model";
    private boolean m_useRelativePath = false;
    public static ArrayList<Tag> s_fileFormatsAvailable = new ArrayList();
    protected transient Environment m_env;

    public SerializedModelSaver() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_fileFormat = s_fileFormatsAvailable.get(0);
        this.m_env = Environment.getSystemWide();
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/SerializedModelSaver.gif", "weka/gui/beans/icons/SerializedModelSaver_animated.gif");
        this.m_visual.setText("SerializedModelSaver");
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public boolean connectionAllowed(EventSetDescriptor eventSetDescriptor) {
        return this.connectionAllowed(eventSetDescriptor.getName());
    }

    public boolean connectionAllowed(String string) {
        return this.m_listenee == null;
    }

    public synchronized void connectionNotification(String string, Object object) {
        if (this.connectionAllowed(string)) {
            this.m_listenee = object;
        }
    }

    public synchronized void disconnectionNotification(String string, Object object) {
        if (this.m_listenee == object) {
            this.m_listenee = null;
        }
    }

    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    public boolean isBusy() {
        return false;
    }

    protected String sanitizeFilename(String string) {
        return string.replaceAll("\\\\", "_").replaceAll(":", "_").replaceAll("/", "_");
    }

    public void acceptClusterer(BatchClustererEvent batchClustererEvent) {
        if (batchClustererEvent.getTestSet() == null || batchClustererEvent.getTestOrTrain() == BatchClustererEvent.TEST || batchClustererEvent.getTestSet().isStructureOnly()) {
            return;
        }
        Instances instances = new Instances(batchClustererEvent.getTestSet().getDataSet(), 0);
        String string = batchClustererEvent.getClusterer().getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        String string2 = "";
        try {
            string2 = this.m_env.substitute(this.m_filenamePrefix);
        }
        catch (Exception exception) {
            this.stop();
            String string3 = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + exception.getMessage();
            if (this.m_logger != null) {
                this.m_logger.logMessage(string3);
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
            } else {
                System.err.println(string3);
            }
            return;
        }
        String string4 = "" + string2 + string + "_" + batchClustererEvent.getSetNumber() + "_" + batchClustererEvent.getMaxSetNumber();
        string4 = this.sanitizeFilename(string4);
        String string5 = this.m_directory.getPath();
        try {
            string5 = this.m_env.substitute(string5);
        }
        catch (Exception exception) {
            this.stop();
            String string6 = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + exception.getMessage();
            if (this.m_logger != null) {
                this.m_logger.logMessage(string6);
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
            } else {
                System.err.println(string6);
            }
            return;
        }
        File file = new File(string5);
        string4 = file.getAbsolutePath() + File.separator + string4;
        this.saveModel(string4, instances, batchClustererEvent.getClusterer());
    }

    public void acceptClassifier(IncrementalClassifierEvent incrementalClassifierEvent) {
        if (incrementalClassifierEvent.getStatus() == 2) {
            Instances instances = incrementalClassifierEvent.getStructure();
            String string = incrementalClassifierEvent.getClassifier().getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1, string.length());
            String string2 = "";
            try {
                string2 = this.m_env.substitute(this.m_filenamePrefix);
            }
            catch (Exception exception) {
                this.stop();
                String string3 = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + exception.getMessage();
                if (this.m_logger != null) {
                    this.m_logger.logMessage(string3);
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
                } else {
                    System.err.println(string3);
                }
                return;
            }
            String string4 = "" + string2 + string;
            string4 = this.sanitizeFilename(string4);
            String string5 = this.m_directory.getPath();
            try {
                string5 = this.m_env.substitute(string5);
            }
            catch (Exception exception) {
                this.stop();
                String string6 = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + exception.getMessage();
                if (this.m_logger != null) {
                    this.m_logger.logMessage(string6);
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
                } else {
                    System.err.println(string6);
                }
                return;
            }
            File file = new File(string5);
            string4 = file.getAbsolutePath() + File.separator + string4;
            this.saveModel(string4, instances, incrementalClassifierEvent.getClassifier());
        }
    }

    public void acceptClassifier(BatchClassifierEvent batchClassifierEvent) {
        if (batchClassifierEvent.getTrainSet() == null || batchClassifierEvent.getTrainSet().isStructureOnly()) {
            return;
        }
        Instances instances = new Instances(batchClassifierEvent.getTrainSet().getDataSet(), 0);
        String string = batchClassifierEvent.getClassifier().getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length());
        String string2 = "";
        try {
            string2 = this.m_env.substitute(this.m_filenamePrefix);
        }
        catch (Exception exception) {
            this.stop();
            String string3 = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + exception.getMessage();
            if (this.m_logger != null) {
                this.m_logger.logMessage(string3);
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
            } else {
                System.err.println(string3);
            }
            return;
        }
        String string4 = "" + string2 + string + "_" + batchClassifierEvent.getSetNumber() + "_" + batchClassifierEvent.getMaxSetNumber();
        string4 = this.sanitizeFilename(string4);
        String string5 = this.m_directory.getPath();
        try {
            string5 = this.m_env.substitute(string5);
        }
        catch (Exception exception) {
            this.stop();
            String string6 = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + exception.getMessage();
            if (this.m_logger != null) {
                this.m_logger.logMessage(string6);
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
            } else {
                System.err.println(string6);
            }
            return;
        }
        File file = new File(string5);
        string4 = file.getAbsolutePath() + File.separator + string4;
        this.saveModel(string4, instances, batchClassifierEvent.getClassifier());
    }

    private void saveModel(String string, Instances instances, Object object) {
        block7: {
            this.m_fileFormat = this.validateFileFormat(this.m_fileFormat);
            if (this.m_fileFormat == null) {
                this.m_fileFormat = s_fileFormatsAvailable.get(0);
            }
            try {
                switch (this.m_fileFormat.getID()) {
                    case 1: {
                        string = string + ".koml" + FILE_EXTENSION;
                        SerializedModelSaver.saveKOML(new File(string), object, instances);
                        break;
                    }
                    case 2: {
                        string = string + ".xstream" + FILE_EXTENSION;
                        SerializedModelSaver.saveXStream(new File(string), object, instances);
                        break;
                    }
                    default: {
                        string = string + "." + FILE_EXTENSION;
                        SerializedModelSaver.saveBinary(new File(string), object, instances);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                this.stop();
                System.err.println("[SerializedModelSaver] Problem saving model");
                if (this.m_logger == null) break block7;
                this.m_logger.logMessage("[SerializedModelSaver] " + this.statusMessagePrefix() + " Problem saving model");
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
            }
        }
    }

    public static void saveBinary(File file, Object object, Instances instances) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        objectOutputStream.writeObject(object);
        if (instances != null) {
            objectOutputStream.writeObject(instances);
        }
        objectOutputStream.close();
    }

    public static void saveKOML(File file, Object object, Instances instances) throws Exception {
        Vector<Object> vector = new Vector<Object>();
        vector.add(object);
        if (instances != null) {
            vector.add(instances);
        }
        vector.trimToSize();
        KOML.write(file.getAbsolutePath(), vector);
    }

    public static void saveXStream(File file, Object object, Instances instances) throws Exception {
        Vector<Object> vector = new Vector<Object>();
        vector.add(object);
        if (instances != null) {
            vector.add(instances);
        }
        vector.trimToSize();
        XStream.write(file.getAbsolutePath(), vector);
    }

    public File getDirectory() {
        return this.m_directory;
    }

    public void setDirectory(File file) {
        this.m_directory = file;
        if (this.m_useRelativePath) {
            try {
                this.m_directory = Utils.convertToRelativePath(this.m_directory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setUseRelativePath(boolean bl) {
        this.m_useRelativePath = bl;
    }

    public boolean getUseRelativePath() {
        return this.m_useRelativePath;
    }

    public String getPrefix() {
        return this.m_filenamePrefix;
    }

    public void setPrefix(String string) {
        this.m_filenamePrefix = string;
    }

    public String globalInfo() {
        return "Save trained models to serialized object files.";
    }

    public void setFileFormat(Tag tag) {
        this.m_fileFormat = tag;
    }

    public Tag getFileFormat() {
        return this.m_fileFormat;
    }

    public Tag validateFileFormat(Tag tag) {
        Tag tag2 = tag;
        if (tag.getID() == 0) {
            return tag;
        }
        if (tag.getID() == 1 && !KOML.isPresent()) {
            tag2 = null;
        }
        if (tag.getID() == 2 && !XStream.isPresent()) {
            tag2 = null;
        }
        return tag2;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }

    public void setEnvironment(Environment environment) {
        this.m_env = environment;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_env = Environment.getSystemWide();
    }

    static {
        s_fileFormatsAvailable.add(new Tag(0, "Binary serialized model file (*model)", "", false));
        if (KOML.isPresent()) {
            s_fileFormatsAvailable.add(new Tag(1, "XML serialized model file (*.komlmodel)", "", false));
        }
        if (XStream.isPresent()) {
            s_fileFormatsAvailable.add(new Tag(2, "XML serialized model file (*.xstreammodel)", "", false));
        }
    }
}

