/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.Capabilities;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.Estimator;
import weka.estimators.IncrementalEstimator;

public class NormalEstimator
extends Estimator
implements IncrementalEstimator {
    private static final long serialVersionUID = 93584379632315841L;
    private double m_SumOfWeights;
    private double m_SumOfValues;
    private double m_SumOfValuesSq;
    private double m_Mean;
    private double m_StandardDev;
    private double m_Precision;

    private double round(double d) {
        return Math.rint(d / this.m_Precision) * this.m_Precision;
    }

    public NormalEstimator(double d) {
        this.m_Precision = d;
        this.m_StandardDev = this.m_Precision / 6.0;
    }

    public void addValue(double d, double d2) {
        if (d2 == 0.0) {
            return;
        }
        d = this.round(d);
        this.m_SumOfWeights += d2;
        this.m_SumOfValues += d * d2;
        this.m_SumOfValuesSq += d * d * d2;
        if (this.m_SumOfWeights > 0.0) {
            this.m_Mean = this.m_SumOfValues / this.m_SumOfWeights;
            double d3 = Math.sqrt(Math.abs(this.m_SumOfValuesSq - this.m_Mean * this.m_SumOfValues) / this.m_SumOfWeights);
            if (d3 > 1.0E-10) {
                this.m_StandardDev = Math.max(this.m_Precision / 6.0, d3);
            }
        }
    }

    public double getProbability(double d) {
        d = this.round(d);
        double d2 = (d - this.m_Mean - this.m_Precision / 2.0) / this.m_StandardDev;
        double d3 = (d - this.m_Mean + this.m_Precision / 2.0) / this.m_StandardDev;
        double d4 = Statistics.normalProbability(d2);
        double d5 = Statistics.normalProbability(d3);
        return d5 - d4;
    }

    public String toString() {
        return "Normal Distribution. Mean = " + Utils.doubleToString(this.m_Mean, 4) + " StandardDev = " + Utils.doubleToString(this.m_StandardDev, 4) + " WeightSum = " + Utils.doubleToString(this.m_SumOfWeights, 4) + " Precision = " + this.m_Precision + "\n";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        if (!this.m_noClass) {
            capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
            capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        } else {
            capabilities.enable(Capabilities.Capability.NO_CLASS);
        }
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return capabilities;
    }

    public double getMean() {
        return this.m_Mean;
    }

    public double getStdDev() {
        return this.m_StandardDev;
    }

    public double getPrecision() {
        return this.m_Precision;
    }

    public double getSumOfWeights() {
        return this.m_SumOfWeights;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5540 $");
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            NormalEstimator normalEstimator = new NormalEstimator(0.01);
            for (int i = 0; i < stringArray.length; ++i) {
                double d = Double.valueOf(stringArray[i]);
                System.out.println(normalEstimator);
                System.out.println("Prediction for " + d + " = " + normalEstimator.getProbability(d));
                normalEstimator.addValue(d, 1.0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

