/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.URLSourcedLoader;

public class SVMLightLoader
extends AbstractFileLoader
implements BatchConverter,
URLSourcedLoader {
    private static final long serialVersionUID = 4988360125354664417L;
    public static String FILE_EXTENSION = ".dat";
    protected String m_URL = "http://";
    protected transient Reader m_sourceReader = null;
    protected Vector m_Buffer = null;

    public String globalInfo() {
        return "Reads a source that is in svm light format.\n\nFor more information about svm light see:\n\nhttp://svmlight.joachims.org/";
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    public String getFileDescription() {
        return "svm light data files";
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.m_Buffer = null;
        this.setRetrieval(0);
        if (this.m_File != null && new File(this.m_File).isFile()) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null && !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSource(URL uRL) throws IOException {
        this.m_structure = null;
        this.m_Buffer = null;
        this.setRetrieval(0);
        this.setSource(uRL.openStream());
        this.m_URL = uRL.toString();
    }

    public void setURL(String string) throws IOException {
        this.m_URL = string;
        this.setSource(new URL(string));
    }

    public String retrieveURL() {
        return this.m_URL;
    }

    public void setSource(InputStream inputStream) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    protected double[] svmlightToArray(String string) throws Exception {
        double[] dArray;
        try {
            int n;
            String string2;
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken()).startsWith("#")) {
                if (string2.startsWith("qid:") || (n = Integer.parseInt(string2.substring(0, string2.indexOf(":")))) <= n2) continue;
                n2 = n;
            }
            stringTokenizer = new StringTokenizer(string, " \t");
            dArray = new double[n2 + 1];
            dArray[dArray.length - 1] = Double.parseDouble(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken()).startsWith("#")) {
                double d;
                if (string2.startsWith("qid:")) continue;
                n = Integer.parseInt(string2.substring(0, string2.indexOf(":")));
                dArray[n - 1] = d = Double.parseDouble(string2.substring(string2.indexOf(":") + 1));
            }
        }
        catch (Exception exception) {
            System.err.println("Error parsing line '" + string + "': " + exception);
            throw new Exception(exception);
        }
        return dArray;
    }

    protected int determineNumAttributes(double[] dArray, int n) throws Exception {
        int n2 = dArray.length;
        int n3 = n;
        if (n2 > n3) {
            n3 = n2;
        }
        return n3;
    }

    protected Attribute determineClassAttribute() {
        Attribute attribute;
        boolean bl = true;
        for (int i = 0; i < this.m_Buffer.size(); ++i) {
            double[] dArray = (double[])this.m_Buffer.get(i);
            double d = dArray[dArray.length - 1];
            if (d == -1.0 || d == 1.0) continue;
            bl = false;
            break;
        }
        if (bl) {
            FastVector fastVector = new FastVector();
            fastVector.addElement("+1");
            fastVector.addElement("-1");
            attribute = new Attribute("class", fastVector);
        } else {
            attribute = new Attribute("class");
        }
        return attribute;
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            this.m_Buffer = new Vector();
            try {
                int n;
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = this.m_sourceReader.read()) != -1) {
                    char c = (char)n;
                    if (c == '\n' || c == '\r') {
                        if (stringBuffer.length() > 0 && stringBuffer.charAt(0) != '#') {
                            try {
                                this.m_Buffer.add(this.svmlightToArray(stringBuffer.toString()));
                                n2 = this.determineNumAttributes((double[])this.m_Buffer.lastElement(), n2);
                            }
                            catch (Exception exception) {
                                throw new Exception("Error parsing line '" + stringBuffer + "': " + exception);
                            }
                        }
                        stringBuffer = new StringBuffer();
                        continue;
                    }
                    stringBuffer.append(c);
                }
                if (stringBuffer.length() != 0 && stringBuffer.charAt(0) != '#') {
                    this.m_Buffer.add(this.svmlightToArray(stringBuffer.toString()));
                    n2 = this.determineNumAttributes((double[])this.m_Buffer.lastElement(), n2);
                }
                FastVector fastVector = new FastVector(n2);
                for (int i = 0; i < n2 - 1; ++i) {
                    fastVector.addElement(new Attribute("att_" + (i + 1)));
                }
                fastVector.addElement(this.determineClassAttribute());
                String string = !this.m_URL.equals("http://") ? this.m_URL : this.m_File;
                this.m_structure = new Instances(string, fastVector, 0);
                this.m_structure.setClassIndex(this.m_structure.numAttributes() - 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException("Unable to determine structure as svm light: " + exception);
            }
        }
        return new Instances(this.m_structure, 0);
    }

    public Instances getDataSet() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        Instances instances = new Instances(this.m_structure, 0);
        for (int i = 0; i < this.m_Buffer.size(); ++i) {
            double[] dArray;
            double[] dArray2 = (double[])this.m_Buffer.get(i);
            if (dArray2.length != this.m_structure.numAttributes()) {
                dArray = new double[this.m_structure.numAttributes()];
                System.arraycopy(dArray2, 0, dArray, 0, dArray2.length - 1);
                dArray[dArray.length - 1] = dArray2[dArray2.length - 1];
            } else {
                dArray = dArray2;
            }
            if (instances.classAttribute().isNominal()) {
                if (dArray[dArray.length - 1] == 1.0) {
                    dArray[dArray.length - 1] = instances.classAttribute().indexOfValue("+1");
                } else if (dArray[dArray.length - 1] == -1.0) {
                    dArray[dArray.length - 1] = instances.classAttribute().indexOfValue("-1");
                } else {
                    throw new IllegalStateException("Class is not binary!");
                }
            }
            instances.add(new SparseInstance(1.0, dArray));
        }
        try {
            this.m_sourceReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return instances;
    }

    public Instance getNextInstance(Instances instances) throws IOException {
        throw new IOException("SVMLightLoader can't read data sets incrementally.");
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4854 $");
    }

    public static void main(String[] stringArray) {
        SVMLightLoader.runFileLoader(new SVMLightLoader(), stringArray);
    }
}

