/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.converters.AbstractLoader;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;

public abstract class AbstractFileLoader
extends AbstractLoader
implements FileSourcedConverter {
    protected String m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
    protected Instances m_structure = null;
    protected File m_sourceFile = null;
    public static String FILE_EXTENSION_COMPRESSED = ".gz";
    protected boolean m_useRelativePath = false;

    public File retrieveFile() {
        return new File(this.m_File);
    }

    public void setFile(File file) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        this.setSource(file);
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
    }

    public void setSource(File file) throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        try {
            String string = file.getPath();
            try {
                string = Environment.substitute(string);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            file = new File(string);
            if (file.getName().endsWith(this.getFileExtension() + FILE_EXTENSION_COMPRESSED)) {
                this.setSource(new GZIPInputStream(new FileInputStream(file)));
            } else {
                this.setSource(new FileInputStream(file));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File not found");
        }
        if (this.m_useRelativePath) {
            try {
                this.m_sourceFile = Utils.convertToRelativePath(file);
                this.m_File = this.m_sourceFile.getPath();
            }
            catch (Exception exception) {
                this.m_sourceFile = file;
                this.m_File = file.getPath();
            }
        } else {
            this.m_sourceFile = file;
            this.m_File = file.getAbsolutePath();
        }
    }

    public String useRelativePathTipText() {
        return "Use relative rather than absolute paths";
    }

    public void setUseRelativePath(boolean bl) {
        this.m_useRelativePath = bl;
    }

    public boolean getUseRelativePath() {
        return this.m_useRelativePath;
    }

    protected static String makeOptionStr(AbstractFileLoader abstractFileLoader) {
        String string = "\nUsage:\n";
        string = string + "\t" + abstractFileLoader.getClass().getName().replaceAll(".*\\.", "");
        string = string + " <";
        String[] stringArray = abstractFileLoader.getFileExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + " | ";
            }
            string = string + "file" + stringArray[i];
        }
        string = string + ">\n";
        return string;
    }

    public static void runFileLoader(AbstractFileLoader abstractFileLoader, String[] stringArray) {
        block9: {
            Object object;
            try {
                object = (String[])stringArray.clone();
                if (Utils.getFlag('h', object)) {
                    System.err.println("\nHelp requested\n" + AbstractFileLoader.makeOptionStr(abstractFileLoader));
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringArray.length > 0) {
                try {
                    abstractFileLoader.setFile(new File(stringArray[0]));
                    if (abstractFileLoader instanceof IncrementalConverter) {
                        Instance instance;
                        object = abstractFileLoader.getStructure();
                        System.out.println(object);
                        do {
                            if ((instance = abstractFileLoader.getNextInstance((Instances)object)) == null) continue;
                            System.out.println(instance);
                        } while (instance != null);
                        break block9;
                    }
                    System.out.println(abstractFileLoader.getDataSet());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                System.err.println(AbstractFileLoader.makeOptionStr(abstractFileLoader));
            }
        }
    }
}

