/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Vector;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeLocator
implements Serializable,
Comparable<AttributeLocator>,
RevisionHandler {
    private static final long serialVersionUID = -2932848827681070345L;
    protected int[] m_AllowedIndices = null;
    protected Vector m_Attributes = null;
    protected Vector m_Locators = null;
    protected int m_Type = -1;
    protected Instances m_Data = null;
    protected int[] m_Indices = null;
    protected int[] m_LocatorIndices = null;

    public AttributeLocator(Instances instances, int n) {
        this(instances, n, 0, instances.numAttributes() - 1);
    }

    public AttributeLocator(Instances instances, int n, int n2, int n3) {
        int[] nArray = new int[n3 - n2 + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n2 + i;
        }
        this.initialize(instances, n, nArray);
    }

    public AttributeLocator(Instances instances, int n, int[] nArray) {
        this.initialize(instances, n, nArray);
    }

    protected void initialize(Instances instances, int n, int[] nArray) {
        this.m_Data = new Instances(instances, 0);
        this.m_Type = n;
        this.m_AllowedIndices = new int[nArray.length];
        System.arraycopy(nArray, 0, this.m_AllowedIndices, 0, nArray.length);
        this.locate();
        this.m_Indices = this.find(true);
        this.m_LocatorIndices = this.find(false);
    }

    public int getType() {
        return this.m_Type;
    }

    public int[] getAllowedIndices() {
        return this.m_AllowedIndices;
    }

    protected void locate() {
        this.m_Attributes = new Vector();
        this.m_Locators = new Vector();
        for (int i = 0; i < this.m_AllowedIndices.length; ++i) {
            if (this.m_Data.attribute(this.m_AllowedIndices[i]).type() == 4) {
                this.m_Locators.add(new AttributeLocator(this.m_Data.attribute(this.m_AllowedIndices[i]).relation(), this.getType()));
            } else {
                this.m_Locators.add(null);
            }
            if (this.m_Data.attribute(this.m_AllowedIndices[i]).type() == this.getType()) {
                this.m_Attributes.add(new Boolean(true));
                continue;
            }
            this.m_Attributes.add(new Boolean(false));
        }
    }

    public Instances getData() {
        return this.m_Data;
    }

    protected int[] find(boolean bl) {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        if (bl) {
            for (n = 0; n < this.m_Attributes.size(); ++n) {
                if (!((Boolean)this.m_Attributes.get(n)).booleanValue()) continue;
                vector.add(new Integer(n));
            }
        } else {
            for (n = 0; n < this.m_Locators.size(); ++n) {
                if (this.m_Locators.get(n) == null) continue;
                vector.add(new Integer(n));
            }
        }
        int[] nArray = new int[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            nArray[n] = (Integer)vector.get(n);
        }
        return nArray;
    }

    public int getActualIndex(int n) {
        return this.m_AllowedIndices[n];
    }

    public int[] getAttributeIndices() {
        return this.m_Indices;
    }

    public int[] getLocatorIndices() {
        return this.m_LocatorIndices;
    }

    public AttributeLocator getLocator(int n) {
        return (AttributeLocator)this.m_Locators.get(n);
    }

    @Override
    public int compareTo(AttributeLocator attributeLocator) {
        int n = 0;
        if (this.getType() < attributeLocator.getType()) {
            n = -1;
        } else if (this.getType() > attributeLocator.getType()) {
            n = 1;
        } else if (this.getAllowedIndices().length < attributeLocator.getAllowedIndices().length) {
            n = -1;
        } else if (this.getAllowedIndices().length > attributeLocator.getAllowedIndices().length) {
            n = 1;
        } else {
            for (int i = 0; i < this.getAllowedIndices().length; ++i) {
                if (this.getAllowedIndices()[i] < attributeLocator.getAllowedIndices()[i]) {
                    n = -1;
                    break;
                }
                if (this.getAllowedIndices()[i] > attributeLocator.getAllowedIndices()[i]) {
                    n = 1;
                    break;
                }
                n = 0;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo((AttributeLocator)object) == 0;
    }

    public String toString() {
        return this.m_Attributes.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

