/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class CheckBoxList
extends JList {
    private static final long serialVersionUID = -4359573373359270258L;

    public CheckBoxList() {
        this((CheckBoxListModel)null);
    }

    public CheckBoxList(CheckBoxListModel checkBoxListModel) {
        if (checkBoxListModel == null) {
            checkBoxListModel = new CheckBoxListModel();
        }
        this.setModel((ListModel)checkBoxListModel);
        this.setCellRenderer(new CheckBoxListRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = CheckBoxList.this.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    CheckBoxList.this.setChecked(n, !CheckBoxList.this.getChecked(n));
                    CheckBoxList.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == ' ' && keyEvent.getModifiers() == 0) {
                    int n;
                    CheckBoxList.this.setChecked(n, !CheckBoxList.this.getChecked(n = CheckBoxList.this.getSelectedIndex()));
                    keyEvent.consume();
                    CheckBoxList.this.repaint();
                }
            }
        });
    }

    public void setModel(ListModel listModel) {
        if (!(listModel instanceof CheckBoxListModel)) {
            throw new IllegalArgumentException("Model must be an instance of CheckBoxListModel!");
        }
        super.setModel(listModel);
    }

    public void setListData(Object[] objectArray) {
        this.setModel((ListModel)new CheckBoxListModel(objectArray));
    }

    public void setListData(Vector vector) {
        this.setModel((ListModel)new CheckBoxListModel(vector));
    }

    public boolean getChecked(int n) {
        return ((CheckBoxListModel)this.getModel()).getChecked(n);
    }

    public void setChecked(int n, boolean bl) {
        ((CheckBoxListModel)this.getModel()).setChecked(n, bl);
    }

    public int[] getCheckedIndices() {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < this.getModel().getSize(); ++n) {
            if (!this.getChecked(n)) continue;
            vector.add(new Integer(n));
        }
        int[] nArray = new int[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            nArray[n] = (Integer)vector.get(n);
        }
        return nArray;
    }

    public class CheckBoxListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = 1059591605858524586L;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            this.setSelected(((CheckBoxList)jList).getChecked(n));
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            this.setFocusPainted(false);
            return this;
        }
    }

    public class CheckBoxListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 7772455499540273507L;

        public CheckBoxListModel() {
        }

        public CheckBoxListModel(Object[] objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.addElement(objectArray[i]);
            }
        }

        public CheckBoxListModel(Vector vector) {
            for (int i = 0; i < vector.size(); ++i) {
                this.addElement(vector.get(i));
            }
        }

        public void add(int n, Object object) {
            if (!(object instanceof CheckBoxListItem)) {
                super.add(n, new CheckBoxListItem(object));
            } else {
                super.add(n, object);
            }
        }

        public void addElement(Object object) {
            if (!(object instanceof CheckBoxListItem)) {
                super.addElement(new CheckBoxListItem(object));
            } else {
                super.addElement(object);
            }
        }

        public boolean contains(Object object) {
            if (!(object instanceof CheckBoxListItem)) {
                return super.contains(new CheckBoxListItem(object));
            }
            return super.contains(object);
        }

        public void copyInto(Object[] objectArray) {
            if (objectArray.length < this.getSize()) {
                throw new IndexOutOfBoundsException("Array not big enough!");
            }
            for (int i = 0; i < this.getSize(); ++i) {
                objectArray[i] = ((CheckBoxListItem)this.getElementAt(i)).getContent();
            }
        }

        public Object elementAt(int n) {
            return ((CheckBoxListItem)super.elementAt(n)).getContent();
        }

        public Object firstElement() {
            return ((CheckBoxListItem)super.firstElement()).getContent();
        }

        public Object get(int n) {
            return ((CheckBoxListItem)super.get(n)).getContent();
        }

        public Object getElementAt(int n) {
            return ((CheckBoxListItem)super.getElementAt(n)).getContent();
        }

        public int indexOf(Object object) {
            if (!(object instanceof CheckBoxListItem)) {
                return super.indexOf(new CheckBoxListItem(object));
            }
            return super.indexOf(object);
        }

        public int indexOf(Object object, int n) {
            if (!(object instanceof CheckBoxListItem)) {
                return super.indexOf(new CheckBoxListItem(object), n);
            }
            return super.indexOf(object, n);
        }

        public void insertElementAt(Object object, int n) {
            if (!(object instanceof CheckBoxListItem)) {
                super.insertElementAt(new CheckBoxListItem(object), n);
            } else {
                super.insertElementAt(object, n);
            }
        }

        public Object lastElement() {
            return ((CheckBoxListItem)super.lastElement()).getContent();
        }

        public int lastIndexOf(Object object) {
            if (!(object instanceof CheckBoxListItem)) {
                return super.lastIndexOf(new CheckBoxListItem(object));
            }
            return super.lastIndexOf(object);
        }

        public int lastIndexOf(Object object, int n) {
            if (!(object instanceof CheckBoxListItem)) {
                return super.lastIndexOf(new CheckBoxListItem(object), n);
            }
            return super.lastIndexOf(object, n);
        }

        public Object remove(int n) {
            return ((CheckBoxListItem)super.remove(n)).getContent();
        }

        public boolean removeElement(Object object) {
            if (!(object instanceof CheckBoxListItem)) {
                return super.removeElement(new CheckBoxListItem(object));
            }
            return super.removeElement(object);
        }

        public Object set(int n, Object object) {
            if (!(object instanceof CheckBoxListItem)) {
                return super.set(n, new CheckBoxListItem(object)).getContent();
            }
            return ((CheckBoxListItem)super.set(n, object)).getContent();
        }

        public void setElementAt(Object object, int n) {
            if (!(object instanceof CheckBoxListItem)) {
                super.setElementAt(new CheckBoxListItem(object), n);
            } else {
                super.setElementAt(object, n);
            }
        }

        public Object[] toArray() {
            Object[] objectArray = super.toArray();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = ((CheckBoxListItem)objectArray[i]).getContent();
            }
            return objectArray2;
        }

        public boolean getChecked(int n) {
            return ((CheckBoxListItem)super.getElementAt(n)).getChecked();
        }

        public void setChecked(int n, boolean bl) {
            ((CheckBoxListItem)super.getElementAt(n)).setChecked(bl);
        }
    }

    protected class CheckBoxListItem {
        private boolean m_Checked = false;
        private Object m_Content = null;

        public CheckBoxListItem(Object object) {
            this(object, false);
        }

        public CheckBoxListItem(Object object, boolean bl) {
            this.m_Checked = bl;
            this.m_Content = object;
        }

        public Object getContent() {
            return this.m_Content;
        }

        public void setChecked(boolean bl) {
            this.m_Checked = bl;
        }

        public boolean getChecked() {
            return this.m_Checked;
        }

        public String toString() {
            return this.m_Content.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CheckBoxListItem)) {
                throw new IllegalArgumentException("Must be a CheckBoxListItem!");
            }
            return this.getContent().equals(((CheckBoxListItem)object).getContent());
        }
    }
}

