/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Random;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public final class RandomVariates
extends Random
implements RevisionHandler {
    private static final long serialVersionUID = -4763742718209460354L;

    public RandomVariates() {
    }

    public RandomVariates(long l) {
        super(l);
    }

    protected int next(int n) {
        return super.next(n);
    }

    public double nextExponential() {
        return -Math.log(1.0 - super.nextDouble());
    }

    public double nextErlang(int n) throws Exception {
        if (n < 1) {
            throw new Exception("Shape parameter of Erlang distribution must be greater than 1!");
        }
        double d = 1.0;
        for (int i = 1; i <= n; ++i) {
            d *= super.nextDouble();
        }
        return -Math.log(d);
    }

    public double nextGamma(double d) throws Exception {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (d <= 0.0) {
            throw new Exception("Shape parameter of Gamma distributionmust be greater than 0!");
        }
        if (d == 1.0) {
            return this.nextExponential();
        }
        if (d < 1.0) {
            double d7;
            double d8;
            double d9 = 1.0 + Math.exp(-1.0) * d;
            do {
                double d10;
                if ((d10 = d9 * super.nextDouble()) < 1.0) {
                    d8 = d7 = Math.exp(Math.log(d10) / d);
                    continue;
                }
                d7 = -Math.log((d9 - d10) / d);
                d8 = (1.0 - d) * Math.log(d7);
            } while (this.nextExponential() < d8);
            return d7;
        }
        double d11 = d - 1.0;
        double d12 = Math.sqrt(d11);
        if (d <= 2.0) {
            d6 = d11 / 2.0;
            d5 = 0.0;
            d4 = d6;
            d3 = -1.0;
            d2 = 0.0;
        } else {
            d6 = d12 - 0.5;
            d4 = d11 - d6;
            d5 = d4 - d6;
            d3 = 1.0 - d11 / d5;
            d2 = Math.exp(d11 * Math.log(d5 / d11) + 2.0 * d6);
        }
        double d13 = Math.exp(d11 * Math.log(d4 / d11) + d6);
        double d14 = d11 + d12;
        double d15 = d14 + d12;
        double d16 = 1.0 - d11 / d15;
        double d17 = Math.exp(d11 * Math.log(d14 / d11) - d12);
        double d18 = Math.exp(d11 * Math.log(d15 / d11) - 2.0 * d12);
        double d19 = 2.0 * d17 * d12;
        double d20 = 2.0 * d13 * d6 + d19;
        double d21 = d18 / d16 + d20;
        double d22 = -d2 / d3 + d21;
        double d23 = Double.MAX_VALUE;
        double d24 = d11;
        while (Math.log(d23) > d11 * Math.log(d24 / d11) + d11 - d24) {
            double d25;
            double d26;
            double d27 = super.nextDouble() * d22;
            if (d27 <= d19) {
                d23 = d27 / d12 - d17;
                if (d23 <= 0.0) {
                    return d11 + d27 / d17;
                }
                if (d23 <= d18) {
                    return d14 + d23 * d12 / d18;
                }
                d26 = super.nextDouble();
                d24 = d14 + d26 * d12;
                d25 = 2.0 * d14 - d24;
                if (d23 >= d17 + (d17 - 1.0) * (d24 - d14) / (d14 - d11)) {
                    return d25;
                }
                if (d23 <= d17 + (d11 / d14 - 1.0) * d17 * (d24 - d14)) {
                    return d24;
                }
                if (d23 < 2.0 * d17 - 1.0 || d23 < 2.0 * d17 - Math.exp(d11 * Math.log(d25 / d11) + d11 - d25)) continue;
                return d25;
            }
            if (d27 <= d20) {
                d23 = (d27 - d19) / d6 - d13;
                if (d23 <= 0.0) {
                    return d11 - (d27 - d19) / d13;
                }
                if (d23 <= d2) {
                    return d5 + d23 * d6 / d2;
                }
                d26 = super.nextDouble();
                d24 = d5 + d26 * d6;
                d25 = 2.0 * d4 - d24;
                if (d23 >= d13 + (d13 - 1.0) * (d24 - d4) / (d4 - d11)) {
                    return d25;
                }
                if (d23 <= d13 * (d24 - d5) / d6) {
                    return d24;
                }
                if (d23 < 2.0 * d13 - 1.0 || d23 < 2.0 * d13 - Math.exp(d11 * Math.log(d25 / d11) + d11 - d25)) continue;
                return d25;
            }
            if (d27 < d21) {
                d23 = super.nextDouble();
                if (d23 <= (d16 * (d15 - (d24 = d15 - Math.log(d27 = (d21 - d27) / (d21 - d20)) / d16)) + 1.0) / d27) {
                    return d24;
                }
                d23 = d23 * d18 * d27;
                continue;
            }
            d23 = super.nextDouble();
            d24 = d5 - Math.log(d27 = (d22 - d27) / (d22 - d21)) / d3;
            if (d24 < 0.0) continue;
            if (d23 <= (d3 * (d5 - d24) + 1.0) / d27) {
                return d24;
            }
            d23 = d23 * d2 * d27;
        }
        return d24;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    public static void main(String[] stringArray) {
        long l;
        int n = Integer.parseInt(stringArray[0]);
        if (n <= 0) {
            n = 10;
        }
        if ((l = Long.parseLong(stringArray[1])) <= 0L) {
            l = 45L;
        }
        RandomVariates randomVariates = new RandomVariates(l);
        double[] dArray = new double[n];
        try {
            int n2;
            System.out.println("Generate " + n + " values with std. exp dist:");
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = randomVariates.nextExponential();
                System.out.print("[" + n2 + "] " + dArray[n2] + ", ");
            }
            System.out.println("\nMean is " + Utils.mean(dArray) + ", Variance is " + Utils.variance(dArray) + "\n\nGenerate " + n + " values with" + " std. Erlang-5 dist:");
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = randomVariates.nextErlang(5);
                System.out.print("[" + n2 + "] " + dArray[n2] + ", ");
            }
            System.out.println("\nMean is " + Utils.mean(dArray) + ", Variance is " + Utils.variance(dArray) + "\n\nGenerate " + n + " values with" + " std. Gamma(4.5) dist:");
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = randomVariates.nextGamma(4.5);
                System.out.print("[" + n2 + "] " + dArray[n2] + ", ");
            }
            System.out.println("\nMean is " + Utils.mean(dArray) + ", Variance is " + Utils.variance(dArray) + "\n\nGenerate " + n + " values with" + " std. Gamma(0.5) dist:");
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = randomVariates.nextGamma(0.5);
                System.out.print("[" + n2 + "] " + dArray[n2] + ", ");
            }
            System.out.println("\nMean is " + Utils.mean(dArray) + ", Variance is " + Utils.variance(dArray) + "\n\nGenerate " + n + " values with" + " std. Gaussian(5, 2) dist:");
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = randomVariates.nextGaussian() * 2.0 + 5.0;
                System.out.print("[" + n2 + "] " + dArray[n2] + ", ");
            }
            System.out.println("\nMean is " + Utils.mean(dArray) + ", Variance is " + Utils.variance(dArray) + "\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

