/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Vector;
import weka.gui.beans.AbstractTestSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;

public class TestSetMaker
extends AbstractTestSetProducer
implements DataSourceListener,
EventConstraints,
Serializable {
    private static final long serialVersionUID = -8473882857628061841L;
    protected boolean m_receivedStopNotification = false;

    public TestSetMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/TestSetMaker.gif", "weka/gui/beans/icons/TestSetMaker_animated.gif");
        this.m_visual.setText("TestSetMaker");
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Designate an incoming data set as a test set.";
    }

    public void acceptDataSet(DataSetEvent dataSetEvent) {
        TestSetEvent testSetEvent = new TestSetEvent(this, dataSetEvent.getDataSet());
        testSetEvent.m_setNumber = 1;
        testSetEvent.m_maxSetNumber = 1;
        this.notifyTestSetProduced(testSetEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestSetProduced(TestSetEvent testSetEvent) {
        Vector vector;
        TestSetMaker testSetMaker = this;
        synchronized (testSetMaker) {
            vector = (Vector)this.m_listeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                if (this.m_receivedStopNotification) {
                    if (this.m_logger != null) {
                        this.m_logger.logMessage("[TestSetMaker] " + this.statusMessagePrefix() + " stopping.");
                        this.m_logger.statusMessage(this.statusMessagePrefix() + "INTERRUPTED");
                    }
                    this.m_receivedStopNotification = false;
                    break;
                }
                ((TestSetListener)vector.elementAt(i)).acceptTestSet(testSetEvent);
            }
        }
    }

    public void stop() {
        this.m_receivedStopNotification = true;
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    public boolean isBusy() {
        return false;
    }

    public boolean eventGeneratable(String string) {
        if (this.m_listenee == null) {
            return false;
        }
        return !(this.m_listenee instanceof EventConstraints) || ((EventConstraints)this.m_listenee).eventGeneratable("dataSet");
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

