/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.pmml.DefineFunction;
import weka.core.pmml.DerivedFieldMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransformationDictionary
implements Serializable {
    protected ArrayList<DefineFunction> m_defineFunctions = new ArrayList();
    protected ArrayList<DerivedFieldMetaInfo> m_derivedFields = new ArrayList();

    protected TransformationDictionary(Element element, Instances instances) throws Exception {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            arrayList.add(instances.attribute(i));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Serializable serializable;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string = ((Element)node).getTagName();
            if (string.equals("DerivedField")) {
                serializable = new DerivedFieldMetaInfo((Element)node, arrayList, null);
                this.m_derivedFields.add((DerivedFieldMetaInfo)serializable);
                continue;
            }
            if (!string.equals("DefineFunction")) continue;
            serializable = new DefineFunction((Element)node, null);
            this.m_defineFunctions.add((DefineFunction)serializable);
        }
    }

    protected void setFieldDefsForDerivedFields(ArrayList<Attribute> arrayList) throws Exception {
        for (int i = 0; i < this.m_derivedFields.size(); ++i) {
            this.m_derivedFields.get(i).setFieldDefs(arrayList);
        }
    }

    protected void setFieldDefsForDerivedFields(Instances instances) throws Exception {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            arrayList.add(instances.attribute(i));
        }
        this.setFieldDefsForDerivedFields(arrayList);
    }

    protected ArrayList<DerivedFieldMetaInfo> getDerivedFields() {
        return new ArrayList<DerivedFieldMetaInfo>(this.m_derivedFields);
    }

    protected DefineFunction getFunction(String string) throws Exception {
        DefineFunction defineFunction = null;
        DefineFunction defineFunction2 = null;
        for (DefineFunction defineFunction3 : this.m_defineFunctions) {
            if (!defineFunction3.getName().equals(string)) continue;
            defineFunction2 = defineFunction3;
            break;
        }
        if (defineFunction2 != null) {
            SerializedObject serializedObject = new SerializedObject(defineFunction2, false);
            defineFunction = (DefineFunction)serializedObject.getObject();
        }
        return defineFunction;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Transformation dictionary:\n");
        if (this.m_derivedFields.size() > 0) {
            stringBuffer.append("derived fields:\n");
            for (DerivedFieldMetaInfo serializable : this.m_derivedFields) {
                stringBuffer.append("" + serializable.getFieldAsAttribute() + "\n");
            }
        }
        if (this.m_defineFunctions.size() > 0) {
            stringBuffer.append("\nfunctions:\n");
            for (DefineFunction defineFunction : this.m_defineFunctions) {
                stringBuffer.append(defineFunction.toString("  ") + "\n");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

