/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.pmml.FieldMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetMetaInfo
extends FieldMetaInfo
implements Serializable {
    private static final long serialVersionUID = 863500462237904927L;
    protected double m_min = Double.NaN;
    protected double m_max = Double.NaN;
    protected double m_rescaleConstant = 0.0;
    protected double m_rescaleFactor = 1.0;
    protected String m_castInteger = "";
    protected double[] m_defaultValueOrPriorProbs;
    protected ArrayList<String> m_values = new ArrayList();
    protected ArrayList<String> m_displayValues = new ArrayList();

    protected TargetMetaInfo(Element element) throws Exception {
        super(element);
        NodeList nodeList;
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = element.getAttribute("min");
        if (string5 != null && string5.length() > 0) {
            try {
                this.m_min = Double.parseDouble(string5);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("[TargetMetaInfo] can't parse min value for target field " + this.m_fieldName);
            }
        }
        if ((string4 = element.getAttribute("max")) != null && string4.length() > 0) {
            try {
                this.m_max = Double.parseDouble(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("[TargetMetaInfo] can't parse max value for target field " + this.m_fieldName);
            }
        }
        if ((string3 = element.getAttribute("rescaleConstant")) != null && string3.length() > 0) {
            try {
                this.m_rescaleConstant = Double.parseDouble(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("[TargetMetaInfo] can't parse rescale constant value for target field " + this.m_fieldName);
            }
        }
        if ((string2 = element.getAttribute("rescaleFactor")) != null && string2.length() > 0) {
            try {
                this.m_rescaleFactor = Double.parseDouble(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception("[TargetMetaInfo] can't parse rescale factor value for target field " + this.m_fieldName);
            }
        }
        if ((string = element.getAttribute("castInteger")) != null && string.length() > 0) {
            this.m_castInteger = string;
        }
        if ((nodeList = element.getElementsByTagName("TargetValue")).getLength() > 0) {
            this.m_defaultValueOrPriorProbs = new double[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string6;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                String string7 = element2.getAttribute("value");
                if (string7 != null && string7.length() > 0) {
                    if (this.m_optype != FieldMetaInfo.Optype.CATEGORICAL && this.m_optype != FieldMetaInfo.Optype.NONE) {
                        throw new Exception("[TargetMetaInfo] TargetValue element has categorical value but optype is not categorical!");
                    }
                    if (this.m_optype == FieldMetaInfo.Optype.NONE) {
                        this.m_optype = FieldMetaInfo.Optype.CATEGORICAL;
                    }
                    this.m_values.add(string7);
                    string6 = element2.getAttribute("displayValue");
                    if (string6 != null && string6.length() > 0) {
                        this.m_displayValues.add(string6);
                    } else {
                        this.m_displayValues.add(string7);
                    }
                    String string8 = element2.getAttribute("priorProbability");
                    if (string8 != null && string8.length() > 0) {
                        try {
                            this.m_defaultValueOrPriorProbs[i] = Double.parseDouble(string8);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new Exception("[TargetMetaInfo] Can't parse probability from TargetValue element.");
                        }
                    }
                    throw new Exception("[TargetMetaInfo] No prior probability defined for value " + string7);
                }
                if (this.m_optype != FieldMetaInfo.Optype.CONTINUOUS && this.m_optype != FieldMetaInfo.Optype.NONE) {
                    throw new Exception("[TargetMetaInfo] TargetValue element has continuous value but optype is not continuous!");
                }
                if (this.m_optype == FieldMetaInfo.Optype.NONE) {
                    this.m_optype = FieldMetaInfo.Optype.CONTINUOUS;
                }
                if ((string6 = element2.getAttribute("defaultValue")) != null && string6.length() > 0) {
                    try {
                        this.m_defaultValueOrPriorProbs[i] = Double.parseDouble(string6);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new Exception("[TargetMetaInfo] Can't parse default value from TargetValue element.");
                    }
                }
                throw new Exception("[TargetMetaInfo] No default value defined for target " + this.m_fieldName);
            }
        }
    }

    public double getPriorProbability(String string) throws Exception {
        if (this.m_defaultValueOrPriorProbs == null) {
            throw new Exception("[TargetMetaInfo] no TargetValues defined (getPriorProbability)");
        }
        double d = Double.NaN;
        boolean bl = false;
        for (int i = 0; i < this.m_values.size(); ++i) {
            if (!string.equals(this.m_values.get(i))) continue;
            bl = true;
            d = this.m_defaultValueOrPriorProbs[i];
            break;
        }
        if (!bl) {
            throw new Exception("[TargetMetaInfo] couldn't find value " + string + "(getPriorProbability)");
        }
        return d;
    }

    public double getDefaultValue() throws Exception {
        if (this.m_defaultValueOrPriorProbs == null) {
            throw new Exception("[TargetMetaInfo] no TargetValues defined (getPriorProbability)");
        }
        return this.m_defaultValueOrPriorProbs[0];
    }

    public ArrayList<String> getValues() {
        return new ArrayList<String>(this.m_values);
    }

    public double applyMinMaxRescaleCast(double d) throws Exception {
        if (this.m_optype != FieldMetaInfo.Optype.CONTINUOUS) {
            throw new Exception("[TargetMetaInfo] target must be continuous!");
        }
        if (!Instance.isMissingValue(this.m_min) && d < this.m_min) {
            d = this.m_min;
        }
        if (!Instance.isMissingValue(this.m_max) && d > this.m_max) {
            d = this.m_max;
        }
        d *= this.m_rescaleFactor;
        d += this.m_rescaleConstant;
        if (this.m_castInteger.length() > 0) {
            if (this.m_castInteger.equals("round")) {
                d = Math.round(d);
            } else if (this.m_castInteger.equals("ceiling")) {
                d = Math.ceil(d);
            } else if (this.m_castInteger.equals("floor")) {
                d = Math.floor(d);
            } else {
                throw new Exception("[TargetMetaInfo] unknown castInteger value " + this.m_castInteger);
            }
        }
        return d;
    }

    @Override
    public Attribute getFieldAsAttribute() {
        if (this.m_optype == FieldMetaInfo.Optype.CONTINUOUS) {
            return new Attribute(this.m_fieldName);
        }
        if (this.m_values.size() == 0) {
            return new Attribute(this.m_fieldName, (FastVector)null);
        }
        FastVector fastVector = new FastVector();
        for (String string : this.m_values) {
            fastVector.addElement(string);
        }
        return new Attribute(this.m_fieldName, fastVector);
    }
}

