/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class EvaluationUtils
implements RevisionHandler {
    private int m_Seed = 1;

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public FastVector getCVPredictions(Classifier classifier, Instances instances, int n) throws Exception {
        FastVector fastVector = new FastVector();
        Instances instances2 = new Instances(instances);
        Random random = new Random(this.m_Seed);
        instances2.randomize(random);
        if (instances2.classAttribute().isNominal() && n > 1) {
            instances2.stratify(n);
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Instances instances3 = instances2.trainCV(n, i, random);
            Instances instances4 = instances2.testCV(n, i);
            FastVector fastVector2 = this.getTrainTestPredictions(classifier, instances3, instances4);
            fastVector.appendElements(fastVector2);
        }
        return fastVector;
    }

    public FastVector getTrainTestPredictions(Classifier classifier, Instances instances, Instances instances2) throws Exception {
        classifier.buildClassifier(instances);
        return this.getTestPredictions(classifier, instances2);
    }

    public FastVector getTestPredictions(Classifier classifier, Instances instances) throws Exception {
        FastVector fastVector = new FastVector();
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (instances.instance(i).classIsMissing()) continue;
            fastVector.addElement(this.getPrediction(classifier, instances.instance(i)));
        }
        return fastVector;
    }

    public Prediction getPrediction(Classifier classifier, Instance instance) throws Exception {
        double d = instance.classValue();
        double[] dArray = classifier.distributionForInstance(instance);
        if (instance.classAttribute().isNominal()) {
            return new NominalPrediction(d, dArray, instance.weight());
        }
        return new NumericPrediction(d, dArray[0], instance.weight());
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.11 $");
    }
}

