/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import weka.core.Instances;
import weka.core.Undoable;
import weka.core.Utils;
import weka.gui.ComponentHelper;
import weka.gui.JTableHelper;
import weka.gui.ListSelectorDialog;
import weka.gui.arffviewer.ArffSortedTableModel;
import weka.gui.arffviewer.ArffTable;
import weka.gui.arffviewer.ArffTableCellRenderer;

public class ArffPanel
extends JPanel
implements ActionListener,
ChangeListener,
MouseListener,
Undoable {
    static final long serialVersionUID = -4697041150989513939L;
    public static final String TAB_INSTANCES = "Instances";
    private ArffTable m_TableArff;
    private JPopupMenu m_PopupHeader;
    private JPopupMenu m_PopupRows;
    private JLabel m_LabelName;
    private JMenuItem menuItemMean;
    private JMenuItem menuItemSetAllValues;
    private JMenuItem menuItemSetMissingValues;
    private JMenuItem menuItemReplaceValues;
    private JMenuItem menuItemRenameAttribute;
    private JMenuItem menuItemAttributeAsClass;
    private JMenuItem menuItemDeleteAttribute;
    private JMenuItem menuItemDeleteAttributes;
    private JMenuItem menuItemSortInstances;
    private JMenuItem menuItemDeleteSelectedInstance;
    private JMenuItem menuItemDeleteAllSelectedInstances;
    private JMenuItem menuItemSearch;
    private JMenuItem menuItemClearSearch;
    private JMenuItem menuItemUndo;
    private JMenuItem menuItemCopy;
    private JMenuItem menuItemOptimalColWidth;
    private JMenuItem menuItemOptimalColWidths;
    private String m_Filename;
    private String m_Title;
    private int m_CurrentCol;
    private boolean m_Changed;
    private HashSet m_ChangeListeners;
    private String m_LastSearch;
    private String m_LastReplace;

    public ArffPanel() {
        this.initialize();
        this.createPanel();
    }

    public ArffPanel(String string) {
        this();
        this.loadFile(string);
    }

    public ArffPanel(Instances instances) {
        this();
        this.m_Filename = "";
        this.setInstances(instances);
    }

    protected void initialize() {
        this.m_Filename = "";
        this.m_Title = "";
        this.m_CurrentCol = -1;
        this.m_LastSearch = "";
        this.m_LastReplace = "";
        this.m_Changed = false;
        this.m_ChangeListeners = new HashSet();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.menuItemMean = new JMenuItem("Get mean...");
        this.menuItemMean.addActionListener(this);
        this.menuItemSetAllValues = new JMenuItem("Set all values to...");
        this.menuItemSetAllValues.addActionListener(this);
        this.menuItemSetMissingValues = new JMenuItem("Set missing values to...");
        this.menuItemSetMissingValues.addActionListener(this);
        this.menuItemReplaceValues = new JMenuItem("Replace values with...");
        this.menuItemReplaceValues.addActionListener(this);
        this.menuItemRenameAttribute = new JMenuItem("Rename attribute...");
        this.menuItemRenameAttribute.addActionListener(this);
        this.menuItemAttributeAsClass = new JMenuItem("Attribute as class");
        this.menuItemAttributeAsClass.addActionListener(this);
        this.menuItemDeleteAttribute = new JMenuItem("Delete attribute");
        this.menuItemDeleteAttribute.addActionListener(this);
        this.menuItemDeleteAttributes = new JMenuItem("Delete attributes...");
        this.menuItemDeleteAttributes.addActionListener(this);
        this.menuItemSortInstances = new JMenuItem("Sort data (ascending)");
        this.menuItemSortInstances.addActionListener(this);
        this.menuItemOptimalColWidth = new JMenuItem("Optimal column width (current)");
        this.menuItemOptimalColWidth.addActionListener(this);
        this.menuItemOptimalColWidths = new JMenuItem("Optimal column width (all)");
        this.menuItemOptimalColWidths.addActionListener(this);
        this.menuItemUndo = new JMenuItem("Undo");
        this.menuItemUndo.addActionListener(this);
        this.menuItemCopy = new JMenuItem("Copy");
        this.menuItemCopy.addActionListener(this);
        this.menuItemSearch = new JMenuItem("Search...");
        this.menuItemSearch.addActionListener(this);
        this.menuItemClearSearch = new JMenuItem("Clear search");
        this.menuItemClearSearch.addActionListener(this);
        this.menuItemDeleteSelectedInstance = new JMenuItem("Delete selected instance");
        this.menuItemDeleteSelectedInstance.addActionListener(this);
        this.menuItemDeleteAllSelectedInstances = new JMenuItem("Delete ALL selected instances");
        this.menuItemDeleteAllSelectedInstances.addActionListener(this);
        this.m_TableArff = new ArffTable();
        this.m_TableArff.setToolTipText("Right click (or left+alt) for context menu");
        this.m_TableArff.getTableHeader().addMouseListener(this);
        this.m_TableArff.getTableHeader().setToolTipText("<html><b>Sort view:</b> left click = ascending / Shift + left click = descending<br><b>Menu:</b> right click (or left+alt)</html>");
        this.m_TableArff.getTableHeader().setDefaultRenderer(new ArffTableCellRenderer());
        this.m_TableArff.addChangeListener(this);
        this.m_TableArff.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.m_TableArff);
        this.add((Component)jScrollPane, "Center");
        this.m_LabelName = new JLabel();
        this.add((Component)this.m_LabelName, "North");
    }

    private void initPopupMenus() {
        this.m_PopupHeader = new JPopupMenu();
        this.m_PopupHeader.addMouseListener(this);
        this.m_PopupHeader.add(this.menuItemMean);
        if (!this.isReadOnly()) {
            this.m_PopupHeader.addSeparator();
            this.m_PopupHeader.add(this.menuItemSetAllValues);
            this.m_PopupHeader.add(this.menuItemSetMissingValues);
            this.m_PopupHeader.add(this.menuItemReplaceValues);
            this.m_PopupHeader.addSeparator();
            this.m_PopupHeader.add(this.menuItemRenameAttribute);
            this.m_PopupHeader.add(this.menuItemAttributeAsClass);
            this.m_PopupHeader.add(this.menuItemDeleteAttribute);
            this.m_PopupHeader.add(this.menuItemDeleteAttributes);
            this.m_PopupHeader.add(this.menuItemSortInstances);
        }
        this.m_PopupHeader.addSeparator();
        this.m_PopupHeader.add(this.menuItemOptimalColWidth);
        this.m_PopupHeader.add(this.menuItemOptimalColWidths);
        this.m_PopupRows = new JPopupMenu();
        this.m_PopupRows.addMouseListener(this);
        if (!this.isReadOnly()) {
            this.m_PopupRows.add(this.menuItemUndo);
            this.m_PopupRows.addSeparator();
        }
        this.m_PopupRows.add(this.menuItemCopy);
        this.m_PopupRows.addSeparator();
        this.m_PopupRows.add(this.menuItemSearch);
        this.m_PopupRows.add(this.menuItemClearSearch);
        if (!this.isReadOnly()) {
            this.m_PopupRows.addSeparator();
            this.m_PopupRows.add(this.menuItemDeleteSelectedInstance);
            this.m_PopupRows.add(this.menuItemDeleteAllSelectedInstances);
        }
    }

    private void setMenu() {
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.m_TableArff.getModel();
        boolean bl = arffSortedTableModel.getInstances() == null;
        boolean bl2 = !bl && arffSortedTableModel.getInstances().numAttributes() > 0;
        boolean bl3 = !bl && arffSortedTableModel.getInstances().numInstances() > 0;
        boolean bl4 = bl2 && this.m_CurrentCol > 0;
        boolean bl5 = bl4 && arffSortedTableModel.getAttributeAt(this.m_CurrentCol).isNumeric();
        this.menuItemUndo.setEnabled(this.canUndo());
        this.menuItemCopy.setEnabled(true);
        this.menuItemSearch.setEnabled(true);
        this.menuItemClearSearch.setEnabled(true);
        this.menuItemMean.setEnabled(bl5);
        this.menuItemSetAllValues.setEnabled(bl4);
        this.menuItemSetMissingValues.setEnabled(bl4);
        this.menuItemReplaceValues.setEnabled(bl4);
        this.menuItemRenameAttribute.setEnabled(bl4);
        this.menuItemDeleteAttribute.setEnabled(bl4);
        this.menuItemDeleteAttributes.setEnabled(bl4);
        this.menuItemSortInstances.setEnabled(bl3 && bl4);
        this.menuItemDeleteSelectedInstance.setEnabled(bl3 && this.m_TableArff.getSelectedRow() > -1);
        this.menuItemDeleteAllSelectedInstances.setEnabled(bl3 && this.m_TableArff.getSelectedRows().length > 0);
    }

    public ArffTable getTable() {
        return this.m_TableArff;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String getFilename() {
        return this.m_Filename;
    }

    public void setFilename(String string) {
        this.m_Filename = string;
        this.createTitle();
    }

    public Instances getInstances() {
        Instances instances = null;
        if (this.m_TableArff.getModel() != null) {
            instances = ((ArffSortedTableModel)this.m_TableArff.getModel()).getInstances();
        }
        return instances;
    }

    public void setInstances(Instances instances) {
        this.m_Filename = TAB_INSTANCES;
        this.createTitle();
        ArffSortedTableModel arffSortedTableModel = new ArffSortedTableModel(instances);
        this.m_TableArff.setModel(arffSortedTableModel);
        this.clearUndo();
        this.setChanged(false);
        this.createName();
    }

    public Vector getAttributes() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.getInstances().numAttributes(); ++i) {
            vector.add(this.getInstances().attribute(i).name());
        }
        Collections.sort(vector);
        return vector;
    }

    public void setChanged(boolean bl) {
        if (!bl) {
            this.m_Changed = bl;
            this.createTitle();
        }
    }

    public boolean isChanged() {
        return this.m_Changed;
    }

    public boolean isReadOnly() {
        if (this.m_TableArff == null) {
            return true;
        }
        return ((ArffSortedTableModel)this.m_TableArff.getModel()).isReadOnly();
    }

    public void setReadOnly(boolean bl) {
        if (this.m_TableArff != null) {
            ((ArffSortedTableModel)this.m_TableArff.getModel()).setReadOnly(bl);
        }
    }

    public boolean isUndoEnabled() {
        return ((ArffSortedTableModel)this.m_TableArff.getModel()).isUndoEnabled();
    }

    public void setUndoEnabled(boolean bl) {
        ((ArffSortedTableModel)this.m_TableArff.getModel()).setUndoEnabled(bl);
    }

    public void clearUndo() {
        ((ArffSortedTableModel)this.m_TableArff.getModel()).clearUndo();
    }

    public boolean canUndo() {
        return ((ArffSortedTableModel)this.m_TableArff.getModel()).canUndo();
    }

    public void undo() {
        if (this.canUndo()) {
            ((ArffSortedTableModel)this.m_TableArff.getModel()).undo();
            this.notifyListener();
        }
    }

    public void addUndoPoint() {
        ((ArffSortedTableModel)this.m_TableArff.getModel()).addUndoPoint();
        this.setMenu();
    }

    private void createTitle() {
        if (this.m_Filename.equals("")) {
            this.m_Title = "-none-";
        } else if (this.m_Filename.equals(TAB_INSTANCES)) {
            this.m_Title = TAB_INSTANCES;
        } else {
            try {
                File file = new File(this.m_Filename);
                this.m_Title = file.getName();
            }
            catch (Exception exception) {
                this.m_Title = "-none-";
            }
        }
        if (this.isChanged()) {
            this.m_Title = this.m_Title + " *";
        }
    }

    private void createName() {
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (arffSortedTableModel != null && arffSortedTableModel.getInstances() != null) {
            this.m_LabelName.setText("Relation: " + arffSortedTableModel.getInstances().relationName());
        } else {
            this.m_LabelName.setText("");
        }
    }

    private void loadFile(String string) {
        this.m_Filename = string;
        this.createTitle();
        ArffSortedTableModel arffSortedTableModel = string.equals("") ? null : new ArffSortedTableModel(string);
        this.m_TableArff.setModel(arffSortedTableModel);
        this.setChanged(false);
        this.createName();
    }

    private void calcMean() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (!arffSortedTableModel.getAttributeAt(this.m_CurrentCol).isNumeric()) {
            return;
        }
        double d = 0.0;
        for (int i = 0; i < arffSortedTableModel.getRowCount(); ++i) {
            d += arffSortedTableModel.getInstances().instance(i).value(this.m_CurrentCol - 1);
        }
        ComponentHelper.showMessageBox(this.getParent(), "Mean for attribute...", "Mean for attribute '" + this.m_TableArff.getPlainColumnName(this.m_CurrentCol) + "':\n\t" + Utils.doubleToString(d /= (double)arffSortedTableModel.getRowCount(), 3), 2, -1);
    }

    private void setValues(Object object) {
        String string;
        String string2;
        String string3 = "";
        String string4 = "";
        if (object == this.menuItemSetMissingValues) {
            string2 = "Replace missing values...";
            string = "New value for MISSING values";
        } else if (object == this.menuItemSetAllValues) {
            string2 = "Set all values...";
            string = "New value for ALL values";
        } else if (object == this.menuItemReplaceValues) {
            string2 = "Replace values...";
            string = "Old value";
        } else {
            return;
        }
        string3 = ComponentHelper.showInputBox(this.m_TableArff.getParent(), string2, string, this.m_LastSearch);
        if (string3 == null) {
            return;
        }
        this.m_LastSearch = string3;
        if (object == this.menuItemReplaceValues) {
            string4 = ComponentHelper.showInputBox(this.m_TableArff.getParent(), string2, "New value", this.m_LastReplace);
            if (string4 == null) {
                return;
            }
            this.m_LastReplace = string4;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.m_TableArff.getModel();
        arffSortedTableModel.setNotificationEnabled(false);
        this.addUndoPoint();
        arffSortedTableModel.setUndoEnabled(false);
        for (int i = 0; i < this.m_TableArff.getRowCount(); ++i) {
            if (object == this.menuItemSetAllValues) {
                arffSortedTableModel.setValueAt(string3, i, this.m_CurrentCol);
                continue;
            }
            if (object == this.menuItemSetMissingValues && arffSortedTableModel.isMissingAt(i, this.m_CurrentCol)) {
                arffSortedTableModel.setValueAt(string3, i, this.m_CurrentCol);
                continue;
            }
            if (object != this.menuItemReplaceValues || !arffSortedTableModel.getValueAt(i, this.m_CurrentCol).toString().equals(string3)) continue;
            arffSortedTableModel.setValueAt(string4, i, this.m_CurrentCol);
        }
        arffSortedTableModel.setUndoEnabled(true);
        arffSortedTableModel.setNotificationEnabled(true);
        arffSortedTableModel.notifyListener(new TableModelEvent(arffSortedTableModel, 0, arffSortedTableModel.getRowCount(), this.m_CurrentCol, 0));
        this.m_TableArff.repaint();
    }

    public void deleteAttribute() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (arffSortedTableModel.getAttributeAt(this.m_CurrentCol) == null) {
            return;
        }
        if (ComponentHelper.showMessageBox(this.getParent(), "Confirm...", "Do you really want to delete the attribute '" + arffSortedTableModel.getAttributeAt(this.m_CurrentCol).name() + "'?", 0, 3) != 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        arffSortedTableModel.deleteAttributeAt(this.m_CurrentCol);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteAttributes() {
        JList jList = new JList(this.getAttributes());
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog(null, jList);
        int n = listSelectorDialog.showDialog();
        if (n != 0) {
            return;
        }
        Object[] objectArray = jList.getSelectedValues();
        if (ComponentHelper.showMessageBox(this.getParent(), "Confirm...", "Do you really want to delete these " + objectArray.length + " attributes?", 0, 3) != 0) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.m_TableArff.getModel();
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = arffSortedTableModel.getAttributeColumn(objectArray[i].toString());
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        arffSortedTableModel.deleteAttributes(nArray);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void attributeAsClass() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (arffSortedTableModel.getAttributeAt(this.m_CurrentCol) == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        arffSortedTableModel.attributeAsClassAt(this.m_CurrentCol);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void renameAttribute() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (arffSortedTableModel.getAttributeAt(this.m_CurrentCol) == null) {
            return;
        }
        String string = ComponentHelper.showInputBox(this.getParent(), "Rename attribute...", "Enter new Attribute name", arffSortedTableModel.getAttributeAt(this.m_CurrentCol).name());
        if (string == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        arffSortedTableModel.renameAttributeAt(this.m_CurrentCol, string);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteInstance() {
        int n = this.m_TableArff.getSelectedRow();
        if (n == -1) {
            return;
        }
        ((ArffSortedTableModel)this.m_TableArff.getModel()).deleteInstanceAt(n);
    }

    public void deleteInstances() {
        if (this.m_TableArff.getSelectedRow() == -1) {
            return;
        }
        int[] nArray = this.m_TableArff.getSelectedRows();
        ((ArffSortedTableModel)this.m_TableArff.getModel()).deleteInstances(nArray);
    }

    public void sortInstances() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ((ArffSortedTableModel)this.m_TableArff.getModel()).sortInstances(this.m_CurrentCol);
    }

    public void copyContent() {
        StringSelection stringSelection = this.getTable().getStringSelection();
        if (stringSelection == null) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void search() {
        String string = ComponentHelper.showInputBox(this.getParent(), "Search...", "Enter the string to search for", this.m_LastSearch);
        if (string != null) {
            this.m_LastSearch = string;
        }
        this.getTable().setSearchString(string);
    }

    public void clearSearch() {
        this.getTable().setSearchString("");
    }

    public void setOptimalColWidth() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        JTableHelper.setOptimalColumnWidth(this.getTable(), this.m_CurrentCol);
    }

    public void setOptimalColWidths() {
        JTableHelper.setOptimalColumnWidth(this.getTable());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.menuItemMean) {
            this.calcMean();
        } else if (object == this.menuItemSetAllValues) {
            this.setValues(this.menuItemSetAllValues);
        } else if (object == this.menuItemSetMissingValues) {
            this.setValues(this.menuItemSetMissingValues);
        } else if (object == this.menuItemReplaceValues) {
            this.setValues(this.menuItemReplaceValues);
        } else if (object == this.menuItemRenameAttribute) {
            this.renameAttribute();
        } else if (object == this.menuItemAttributeAsClass) {
            this.attributeAsClass();
        } else if (object == this.menuItemDeleteAttribute) {
            this.deleteAttribute();
        } else if (object == this.menuItemDeleteAttributes) {
            this.deleteAttributes();
        } else if (object == this.menuItemDeleteSelectedInstance) {
            this.deleteInstance();
        } else if (object == this.menuItemDeleteAllSelectedInstances) {
            this.deleteInstances();
        } else if (object == this.menuItemSortInstances) {
            this.sortInstances();
        } else if (object == this.menuItemSearch) {
            this.search();
        } else if (object == this.menuItemClearSearch) {
            this.clearSearch();
        } else if (object == this.menuItemUndo) {
            this.undo();
        } else if (object == this.menuItemCopy) {
            this.copyContent();
        } else if (object == this.menuItemOptimalColWidth) {
            this.setOptimalColWidth();
        } else if (object == this.menuItemOptimalColWidths) {
            this.setOptimalColWidths();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.m_TableArff.columnAtPoint(mouseEvent.getPoint());
        boolean bl = mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1 || mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1 && mouseEvent.isAltDown() && !mouseEvent.isControlDown() && !mouseEvent.isShiftDown();
        boolean bl2 = bl = bl && this.getInstances() != null;
        if (mouseEvent.getSource() == this.m_TableArff.getTableHeader()) {
            this.m_CurrentCol = n;
            if (bl) {
                mouseEvent.consume();
                this.setMenu();
                this.initPopupMenus();
                this.m_PopupHeader.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (mouseEvent.getSource() == this.m_TableArff && bl) {
            mouseEvent.consume();
            this.setMenu();
            this.initPopupMenus();
            this.m_PopupRows.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1 && !mouseEvent.isAltDown() && n > -1) {
            this.m_TableArff.setSelectedColumn(n);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.m_Changed = true;
        this.createTitle();
        this.notifyListener();
    }

    public void notifyListener() {
        Iterator iterator = this.m_ChangeListeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_ChangeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_ChangeListeners.remove(changeListener);
    }
}

