/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.regression;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.datagenerators.RegressionGenerator;

public class MexicanHat
extends RegressionGenerator {
    static final long serialVersionUID = 4577016375261512975L;
    protected double m_Amplitude;
    protected double m_MinRange;
    protected double m_MaxRange;
    protected double m_NoiseRate;
    protected double m_NoiseVariance;
    protected Random m_NoiseRandom = null;

    public MexicanHat() {
        this.setAmplitude(this.defaultAmplitude());
        this.setMinRange(this.defaultMinRange());
        this.setMaxRange(this.defaultMaxRange());
        this.setNoiseRate(this.defaultNoiseRate());
        this.setNoiseVariance(this.defaultNoiseVariance());
    }

    public String globalInfo() {
        return "A data generator for the simple 'Mexian Hat' function:\n   y = sin|x| / |x|\nIn addition to this simple function, the amplitude can be changed and gaussian noise can be added.";
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.addElement(new Option("\tThe amplitude multiplier (default " + this.defaultAmplitude() + ").", "A", 1, "-A <num>"));
        vector.addElement(new Option("\tThe range x is randomly drawn from (default " + this.defaultMinRange() + ".." + this.defaultMaxRange() + ").", "R", 1, "-R <num>..<num>"));
        vector.addElement(new Option("\tThe noise rate (default " + this.defaultNoiseRate() + ").", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tThe noise variance (default " + this.defaultNoiseVariance() + ").", "V", 1, "-V <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('A', stringArray);
        if (string.length() != 0) {
            this.setAmplitude(Double.parseDouble(string));
        } else {
            this.setAmplitude(this.defaultAmplitude());
        }
        string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setRange(string);
        } else {
            this.setRange(this.defaultMinRange() + ".." + this.defaultMaxRange());
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNoiseRate(Double.parseDouble(string));
        } else {
            this.setNoiseRate(this.defaultNoiseRate());
        }
        string = Utils.getOption('V', stringArray);
        if (string.length() != 0) {
            this.setNoiseVariance(Double.parseDouble(string));
        } else {
            this.setNoiseVariance(this.defaultNoiseVariance());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.removeBlacklist(super.getOptions());
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-A");
        vector.add("" + this.getAmplitude());
        vector.add("-R");
        vector.add("" + this.getRange());
        vector.add("-N");
        vector.add("" + this.getNoiseRate());
        vector.add("-V");
        vector.add("" + this.getNoiseVariance());
        return vector.toArray(new String[vector.size()]);
    }

    protected double defaultAmplitude() {
        return 1.0;
    }

    public double getAmplitude() {
        return this.m_Amplitude;
    }

    public void setAmplitude(double d) {
        this.m_Amplitude = d;
    }

    public String amplitudeTipText() {
        return "The amplitude of the mexican hat.";
    }

    protected void setRange(String string) {
        int n = string.indexOf("..");
        String string2 = string.substring(0, n);
        this.setMinRange(Double.valueOf(string2));
        String string3 = string.substring(n + 2, string.length());
        this.setMaxRange(Double.valueOf(string3));
    }

    protected String getRange() {
        String string = "" + Utils.doubleToString(this.getMinRange(), 2) + ".." + Utils.doubleToString(this.getMaxRange(), 2);
        return string;
    }

    protected String rangeTipText() {
        return "The upper and lower boundary for the range x is drawn from randomly.";
    }

    protected double defaultMinRange() {
        return -10.0;
    }

    public void setMinRange(double d) {
        this.m_MinRange = d;
    }

    public double getMinRange() {
        return this.m_MinRange;
    }

    public String minRangeTipText() {
        return "The lower boundary for the range x is drawn from randomly.";
    }

    protected double defaultMaxRange() {
        return 10.0;
    }

    public void setMaxRange(double d) {
        this.m_MaxRange = d;
    }

    public double getMaxRange() {
        return this.m_MaxRange;
    }

    public String maxRangeTipText() {
        return "The upper boundary for the range x is drawn from randomly.";
    }

    protected double defaultNoiseRate() {
        return 0.0;
    }

    public double getNoiseRate() {
        return this.m_NoiseRate;
    }

    public void setNoiseRate(double d) {
        this.m_NoiseRate = d;
    }

    public String noiseRateTipText() {
        return "The gaussian noise rate to use.";
    }

    protected double defaultNoiseVariance() {
        return 1.0;
    }

    public double getNoiseVariance() {
        return this.m_NoiseVariance;
    }

    public void setNoiseVariance(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("Noise variance needs to be > 0 (provided: " + d + ")!");
        }
        this.m_NoiseVariance = d;
    }

    public String noiseVarianceTipText() {
        return "The noise variance to use.";
    }

    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    public Instances defineDataFormat() throws Exception {
        this.m_Random = new Random(this.getSeed());
        this.m_NoiseRandom = new Random(this.getSeed());
        this.setNumExamplesAct(this.getNumExamples());
        FastVector fastVector = new FastVector();
        fastVector.addElement(new Attribute("x"));
        fastVector.addElement(new Attribute("y"));
        this.m_DatasetFormat = new Instances(this.getRelationNameToUse(), fastVector, 0);
        return this.m_DatasetFormat;
    }

    public Instance generateExample() throws Exception {
        Instance instance = null;
        Random random = this.getRandom();
        if (this.m_DatasetFormat == null) {
            throw new Exception("Dataset format not defined.");
        }
        double[] dArray = new double[this.m_DatasetFormat.numAttributes()];
        double d = random.nextDouble();
        double d2 = Utils.eq(d = d * (this.getMaxRange() - this.getMinRange()) + this.getMinRange(), 0.0) ? this.getAmplitude() : this.getAmplitude() * StrictMath.sin(StrictMath.abs(d)) / StrictMath.abs(d);
        dArray[0] = d;
        dArray[1] = d2 += this.getAmplitude() * this.m_NoiseRandom.nextGaussian() * this.getNoiseRate() * this.getNoiseVariance();
        instance = new Instance(1.0, dArray);
        instance.setDataset(this.m_DatasetFormat);
        return instance;
    }

    public Instances generateExamples() throws Exception {
        Instances instances = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        for (int i = 0; i < this.getNumExamplesAct(); ++i) {
            instances.add(this.generateExample());
        }
        return instances;
    }

    public String generateStart() {
        return "";
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] stringArray) {
        MexicanHat.runDataGenerator(new MexicanHat(), stringArray);
    }
}

