/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import weka.classifiers.rules.ZeroR;
import weka.core.Check;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class CheckGOE
extends Check {
    protected Object m_Object = new ZeroR();
    protected boolean m_Success;
    protected HashSet<String> m_IgnoredProperties = new HashSet();

    public CheckGOE() {
        try {
            this.setOptions(new String[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tSkipped properties.\n\t(default: capabilities,options)", "ignored", 1, "-ignored <comma-separated list of properties>"));
        vector.addElement(new Option("\tFull name of the class analysed.\n\teg: weka.classifiers.rules.ZeroR\n\t(default weka.classifiers.rules.ZeroR)", "W", 1, "-W"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            string = ZeroR.class.getName();
        }
        this.setObject(Utils.forName(Object.class, string, null));
        string = Utils.getOption("ignored", stringArray);
        if (string.length() == 0) {
            string = "capabilities,options";
        }
        this.setIgnoredProperties(string);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-ignored");
        vector.add(this.getIgnoredProperties());
        if (this.getObject() != null) {
            vector.add("-W");
            vector.add(this.getObject().getClass().getName());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setObject(Object object) {
        this.m_Object = object;
    }

    public Object getObject() {
        return this.m_Object;
    }

    public void setIgnoredProperties(String string) {
        this.m_IgnoredProperties.clear();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_IgnoredProperties.add(stringArray[i]);
        }
    }

    public String getIgnoredProperties() {
        Vector<String> vector = new Vector<String>();
        Iterator<String> iterator = this.m_IgnoredProperties.iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        if (vector.size() > 1) {
            Collections.sort(vector);
        }
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + (String)vector.get(i);
        }
        return string;
    }

    public boolean getSuccess() {
        return this.m_Success;
    }

    public boolean checkGlobalInfo() {
        this.print("Global info...");
        boolean bl = true;
        Class<?> clazz = this.getObject().getClass();
        try {
            clazz.getMethod("globalInfo", null);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            this.println("yes");
        } else {
            this.println("no");
        }
        return bl;
    }

    public boolean checkToolTips() {
        PropertyDescriptor[] propertyDescriptorArray;
        this.print("Tool tips...");
        boolean bl = true;
        String string = "TipText";
        Class<?> clazz = this.getObject().getClass();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
            propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            propertyDescriptorArray = null;
        }
        if (propertyDescriptorArray != null) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (this.m_IgnoredProperties.contains(propertyDescriptorArray[i].getName()) || propertyDescriptorArray[i].getReadMethod() == null || propertyDescriptorArray[i].getWriteMethod() == null) continue;
                try {
                    clazz.getMethod(propertyDescriptorArray[i].getName() + string, null);
                    continue;
                }
                catch (Exception exception) {
                    bl = false;
                    vector.add(propertyDescriptorArray[i].getName() + string);
                }
            }
            if (bl) {
                this.println("yes");
            } else {
                this.println("no (missing: " + vector + ")");
            }
        } else {
            this.println("maybe");
        }
        return bl;
    }

    public void doTests() {
        this.println("Object: " + this.m_Object.getClass().getName() + "\n");
        this.println("--> Tests");
        this.m_Success = this.checkGlobalInfo();
        if (this.m_Success) {
            this.m_Success = this.checkToolTips();
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] stringArray) {
        CheckGOE checkGOE = new CheckGOE();
        CheckGOE.runCheck(checkGOE, stringArray);
        if (checkGOE.getSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

