/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.Utils;

import java.util.ArrayList;
import java.util.TreeMap;
import weka.clusterers.forOPTICSAndDBScan.Utils.UpdateQueueElement;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class UpdateQueue
implements RevisionHandler {
    private ArrayList queue = new ArrayList();
    private TreeMap objectPositionsInHeap = new TreeMap();

    public void add(double d, Object object, String string) {
        int n = 0;
        if (this.objectPositionsInHeap.containsKey(string)) {
            n = (Integer)this.objectPositionsInHeap.get(string);
            if (((UpdateQueueElement)this.queue.get(n)).getPriority() <= d) {
                return;
            }
            this.queue.set(n++, new UpdateQueueElement(d, object, string));
        } else {
            this.queue.add(new UpdateQueueElement(d, object, string));
            n = this.size();
        }
        this.heapValueUpwards(n);
    }

    public double getPriority(int n) {
        return ((UpdateQueueElement)this.queue.get(n)).getPriority();
    }

    private void heapValueUpwards(int n) {
        int n2 = n;
        int n3 = n2 / 2;
        UpdateQueueElement updateQueueElement = (UpdateQueueElement)this.queue.get(n2 - 1);
        while (n3 > 0 && this.getPriority(n3 - 1) > updateQueueElement.getPriority()) {
            this.queue.set(n2 - 1, this.queue.get(n3 - 1));
            this.objectPositionsInHeap.put(((UpdateQueueElement)this.queue.get(n2 - 1)).getObjectKey(), new Integer(n2 - 1));
            n2 = n3;
            n3 = n2 / 2;
        }
        this.queue.set(n2 - 1, updateQueueElement);
        this.objectPositionsInHeap.put(((UpdateQueueElement)this.queue.get(n2 - 1)).getObjectKey(), new Integer(n2 - 1));
    }

    private void heapValueDownwards() {
        int n = 1;
        int n2 = 2 * n;
        UpdateQueueElement updateQueueElement = (UpdateQueueElement)this.queue.get(n - 1);
        if (n2 < this.size() && this.getPriority(n2) < this.getPriority(n2 - 1)) {
            ++n2;
        }
        while (n2 <= this.size() && this.getPriority(n2 - 1) < updateQueueElement.getPriority()) {
            this.queue.set(n - 1, this.queue.get(n2 - 1));
            this.objectPositionsInHeap.put(((UpdateQueueElement)this.queue.get(n - 1)).getObjectKey(), new Integer(n - 1));
            n = n2;
            if ((n2 = 2 * n) >= this.size() || !(this.getPriority(n2) < this.getPriority(n2 - 1))) continue;
            ++n2;
        }
        this.queue.set(n - 1, updateQueueElement);
        this.objectPositionsInHeap.put(((UpdateQueueElement)this.queue.get(n - 1)).getObjectKey(), new Integer(n - 1));
    }

    public int size() {
        return this.queue.size();
    }

    public boolean hasNext() {
        return this.queue.size() != 0;
    }

    public UpdateQueueElement next() {
        UpdateQueueElement updateQueueElement = (UpdateQueueElement)this.queue.get(0);
        this.queue.set(0, this.queue.get(this.size() - 1));
        this.queue.remove(this.size() - 1);
        this.objectPositionsInHeap.remove(updateQueueElement.getObjectKey());
        if (this.hasNext()) {
            this.heapValueDownwards();
        }
        return updateQueueElement;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }
}

