/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.RandomizableClusterer;
import weka.core.AlgVector;
import weka.core.Capabilities;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.KDTree;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class XMeans
extends RandomizableClusterer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -7941793078404132616L;
    protected Instances m_Instances = null;
    protected Instances m_Model = null;
    protected ReplaceMissingValues m_ReplaceMissingFilter;
    protected double m_BinValue = 1.0;
    protected double m_Bic = Double.MIN_VALUE;
    protected double[] m_Mle = null;
    protected int m_MaxIterations = 1;
    protected int m_MaxKMeans = 1000;
    protected int m_MaxKMeansForChildren = 1000;
    protected int m_NumClusters = 2;
    protected int m_MinNumClusters = 2;
    protected int m_MaxNumClusters = 4;
    protected DistanceFunction m_DistanceF = new EuclideanDistance();
    protected Instances m_ClusterCenters;
    protected File m_InputCenterFile = new File(System.getProperty("user.dir"));
    protected Reader m_DebugVectorsInput = null;
    protected int m_DebugVectorsIndex = 0;
    protected Instances m_DebugVectors = null;
    protected File m_DebugVectorsFile = new File(System.getProperty("user.dir"));
    protected Reader m_CenterInput = null;
    protected File m_OutputCenterFile = new File(System.getProperty("user.dir"));
    protected PrintWriter m_CenterOutput = null;
    protected int[] m_ClusterAssignments;
    protected double m_CutOffFactor = 0.5;
    public static int R_LOW = 0;
    public static int R_HIGH = 1;
    public static int R_WIDTH = 2;
    protected KDTree m_KDTree = new KDTree();
    protected boolean m_UseKDTree = false;
    protected int m_IterationCount = 0;
    protected int m_KMeansStopped = 0;
    protected int m_NumSplits = 0;
    protected int m_NumSplitsDone = 0;
    protected int m_NumSplitsStillDone = 0;
    protected int m_DebugLevel = 0;
    public static int D_PRINTCENTERS = 1;
    public static int D_FOLLOWSPLIT = 2;
    public static int D_CONVCHCLOSER = 3;
    public static int D_RANDOMVECTOR = 4;
    public static int D_KDTREE = 5;
    public static int D_ITERCOUNT = 6;
    public static int D_METH_MISUSE = 80;
    public static int D_CURR = 88;
    public static int D_GENERAL = 99;
    public boolean m_CurrDebugFlag = true;

    public XMeans() {
        this.m_SeedDefault = 10;
        this.setSeed(this.m_SeedDefault);
    }

    public String globalInfo() {
        return "Cluster data using the X-means algorithm.\n\nX-Means is K-Means extended by an Improve-Structure part In this part of the algorithm the centers are attempted to be split in its region. The decision between the children of each center and itself is done comparing the BIC-values of the two structures.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Dan Pelleg and Andrew W. Moore");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "X-means: Extending K-means with Efficient Estimation of the Number of Clusters");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Seventeenth International Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2000");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "727-734");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        return capabilities;
    }

    public void buildClusterer(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        this.m_NumSplits = 0;
        this.m_NumSplitsDone = 0;
        this.m_NumSplitsStillDone = 0;
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        this.m_ReplaceMissingFilter.setInputFormat(instances);
        this.m_Instances = Filter.useFilter(instances, this.m_ReplaceMissingFilter);
        Random random = new Random(this.m_Seed);
        this.m_NumClusters = this.m_MinNumClusters;
        if (this.m_DistanceF == null) {
            this.m_DistanceF = new EuclideanDistance();
        }
        this.m_DistanceF.setInstances(this.m_Instances);
        this.checkInstances();
        if (this.m_DebugVectorsFile.exists() && this.m_DebugVectorsFile.isFile()) {
            this.initDebugVectorsInput();
        }
        int[] nArray = new int[this.m_Instances.numInstances()];
        for (n = 0; n < this.m_Instances.numInstances(); ++n) {
            nArray[n] = n;
        }
        this.m_Model = new Instances(this.m_Instances, 0);
        if (this.m_CenterInput != null) {
            this.m_ClusterCenters = new Instances(this.m_CenterInput);
            this.m_NumClusters = this.m_ClusterCenters.numInstances();
        } else {
            this.m_ClusterCenters = this.makeCentersRandomly(random, this.m_Instances, this.m_NumClusters);
        }
        this.PFD(D_FOLLOWSPLIT, "\n*** Starting centers ");
        for (n = 0; n < this.m_ClusterCenters.numInstances(); ++n) {
            this.PFD(D_FOLLOWSPLIT, "Center " + n + ": " + this.m_ClusterCenters.instance(n));
        }
        this.PrCentersFD(D_PRINTCENTERS);
        n = 0;
        if (this.m_UseKDTree) {
            this.m_KDTree.setInstances(this.m_Instances);
        }
        this.m_IterationCount = 0;
        while (n == 0 && !this.stopIteration(this.m_IterationCount, this.m_MaxIterations)) {
            int[] nArray2;
            this.PFD(D_FOLLOWSPLIT, "\nBeginning of main loop - centers:");
            this.PrCentersFD(D_FOLLOWSPLIT);
            this.PFD(D_ITERCOUNT, "\n*** 1. Improve-Params " + this.m_IterationCount + ". time");
            ++this.m_IterationCount;
            boolean bl = false;
            this.m_ClusterAssignments = this.initAssignments(this.m_Instances.numInstances());
            int[][] nArrayArray = new int[this.m_ClusterCenters.numInstances()][];
            int n2 = 0;
            this.PFD(D_FOLLOWSPLIT, "\nConverge in K-Means:");
            while (!bl && !this.stopKMeansIteration(n2, this.m_MaxKMeans)) {
                bl = true;
                bl = this.assignToCenters(this.m_UseKDTree ? this.m_KDTree : null, this.m_ClusterCenters, nArrayArray, nArray, this.m_ClusterAssignments, ++n2);
                this.PFD(D_FOLLOWSPLIT, "\nMain loop - Assign - centers:");
                this.PrCentersFD(D_FOLLOWSPLIT);
                bl = this.recomputeCenters(this.m_ClusterCenters, nArrayArray, this.m_Model);
                this.PFD(D_FOLLOWSPLIT, "\nMain loop - Recompute - centers:");
                this.PrCentersFD(D_FOLLOWSPLIT);
            }
            this.PFD(D_FOLLOWSPLIT, "");
            this.PFD(D_FOLLOWSPLIT, "End of Part: 1. Improve-Params - conventional K-means");
            this.m_Mle = this.distortion(nArrayArray, this.m_ClusterCenters);
            this.m_Bic = this.calculateBIC(nArrayArray, this.m_ClusterCenters, this.m_Mle);
            this.PFD(D_FOLLOWSPLIT, "m_Bic " + this.m_Bic);
            int n3 = this.m_ClusterCenters.numInstances();
            Instances instances2 = new Instances(this.m_ClusterCenters, n3 * 2);
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            for (int i = 0; i < n3; ++i) {
                this.PFD(D_FOLLOWSPLIT, "\nsplit center " + i + " " + this.m_ClusterCenters.instance(i));
                Instance instance = this.m_ClusterCenters.instance(i);
                nArray2 = nArrayArray[i];
                int n4 = nArrayArray[i].length;
                if (n4 <= 2) {
                    dArray[i] = Double.MAX_VALUE;
                    dArray2[i] = 0.0;
                    instances2.add(instance);
                    instances2.add(instance);
                    continue;
                }
                double d = this.m_Mle[i] / (double)n4;
                Instances instances3 = this.splitCenter(random, instance, d, this.m_Model);
                int[] nArray3 = this.initAssignments(n4);
                int[][] nArrayArray2 = new int[2][];
                bl = false;
                int n5 = 0;
                this.PFD(D_FOLLOWSPLIT, "\nConverge, K-Means for children: " + i);
                while (!bl && !this.stopKMeansIteration(n5, this.m_MaxKMeansForChildren)) {
                    ++n5;
                    bl = this.assignToCenters(instances3, nArrayArray2, nArray2, nArray3);
                    if (bl) continue;
                    this.recomputeCentersFast(instances3, nArrayArray2, this.m_Model);
                }
                instances2.add(instances3.instance(0));
                instances2.add(instances3.instance(1));
                this.PFD(D_FOLLOWSPLIT, "\nconverged cildren ");
                this.PFD(D_FOLLOWSPLIT, " " + instances3.instance(0));
                this.PFD(D_FOLLOWSPLIT, " " + instances3.instance(1));
                dArray[i] = this.calculateBIC(nArray2, instance, this.m_Mle[i], this.m_Model);
                double[] dArray3 = this.distortion(nArrayArray2, instances3);
                dArray2[i] = this.calculateBIC(nArrayArray2, instances3, dArray3);
            }
            Instances instances4 = null;
            instances4 = this.newCentersAfterSplit(dArray, dArray2, this.m_CutOffFactor, instances2);
            int n6 = instances4.numInstances();
            if (n6 != this.m_NumClusters) {
                this.PFD(D_FOLLOWSPLIT, "Compare with non-split");
                nArray2 = this.initAssignments(this.m_Instances.numInstances());
                int[][] nArrayArray3 = new int[instances4.numInstances()][];
                bl = this.assignToCenters(this.m_UseKDTree ? this.m_KDTree : null, instances4, nArrayArray3, nArray, nArray2, this.m_IterationCount);
                double[] dArray4 = this.distortion(nArrayArray3, instances4);
                double d = this.calculateBIC(nArrayArray3, instances4, dArray4);
                this.PFD(D_FOLLOWSPLIT, "newBic " + d);
                if (d > this.m_Bic) {
                    this.PFD(D_FOLLOWSPLIT, "*** decide for new clusters");
                    this.m_Bic = d;
                    this.m_ClusterCenters = instances4;
                    this.m_ClusterAssignments = nArray2;
                } else {
                    this.PFD(D_FOLLOWSPLIT, "*** keep old clusters");
                }
            }
            if ((n6 = this.m_ClusterCenters.numInstances()) >= this.m_MaxNumClusters || n6 == this.m_NumClusters) {
                n = 1;
            }
            this.m_NumClusters = n6;
        }
    }

    public boolean checkForNominalAttributes(Instances instances) {
        int n = 0;
        while (n < instances.numAttributes()) {
            if (n == instances.classIndex() || !instances.attribute(n++).isNominal()) continue;
            return true;
        }
        return false;
    }

    protected int[] initAssignments(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    protected int[] initAssignments(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    boolean[] initBoolArray(int n) {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = false;
        }
        return blArray;
    }

    protected Instances newCentersAfterSplit(double[] dArray, double[] dArray2, double d, Instances instances) {
        boolean bl = false;
        boolean bl2 = false;
        boolean[] blArray = this.initBoolArray(this.m_ClusterCenters.numInstances());
        int n = 0;
        Instances instances2 = null;
        for (int i = 0; i < dArray2.length; ++i) {
            if (dArray2[i] > dArray[i]) {
                blArray[i] = true;
                ++n;
                this.PFD(D_FOLLOWSPLIT, "Center " + i + " decide for children");
                continue;
            }
            this.PFD(D_FOLLOWSPLIT, "Center " + i + " decide for parent");
        }
        if (n == 0 && d > 0.0) {
            bl = true;
            n = (int)((double)this.m_ClusterCenters.numInstances() * this.m_CutOffFactor);
        }
        double[] dArray3 = new double[this.m_NumClusters];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        int[] nArray = Utils.sort(dArray3);
        int n2 = this.m_MaxNumClusters - this.m_NumClusters;
        if (n2 > n) {
            n2 = n;
        } else {
            bl2 = true;
        }
        if (bl) {
            for (int i = 0; i < n2 && dArray2[nArray[i]] > 0.0; ++i) {
                blArray[nArray[i]] = true;
            }
            this.m_NumSplitsStillDone += n2;
        } else if (bl2) {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < blArray.length && n4 < n2; ++n3) {
                if (!blArray[nArray[n3]]) continue;
                ++n4;
            }
            while (n3 < blArray.length) {
                blArray[nArray[n3]] = false;
                ++n3;
            }
        }
        instances2 = n2 > 0 ? this.newCentersAfterSplit(blArray, instances) : this.m_ClusterCenters;
        return instances2;
    }

    protected Instances newCentersAfterSplit(boolean[] blArray, Instances instances) {
        Instances instances2 = new Instances(instances, 0);
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i]) {
                ++this.m_NumSplitsDone;
                instances2.add(instances.instance(n++));
                instances2.add(instances.instance(n++));
                continue;
            }
            ++n;
            ++n;
            instances2.add(this.m_ClusterCenters.instance(i));
        }
        return instances2;
    }

    protected boolean stopKMeansIteration(int n, int n2) {
        boolean bl = false;
        if (n2 >= 0) {
            boolean bl2 = bl = n >= n2;
        }
        if (bl) {
            ++this.m_KMeansStopped;
        }
        return bl;
    }

    protected boolean stopIteration(int n, int n2) {
        boolean bl = false;
        if (n2 >= 0) {
            bl = n >= n2;
        }
        return bl;
    }

    protected boolean recomputeCenters(Instances instances, int[][] nArray, Instances instances2) {
        boolean bl = true;
        for (int i = 0; i < instances.numInstances(); ++i) {
            for (int j = 0; j < instances2.numAttributes(); ++j) {
                double d = this.meanOrMode(this.m_Instances, nArray[i], j);
                for (int k = 0; k < nArray[i].length; ++k) {
                    if (!bl || this.m_ClusterCenters.instance(i).value(j) == d) continue;
                    bl = false;
                }
                if (bl) continue;
                this.m_ClusterCenters.instance(i).setValue(j, d);
            }
        }
        return bl;
    }

    protected void recomputeCentersFast(Instances instances, int[][] nArray, Instances instances2) {
        for (int i = 0; i < instances.numInstances(); ++i) {
            for (int j = 0; j < instances2.numAttributes(); ++j) {
                double d = this.meanOrMode(this.m_Instances, nArray[i], j);
                instances.instance(i).setValue(j, d);
            }
        }
    }

    protected double meanOrMode(Instances instances, int[] nArray, int n) {
        int n2 = nArray.length;
        if (instances.attribute(n).isNumeric()) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < n2; ++i) {
                Instance instance = instances.instance(nArray[i]);
                if (instance.isMissing(n)) continue;
                d += instance.weight();
                d2 += instance.weight() * instance.value(n);
            }
            if (Utils.eq(d, 0.0)) {
                return 0.0;
            }
            return d2 / d;
        }
        if (instances.attribute(n).isNominal()) {
            int[] nArray2 = new int[instances.attribute(n).numValues()];
            for (int i = 0; i < n2; ++i) {
                Instance instance = instances.instance(nArray[i]);
                if (instance.isMissing(n)) continue;
                int n3 = (int)instance.value(n);
                nArray2[n3] = (int)((double)nArray2[n3] + instance.weight());
            }
            return Utils.maxIndex(nArray2);
        }
        return 0.0;
    }

    protected boolean assignToCenters(KDTree kDTree, Instances instances, int[][] nArray, int[] nArray2, int[] nArray3, int n) throws Exception {
        boolean bl = true;
        bl = kDTree != null ? this.assignToCenters(kDTree, instances, nArray, nArray3, n) : this.assignToCenters(instances, nArray, nArray2, nArray3);
        return bl;
    }

    protected boolean assignToCenters(KDTree kDTree, Instances instances, int[][] object, int[] nArray, int n) throws Exception {
        int n2;
        int n3 = instances.numInstances();
        int n4 = this.m_Instances.numInstances();
        int[] nArray2 = new int[n4];
        if (nArray == null) {
            nArray = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[0] = -1;
            }
        }
        if (object == null) {
            object = new int[n3][];
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[n2] = nArray[n2];
        }
        kDTree.centerInstances(instances, nArray, Math.pow(0.8, n));
        n2 = 1;
        for (int i = 0; n2 != 0 && i < nArray.length; ++i) {
            int n5 = n2 = nArray2[i] == nArray[i] ? 1 : 0;
            if (nArray[i] != -1) continue;
            throw new Exception("Instance " + i + " has not been assigned to cluster.");
        }
        if (n2 == 0) {
            int n6;
            int[] nArray3 = new int[n3];
            for (n6 = 0; n6 < n3; ++n6) {
                nArray3[n6] = 0;
            }
            for (n6 = 0; n6 < n4; ++n6) {
                int n7 = nArray[n6];
                nArray3[n7] = nArray3[n7] + 1;
            }
            for (n6 = 0; n6 < n3; ++n6) {
                object[n6] = new int[nArray3[n6]];
            }
            for (n6 = 0; n6 < n3; ++n6) {
                int n8 = -1;
                for (int i = 0; i < nArray3[n6]; ++i) {
                    object[n6][i] = n8 = this.nextAssignedOne(n6, n8, nArray);
                }
            }
        }
        return n2 != 0;
    }

    protected boolean assignToCenters(Instances instances, int[][] object, int[] nArray, int[] nArray2) throws Exception {
        int n;
        int n2;
        boolean bl = true;
        int n3 = nArray.length;
        int n4 = instances.numInstances();
        int[] nArray3 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray3[n2] = 0;
        }
        if (nArray2 == null) {
            nArray2 = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray2[n2] = -1;
            }
        }
        if (object == null) {
            object = new int[n4][];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Instance instance = this.m_Instances.instance(nArray[n2]);
            n = this.clusterProcessedInstance(instance, instances);
            if (bl && n != nArray2[n2]) {
                bl = false;
            }
            int n5 = n;
            nArray3[n5] = nArray3[n5] + 1;
            if (bl) continue;
            nArray2[n2] = n;
        }
        if (!bl) {
            this.PFD(D_FOLLOWSPLIT, "assignToCenters -> it has NOT converged");
            for (n2 = 0; n2 < n4; ++n2) {
                object[n2] = new int[nArray3[n2]];
            }
            for (n2 = 0; n2 < n4; ++n2) {
                int n6 = -1;
                for (n = 0; n < nArray3[n2]; ++n) {
                    n6 = this.nextAssignedOne(n2, n6, nArray2);
                    object[n2][n] = nArray[n6];
                }
            }
        } else {
            this.PFD(D_FOLLOWSPLIT, "assignToCenters -> it has converged");
        }
        return bl;
    }

    protected int nextAssignedOne(int n, int n2, int[] nArray) {
        int n3 = nArray.length;
        for (int i = n2 + 1; i < n3; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    protected Instances splitCenter(Random random, Instance instance, double d, Instances instances) throws Exception {
        RevisionHandler revisionHandler;
        ++this.m_NumSplits;
        AlgVector algVector = null;
        Instances instances2 = new Instances(instances, 2);
        if (this.m_DebugVectorsFile.exists() && this.m_DebugVectorsFile.isFile()) {
            revisionHandler = this.getNextDebugVectorsInstance(instances);
            this.PFD(D_RANDOMVECTOR, "Random Vector from File " + revisionHandler);
            algVector = new AlgVector((Instance)revisionHandler);
        } else {
            algVector = new AlgVector(instances, random);
        }
        algVector.changeLength(Math.pow(d, 0.5));
        this.PFD(D_RANDOMVECTOR, "random vector *variance " + algVector);
        revisionHandler = new AlgVector(instance);
        AlgVector algVector2 = (AlgVector)((AlgVector)revisionHandler).clone();
        revisionHandler = ((AlgVector)revisionHandler).add(algVector);
        Instance instance2 = ((AlgVector)revisionHandler).getAsInstance(instances, random);
        instances2.add(instance2);
        this.PFD(D_FOLLOWSPLIT, "first child " + instance2);
        algVector2 = algVector2.substract(algVector);
        instance2 = algVector2.getAsInstance(instances, random);
        instances2.add(instance2);
        this.PFD(D_FOLLOWSPLIT, "second child " + instance2);
        return instances2;
    }

    protected Instances splitCenters(Random random, Instances instances, Instances instances2) {
        Instances instances3 = new Instances(instances2, 2);
        int n = Math.abs(random.nextInt()) % instances.numInstances();
        instances3.add(instances.instance(n));
        int n2 = n;
        for (int i = 0; n2 == n && i < 10; ++i) {
            n2 = Math.abs(random.nextInt()) % instances.numInstances();
        }
        instances3.add(instances.instance(n2));
        return instances3;
    }

    protected Instances makeCentersRandomly(Random random, Instances instances, int n) {
        Instances instances2 = new Instances(instances, n);
        this.m_NumClusters = n;
        for (int i = 0; i < n; ++i) {
            int n2 = Math.abs(random.nextInt()) % this.m_Instances.numInstances();
            instances2.add(this.m_Instances.instance(n2));
        }
        return instances2;
    }

    protected double calculateBIC(int[] nArray, Instance instance, double d, Instances instances) {
        int[][] nArray2 = new int[1][nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[0][i] = nArray[i];
        }
        double[] dArray = new double[]{d};
        Instances instances2 = new Instances(instances, 1);
        instances2.add(instance);
        return this.calculateBIC(nArray2, instances2, dArray);
    }

    protected double calculateBIC(int[][] nArray, Instances instances, double[] dArray) {
        double d = 0.0;
        int n = 0;
        int n2 = instances.numInstances();
        int n3 = instances.numAttributes();
        int n4 = n2 - 1 + n2 * n3 + n2;
        for (int i = 0; i < instances.numInstances(); ++i) {
            d += this.logLikelihoodEstimate(nArray[i].length, instances.instance(i), dArray[i], instances.numInstances() * 2);
            n += nArray[i].length;
        }
        d -= (double)n * Math.log(n);
        return d -= (double)n4 / 2.0 * Math.log(n);
    }

    protected double logLikelihoodEstimate(int n, Instance instance, double d, int n2) {
        double d2 = 0.0;
        if (n > 1) {
            double d3 = d / ((double)n - 1.0);
            double d4 = -((double)n / 2.0) * Math.log(Math.PI * 2);
            double d5 = (double)(-(n * instance.numAttributes()) / 2) * Math.log(d3);
            double d6 = -((double)n - 1.0) / 2.0;
            double d7 = (double)n * Math.log(n);
            d2 = d4 + d5 + d6 + d7;
        }
        return d2;
    }

    protected double[] distortion(int[][] nArray, Instances instances) {
        double[] dArray = new double[instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j < nArray[i].length; ++j) {
                int n = i;
                dArray[n] = dArray[n] + this.m_DistanceF.distance(this.m_Instances.instance(nArray[i][j]), instances.instance(i));
            }
        }
        return dArray;
    }

    protected int clusterProcessedInstance(Instance instance, Instances instances) {
        double d = 2.147483647E9;
        int n = 0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            double d2 = this.m_DistanceF.distance(instance, instances.instance(i));
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    protected int clusterProcessedInstance(Instance instance) {
        double d = 2.147483647E9;
        int n = 0;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            double d2 = this.m_DistanceF.distance(instance, this.m_ClusterCenters.instance(i));
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public int clusterInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingFilter.input(instance);
        Instance instance2 = this.m_ReplaceMissingFilter.output();
        return this.clusterProcessedInstance(instance2);
    }

    public int numberOfClusters() {
        return this.m_NumClusters;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tmaximum number of overall iterations\n\t(default 1).", "I", 1, "-I <num>"));
        vector.addElement(new Option("\tmaximum number of iterations in the kMeans loop in\n\tthe Improve-Parameter part \n\t(default 1000).", "M", 1, "-M <num>"));
        vector.addElement(new Option("\tmaximum number of iterations in the kMeans loop\n\tfor the splitted centroids in the Improve-Structure part \n\t(default 1000).", "J", 1, "-J <num>"));
        vector.addElement(new Option("\tminimum number of clusters\n\t(default 2).", "L", 1, "-L <num>"));
        vector.addElement(new Option("\tmaximum number of clusters\n\t(default 4).", "H", 1, "-H <num>"));
        vector.addElement(new Option("\tdistance value for binary attributes\n\t(default 1.0).", "B", 1, "-B <value>"));
        vector.addElement(new Option("\tUses the KDTree internally\n\t(default no).", "use-kdtree", 0, "-use-kdtree"));
        vector.addElement(new Option("\tFull class name of KDTree class to use, followed\n\tby scheme options.\n\teg: \"weka.core.neighboursearch.kdtrees.KDTree -P\"\n\t(default no KDTree class used).", "K", 1, "-K <KDTree class specification>"));
        vector.addElement(new Option("\tcutoff factor, takes the given percentage of the splitted \n\tcentroids if none of the children win\n\t(default 0.0).", "C", 1, "-C <value>"));
        vector.addElement(new Option("\tFull class name of Distance function class to use, followed\n\tby scheme options.\n\t(default weka.core.EuclideanDistance).", "D", 1, "-D <distance function class specification>"));
        vector.addElement(new Option("\tfile to read starting centers from (ARFF format).", "N", 1, "-N <file name>"));
        vector.addElement(new Option("\tfile to write centers to (ARFF format).", "O", 1, "-O <file name>"));
        vector.addElement(new Option("\tThe debug level.\n\t(default 0)", "U", 1, "-U <int>"));
        vector.addElement(new Option("\tThe debug vectors file.", "Y", 1, "-Y <file name>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public String minNumClustersTipText() {
        return "set minimum number of clusters";
    }

    public void setMinNumClusters(int n) {
        if (n <= this.m_MaxNumClusters) {
            this.m_MinNumClusters = n;
        }
    }

    public int getMinNumClusters() {
        return this.m_MinNumClusters;
    }

    public String maxNumClustersTipText() {
        return "set maximum number of clusters";
    }

    public void setMaxNumClusters(int n) {
        if (n >= this.m_MinNumClusters) {
            this.m_MaxNumClusters = n;
        }
    }

    public int getMaxNumClusters() {
        return this.m_MaxNumClusters;
    }

    public String maxIterationsTipText() {
        return "the maximum number of iterations to perform";
    }

    public void setMaxIterations(int n) throws Exception {
        if (n < 0) {
            throw new Exception("Only positive values for iteration number allowed (Option I).");
        }
        this.m_MaxIterations = n;
    }

    public int getMaxIterations() {
        return this.m_MaxIterations;
    }

    public String maxKMeansTipText() {
        return "the maximum number of iterations to perform in KMeans";
    }

    public void setMaxKMeans(int n) {
        this.m_MaxKMeans = n;
        this.m_MaxKMeansForChildren = n;
    }

    public int getMaxKMeans() {
        return this.m_MaxKMeans;
    }

    public String maxKMeansForChildrenTipText() {
        return "the maximum number of iterations KMeans that is performed on the child centers";
    }

    public void setMaxKMeansForChildren(int n) {
        this.m_MaxKMeansForChildren = n;
    }

    public int getMaxKMeansForChildren() {
        return this.m_MaxKMeansForChildren;
    }

    public String cutOffFactorTipText() {
        return "the cut-off factor to use";
    }

    public void setCutOffFactor(double d) {
        this.m_CutOffFactor = d;
    }

    public double getCutOffFactor() {
        return this.m_CutOffFactor;
    }

    public String binValueTipText() {
        return "Set the value that represents true in the new attributes.";
    }

    public double getBinValue() {
        return this.m_BinValue;
    }

    public void setBinValue(double d) {
        this.m_BinValue = d;
    }

    public String distanceFTipText() {
        return "The distance function to use.";
    }

    public void setDistanceF(DistanceFunction distanceFunction) {
        this.m_DistanceF = distanceFunction;
    }

    public DistanceFunction getDistanceF() {
        return this.m_DistanceF;
    }

    protected String getDistanceFSpec() {
        DistanceFunction distanceFunction = this.getDistanceF();
        if (distanceFunction instanceof OptionHandler) {
            return distanceFunction.getClass().getName() + " " + Utils.joinOptions(distanceFunction.getOptions());
        }
        return distanceFunction.getClass().getName();
    }

    public String debugVectorsFileTipText() {
        return "The file containing the debug vectors (only for debugging!).";
    }

    public void setDebugVectorsFile(File file) {
        this.m_DebugVectorsFile = file;
    }

    public File getDebugVectorsFile() {
        return this.m_DebugVectorsFile;
    }

    public void initDebugVectorsInput() throws Exception {
        this.m_DebugVectorsInput = new BufferedReader(new FileReader(this.m_DebugVectorsFile));
        this.m_DebugVectors = new Instances(this.m_DebugVectorsInput);
        this.m_DebugVectorsIndex = 0;
    }

    public Instance getNextDebugVectorsInstance(Instances instances) throws Exception {
        if (this.m_DebugVectorsIndex >= this.m_DebugVectors.numInstances()) {
            throw new Exception("no more prefabricated Vectors");
        }
        Instance instance = this.m_DebugVectors.instance(this.m_DebugVectorsIndex);
        instance.setDataset(instances);
        ++this.m_DebugVectorsIndex;
        return instance;
    }

    public String inputCenterFileTipText() {
        return "The file to read the list of centers from.";
    }

    public void setInputCenterFile(File file) {
        this.m_InputCenterFile = file;
    }

    public File getInputCenterFile() {
        return this.m_InputCenterFile;
    }

    public String outputCenterFileTipText() {
        return "The file to write the list of centers to.";
    }

    public void setOutputCenterFile(File file) {
        this.m_OutputCenterFile = file;
    }

    public File getOutputCenterFile() {
        return this.m_OutputCenterFile;
    }

    public String KDTreeTipText() {
        return "The KDTree to use.";
    }

    public void setKDTree(KDTree kDTree) {
        this.m_KDTree = kDTree;
    }

    public KDTree getKDTree() {
        return this.m_KDTree;
    }

    public String useKDTreeTipText() {
        return "Whether to use the KDTree.";
    }

    public void setUseKDTree(boolean bl) {
        this.m_UseKDTree = bl;
    }

    public boolean getUseKDTree() {
        return this.m_UseKDTree;
    }

    protected String getKDTreeSpec() {
        KDTree kDTree = this.getKDTree();
        if (kDTree instanceof OptionHandler) {
            return kDTree.getClass().getName() + " " + Utils.joinOptions(kDTree.getOptions());
        }
        return kDTree.getClass().getName();
    }

    public String debugLevelTipText() {
        return "The debug level to use.";
    }

    public void setDebugLevel(int n) {
        this.m_DebugLevel = n;
    }

    public int getDebugLevel() {
        return this.m_DebugLevel;
    }

    protected void checkInstances() {
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String[] stringArray2;
        String string2;
        String string3 = Utils.getOption('I', stringArray);
        if (string3.length() != 0) {
            this.setMaxIterations(Integer.parseInt(string3));
        } else {
            this.setMaxIterations(1);
        }
        string3 = Utils.getOption('M', stringArray);
        if (string3.length() != 0) {
            this.setMaxKMeans(Integer.parseInt(string3));
        } else {
            this.setMaxKMeans(1000);
        }
        string3 = Utils.getOption('J', stringArray);
        if (string3.length() != 0) {
            this.setMaxKMeansForChildren(Integer.parseInt(string3));
        } else {
            this.setMaxKMeansForChildren(1000);
        }
        string3 = Utils.getOption('L', stringArray);
        if (string3.length() != 0) {
            this.setMinNumClusters(Integer.parseInt(string3));
        } else {
            this.setMinNumClusters(2);
        }
        string3 = Utils.getOption('H', stringArray);
        if (string3.length() != 0) {
            this.setMaxNumClusters(Integer.parseInt(string3));
        } else {
            this.setMaxNumClusters(4);
        }
        string3 = Utils.getOption('B', stringArray);
        if (string3.length() != 0) {
            this.setBinValue(Double.parseDouble(string3));
        } else {
            this.setBinValue(1.0);
        }
        this.setUseKDTree(Utils.getFlag("use-kdtree", stringArray));
        if (this.getUseKDTree()) {
            string2 = Utils.getOption('K', stringArray);
            if (string2.length() != 0) {
                stringArray2 = Utils.splitOptions(string2);
                if (stringArray2.length == 0) {
                    throw new Exception("Invalid function specification string");
                }
                string = stringArray2[0];
                stringArray2[0] = "";
                this.setKDTree((KDTree)Utils.forName(KDTree.class, string, stringArray2));
            } else {
                this.setKDTree(new KDTree());
            }
        } else {
            this.setKDTree(new KDTree());
        }
        string3 = Utils.getOption('C', stringArray);
        if (string3.length() != 0) {
            this.setCutOffFactor(Double.parseDouble(string3));
        } else {
            this.setCutOffFactor(0.0);
        }
        string2 = Utils.getOption('D', stringArray);
        if (string2.length() != 0) {
            stringArray2 = Utils.splitOptions(string2);
            if (stringArray2.length == 0) {
                throw new Exception("Invalid function specification string");
            }
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setDistanceF((DistanceFunction)Utils.forName(DistanceFunction.class, string, stringArray2));
        } else {
            this.setDistanceF(new EuclideanDistance());
        }
        string3 = Utils.getOption('N', stringArray);
        if (string3.length() != 0) {
            this.setInputCenterFile(new File(string3));
            this.m_CenterInput = new BufferedReader(new FileReader(string3));
        } else {
            this.setInputCenterFile(new File(System.getProperty("user.dir")));
            this.m_CenterInput = null;
        }
        string3 = Utils.getOption('O', stringArray);
        if (string3.length() != 0) {
            this.setOutputCenterFile(new File(string3));
            this.m_CenterOutput = new PrintWriter(new FileOutputStream(string3));
        } else {
            this.setOutputCenterFile(new File(System.getProperty("user.dir")));
            this.m_CenterOutput = null;
        }
        string3 = Utils.getOption('U', stringArray);
        int n = 0;
        if (string3.length() != 0) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception(string3 + "is an illegal value for option -U");
            }
        }
        this.setDebugLevel(n);
        string3 = Utils.getOption('Y', stringArray);
        if (string3.length() != 0) {
            this.setDebugVectorsFile(new File(string3));
        } else {
            this.setDebugVectorsFile(new File(System.getProperty("user.dir")));
            this.m_DebugVectorsInput = null;
            this.m_DebugVectors = null;
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        int n;
        Vector<String> vector = new Vector<String>();
        vector.add("-I");
        vector.add("" + this.getMaxIterations());
        vector.add("-M");
        vector.add("" + this.getMaxKMeans());
        vector.add("-J");
        vector.add("" + this.getMaxKMeansForChildren());
        vector.add("-L");
        vector.add("" + this.getMinNumClusters());
        vector.add("-H");
        vector.add("" + this.getMaxNumClusters());
        vector.add("-B");
        vector.add("" + this.getBinValue());
        if (this.getUseKDTree()) {
            vector.add("-use-kdtree");
            vector.add("-K");
            vector.add("" + this.getKDTreeSpec());
        }
        vector.add("-C");
        vector.add("" + this.getCutOffFactor());
        if (this.getDistanceF() != null) {
            vector.add("-D");
            vector.add("" + this.getDistanceFSpec());
        }
        if (this.getInputCenterFile().exists() && this.getInputCenterFile().isFile()) {
            vector.add("-N");
            vector.add("" + this.getInputCenterFile());
        }
        if (this.getOutputCenterFile().exists() && this.getOutputCenterFile().isFile()) {
            vector.add("-O");
            vector.add("" + this.getOutputCenterFile());
        }
        if ((n = this.getDebugLevel()) > 0) {
            vector.add("-U");
            vector.add("" + this.getDebugLevel());
        }
        if (this.getDebugVectorsFile().exists() && this.getDebugVectorsFile().isFile()) {
            vector.add("-Y");
            vector.add("" + this.getDebugVectorsFile());
        }
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nXMeans\n======\n");
        stringBuffer.append("Requested iterations            : " + this.m_MaxIterations + "\n");
        stringBuffer.append("Iterations performed            : " + this.m_IterationCount + "\n");
        if (this.m_KMeansStopped > 0) {
            stringBuffer.append("kMeans did not converge\n");
            stringBuffer.append("  but was stopped by max-loops " + this.m_KMeansStopped + " times (max kMeans-iter)\n");
        }
        stringBuffer.append("Splits prepared                 : " + this.m_NumSplits + "\n");
        stringBuffer.append("Splits performed                : " + this.m_NumSplitsDone + "\n");
        stringBuffer.append("Cutoff factor                   : " + this.m_CutOffFactor + "\n");
        double d = this.m_NumSplitsDone > 0 ? (double)this.m_NumSplitsStillDone / (double)this.m_NumSplitsDone * 100.0 : 0.0;
        stringBuffer.append("Percentage of splits accepted \nby cutoff factor                : " + Utils.doubleToString(d, 2) + " %\n");
        stringBuffer.append("------\n");
        stringBuffer.append("Cutoff factor                   : " + this.m_CutOffFactor + "\n");
        stringBuffer.append("------\n");
        stringBuffer.append("\nCluster centers                 : " + this.m_NumClusters + " centers\n");
        for (int i = 0; i < this.m_NumClusters; ++i) {
            stringBuffer.append("\nCluster " + i + "\n           ");
            for (int j = 0; j < this.m_ClusterCenters.numAttributes(); ++j) {
                if (this.m_ClusterCenters.attribute(j).isNominal()) {
                    stringBuffer.append(" " + this.m_ClusterCenters.attribute(j).value((int)this.m_ClusterCenters.instance(i).value(j)));
                    continue;
                }
                stringBuffer.append(" " + this.m_ClusterCenters.instance(i).value(j));
            }
        }
        if (this.m_Mle != null) {
            stringBuffer.append("\n\nDistortion: " + Utils.doubleToString(Utils.sum(this.m_Mle), 6) + "\n");
        }
        stringBuffer.append("BIC-Value : " + Utils.doubleToString(this.m_Bic, 6) + "\n");
        return stringBuffer.toString();
    }

    protected void PrCentersFD(int n) {
        if (n == this.m_DebugLevel) {
            for (int i = 0; i < this.m_ClusterCenters.numInstances(); ++i) {
                System.out.println(this.m_ClusterCenters.instance(i));
            }
        }
    }

    protected boolean TFD(int n) {
        return n == this.m_DebugLevel;
    }

    protected void PFD(int n, String string) {
        if (n == this.m_DebugLevel) {
            System.out.println(string);
        }
    }

    protected void PFD_CURR(String string) {
        if (this.m_CurrDebugFlag) {
            System.out.println(string);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.24 $");
    }

    public static void main(String[] stringArray) {
        XMeans.runClusterer(new XMeans(), stringArray);
    }
}

