/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Bagging;
import weka.classifiers.trees.RandomTree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomForest
extends Classifier
implements OptionHandler,
Randomizable,
WeightedInstancesHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = 4216839470751428698L;
    protected int m_numTrees = 10;
    protected int m_numFeatures = 0;
    protected int m_randomSeed = 1;
    protected int m_KValue = 0;
    protected Bagging m_bagger = null;
    protected int m_MaxDepth = 0;

    public String globalInfo() {
        return "Class for constructing a forest of random trees.\n\nFor more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Leo Breiman");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2001");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Random Forests");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "45");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "1");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "5-32");
        return technicalInformation;
    }

    public String numTreesTipText() {
        return "The number of trees to be generated.";
    }

    public int getNumTrees() {
        return this.m_numTrees;
    }

    public void setNumTrees(int n) {
        this.m_numTrees = n;
    }

    public String numFeaturesTipText() {
        return "The number of attributes to be used in random selection (see RandomTree).";
    }

    public int getNumFeatures() {
        return this.m_numFeatures;
    }

    public void setNumFeatures(int n) {
        this.m_numFeatures = n;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int n) {
        this.m_randomSeed = n;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String maxDepthTipText() {
        return "The maximum depth of the trees, 0 for unlimited.";
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public void setMaxDepth(int n) {
        this.m_MaxDepth = n;
    }

    public double measureOutOfBagError() {
        if (this.m_bagger != null) {
            return this.m_bagger.measureOutOfBagError();
        }
        return Double.NaN;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement("measureOutOfBagError");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.equalsIgnoreCase("measureOutOfBagError")) {
            return this.measureOutOfBagError();
        }
        throw new IllegalArgumentException(string + " not supported (RandomForest)");
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tNumber of trees to build.", "I", 1, "-I <number of trees>"));
        vector.addElement(new Option("\tNumber of features to consider (<1=int(logM+1)).", "K", 1, "-K <number of features>"));
        vector.addElement(new Option("\tSeed for random number generator.\n\t(default 1)", "S", 1, "-S"));
        vector.addElement(new Option("\tThe maximum depth of the trees, 0 for unlimited.\n\t(default 0)", "depth", 1, "-depth <num>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-I");
        vector.add("" + this.getNumTrees());
        vector.add("-K");
        vector.add("" + this.getNumFeatures());
        vector.add("-S");
        vector.add("" + this.getSeed());
        if (this.getMaxDepth() > 0) {
            vector.add("-depth");
            vector.add("" + this.getMaxDepth());
        }
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('I', stringArray);
        this.m_numTrees = string.length() != 0 ? Integer.parseInt(string) : 10;
        string = Utils.getOption('K', stringArray);
        this.m_numFeatures = string.length() != 0 ? Integer.parseInt(string) : 0;
        string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        } else {
            this.setSeed(1);
        }
        string = Utils.getOption("depth", stringArray);
        if (string.length() != 0) {
            this.setMaxDepth(Integer.parseInt(string));
        } else {
            this.setMaxDepth(0);
        }
        super.setOptions(stringArray);
        Utils.checkForRemainingOptions(stringArray);
    }

    public Capabilities getCapabilities() {
        return new RandomTree().getCapabilities();
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_bagger = new Bagging();
        RandomTree randomTree = new RandomTree();
        this.m_KValue = this.m_numFeatures;
        if (this.m_KValue < 1) {
            this.m_KValue = (int)Utils.log2(instances.numAttributes()) + 1;
        }
        randomTree.setKValue(this.m_KValue);
        randomTree.setMaxDepth(this.getMaxDepth());
        this.m_bagger.setClassifier(randomTree);
        this.m_bagger.setSeed(this.m_randomSeed);
        this.m_bagger.setNumIterations(this.m_numTrees);
        this.m_bagger.setCalcOutOfBag(true);
        this.m_bagger.buildClassifier(instances);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_bagger.distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_bagger == null) {
            return "Random forest not built yet";
        }
        return "Random forest of " + this.m_numTrees + " trees, each constructed while considering " + this.m_KValue + " random feature" + (this.m_KValue == 1 ? "" : "s") + ".\n" + "Out of bag error: " + Utils.doubleToString(this.m_bagger.measureOutOfBagError(), 4) + "\n" + (this.getMaxDepth() > 0 ? "Max. depth of trees: " + this.getMaxDepth() + "\n" : "") + "\n";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.13 $");
    }

    public static void main(String[] stringArray) {
        RandomForest.runClassifier(new RandomForest(), stringArray);
    }
}

