/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import weka.classifiers.Classifier;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.EnsembleLibraryModelComparator;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.gui.ensembleLibraryEditor.LibrarySerialization;

public class EnsembleLibrary
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -7987178904923706760L;
    public static final String XML_FILE_EXTENSION = ".model.xml";
    public static final String FLAT_FILE_EXTENSION = ".mlf";
    public TreeSet m_Models;
    private transient PropertyChangeSupport m_LibraryPropertySupport = new PropertyChangeSupport(this);

    public EnsembleLibrary() {
        this.m_Models = new TreeSet(new EnsembleLibraryModelComparator());
    }

    public int size() {
        if (this.m_Models != null) {
            return this.m_Models.size();
        }
        return 0;
    }

    public void addModel(EnsembleLibraryModel ensembleLibraryModel) {
        this.m_Models.add(ensembleLibraryModel);
        if (this.m_LibraryPropertySupport != null) {
            this.m_LibraryPropertySupport.firePropertyChange(null, null, null);
        }
    }

    public void addModel(String string) {
        this.m_Models.add(this.createModel(string));
        this.m_LibraryPropertySupport.firePropertyChange(null, null, null);
    }

    public void removeModel(EnsembleLibraryModel ensembleLibraryModel) {
        this.m_Models.remove(ensembleLibraryModel);
        this.m_LibraryPropertySupport.firePropertyChange(null, null, null);
    }

    public EnsembleLibraryModel createModel(Classifier classifier) {
        EnsembleLibraryModel ensembleLibraryModel = new EnsembleLibraryModel(classifier);
        return ensembleLibraryModel;
    }

    public EnsembleLibraryModel createModel(String string) {
        String[] stringArray = string.split("\\s+");
        String string2 = stringArray[0];
        String string3 = string.replaceAll(stringArray[0], "");
        String[] stringArray2 = string3.split("\\s+");
        EnsembleLibraryModel ensembleLibraryModel = null;
        try {
            ensembleLibraryModel = new EnsembleLibraryModel(Classifier.forName(string2, stringArray2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return ensembleLibraryModel;
    }

    public TreeSet getModels() {
        return this.m_Models;
    }

    public void setModels(TreeSet treeSet) {
        this.m_Models = treeSet;
        this.m_LibraryPropertySupport.firePropertyChange(null, null, null);
    }

    public void clearModels() {
        this.m_Models.clear();
        this.m_LibraryPropertySupport.firePropertyChange(null, null, null);
    }

    public static void loadLibrary(File file, JComponent jComponent, EnsembleLibrary ensembleLibrary) {
        try {
            EnsembleLibrary.loadLibrary(file, ensembleLibrary);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(jComponent, "Error reading file '" + file.getName() + "':\n" + exception.getMessage(), "Load failed", 0);
            System.err.println(exception.getMessage());
        }
    }

    public static void loadLibrary(File file, EnsembleLibrary ensembleLibrary) throws Exception {
        if (file.getName().toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            Vector vector = null;
            try {
                LibrarySerialization librarySerialization = new LibrarySerialization();
                vector = (Vector)librarySerialization.read(file.getPath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                EnsembleLibraryModel ensembleLibraryModel = ensembleLibrary.createModel((Classifier)iterator.next());
                ensembleLibraryModel.testOptions();
                ensembleLibrary.addModel(ensembleLibraryModel);
            }
        } else if (file.getName().toLowerCase().endsWith(FLAT_FILE_EXTENSION)) {
            String string;
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                EnsembleLibraryModel ensembleLibraryModel = ensembleLibrary.createModel(string);
                if (ensembleLibraryModel != null) {
                    ensembleLibraryModel.testOptions();
                    ensembleLibrary.addModel(ensembleLibraryModel);
                    continue;
                }
                System.err.println("Failed to create model: " + string);
            }
            bufferedReader.close();
        }
    }

    public static void loadLibrary(InputStream inputStream, EnsembleLibrary ensembleLibrary) throws Exception {
        Vector vector = null;
        try {
            LibrarySerialization librarySerialization = new LibrarySerialization();
            vector = (Vector)librarySerialization.read(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < vector.size(); ++i) {
            EnsembleLibraryModel ensembleLibraryModel = ensembleLibrary.createModel((Classifier)vector.get(i));
            ensembleLibraryModel.testOptions();
            ensembleLibrary.addModel(ensembleLibraryModel);
        }
    }

    public static void saveLibrary(File file, EnsembleLibrary ensembleLibrary, JComponent jComponent) {
        if (file.getName().toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            Vector<Classifier> vector = new Vector<Classifier>();
            for (EnsembleLibraryModel ensembleLibraryModel : ensembleLibrary.getModels()) {
                vector.add(ensembleLibraryModel.getClassifier());
            }
            try {
                LibrarySerialization librarySerialization = new LibrarySerialization();
                librarySerialization.write(file.getPath(), vector);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (file.getName().toLowerCase().endsWith(FLAT_FILE_EXTENSION)) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                for (EnsembleLibraryModel ensembleLibraryModel : ensembleLibrary.getModels()) {
                    bufferedWriter.write(ensembleLibraryModel.getStringRepresentation() + "\n");
                }
                ((Writer)bufferedWriter).close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(jComponent, "Error writing file '" + file.getName() + "':\n" + exception.getMessage(), "Save failed", 0);
                System.err.println(exception.getMessage());
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_LibraryPropertySupport != null) {
            this.m_LibraryPropertySupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

