/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.MetaBean;
import weka.gui.beans.Visible;

public class BeanConnection
implements Serializable {
    private static final long serialVersionUID = 8804264241791332064L;
    public static Vector CONNECTIONS = new Vector();
    private BeanInstance m_source;
    private BeanInstance m_target;
    private String m_eventName;
    private boolean m_hidden = false;

    public static void reset() {
        CONNECTIONS = new Vector();
    }

    public static Vector getConnections() {
        return CONNECTIONS;
    }

    public static void setConnections(Vector vector) {
        CONNECTIONS = vector;
    }

    private static boolean previousLink(BeanInstance beanInstance, BeanInstance beanInstance2, int n) {
        for (int i = 0; i < CONNECTIONS.size(); ++i) {
            BeanConnection beanConnection = (BeanConnection)CONNECTIONS.elementAt(i);
            BeanInstance beanInstance3 = beanConnection.getSource();
            BeanInstance beanInstance4 = beanConnection.getTarget();
            if (beanInstance3 != beanInstance || beanInstance4 != beanInstance2 || n >= i) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForSource(BeanInstance beanInstance, Vector vector) {
        for (int i = 0; i < CONNECTIONS.size(); ++i) {
            BeanConnection beanConnection = (BeanConnection)CONNECTIONS.elementAt(i);
            if (beanConnection.getSource() != beanInstance) continue;
            for (int j = 0; j < vector.size(); ++j) {
                BeanInstance beanInstance2 = (BeanInstance)vector.elementAt(j);
                if (beanConnection.getTarget() != beanInstance2) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkTargetConstraint(BeanInstance beanInstance, Vector vector) {
        for (int i = 0; i < CONNECTIONS.size(); ++i) {
            BeanConnection beanConnection = (BeanConnection)CONNECTIONS.elementAt(i);
            if (beanConnection.getTarget() != beanInstance) continue;
            for (int j = 0; j < vector.size(); ++j) {
                BeanInstance beanInstance2 = (BeanInstance)vector.elementAt(j);
                if (beanConnection.getSource() != beanInstance2) continue;
                return false;
            }
        }
        return true;
    }

    public static Vector associatedConnections(Vector vector) {
        Vector<BeanConnection> vector2 = new Vector<BeanConnection>();
        block0: for (int i = 0; i < CONNECTIONS.size(); ++i) {
            BeanConnection beanConnection = (BeanConnection)CONNECTIONS.elementAt(i);
            BeanInstance beanInstance = beanConnection.getSource();
            BeanInstance beanInstance2 = beanConnection.getTarget();
            boolean bl = false;
            boolean bl2 = false;
            for (int j = 0; j < vector.size(); ++j) {
                BeanInstance beanInstance3 = (BeanInstance)vector.elementAt(j);
                if (beanInstance3 == beanInstance) {
                    bl = true;
                }
                if (beanInstance3 == beanInstance2) {
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                vector2.add(beanConnection);
                continue block0;
            }
        }
        return vector2;
    }

    public static Vector inputs(Vector vector) {
        Vector<BeanInstance> vector2 = new Vector<BeanInstance>();
        for (int i = 0; i < vector.size(); ++i) {
            BeanInstance beanInstance = (BeanInstance)vector.elementAt(i);
            if (!BeanConnection.checkTargetConstraint(beanInstance, vector)) continue;
            vector2.add(beanInstance);
        }
        return vector2;
    }

    private static boolean checkForTarget(BeanInstance beanInstance, Vector vector) {
        for (int i = 0; i < CONNECTIONS.size(); ++i) {
            BeanConnection beanConnection = (BeanConnection)CONNECTIONS.elementAt(i);
            if (beanConnection.getTarget() != beanInstance) continue;
            for (int j = 0; j < vector.size(); ++j) {
                BeanInstance beanInstance2 = (BeanInstance)vector.elementAt(j);
                if (beanConnection.getSource() != beanInstance2) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isInList(BeanInstance beanInstance, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            BeanInstance beanInstance2 = (BeanInstance)vector.elementAt(i);
            if (beanInstance != beanInstance2) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSourceConstraint(BeanInstance beanInstance, Vector vector) {
        boolean bl = true;
        for (int i = 0; i < CONNECTIONS.size(); ++i) {
            BeanConnection beanConnection = (BeanConnection)CONNECTIONS.elementAt(i);
            if (beanConnection.getSource() != beanInstance) continue;
            BeanInstance beanInstance2 = beanConnection.getTarget();
            if (!BeanConnection.isInList(beanInstance2, vector)) {
                return true;
            }
            for (int j = 0; j < vector.size(); ++j) {
                BeanInstance beanInstance3 = (BeanInstance)vector.elementAt(j);
                if (beanConnection.getTarget() != beanInstance3) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static Vector outputs(Vector vector) {
        Vector<BeanInstance> vector2 = new Vector<BeanInstance>();
        for (int i = 0; i < vector.size(); ++i) {
            BeanInstance beanInstance = (BeanInstance)vector.elementAt(i);
            if (!BeanConnection.checkForTarget(beanInstance, vector) || !BeanConnection.checkSourceConstraint(beanInstance, vector)) continue;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanInstance.getBean().getClass());
                EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
                if (eventSetDescriptorArray == null || eventSetDescriptorArray.length <= 0) continue;
                vector2.add(beanInstance);
                continue;
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return vector2;
    }

    public static void paintConnections(Graphics graphics) {
        for (int i = 0; i < CONNECTIONS.size(); ++i) {
            double d;
            BeanVisual beanVisual;
            BeanConnection beanConnection = (BeanConnection)CONNECTIONS.elementAt(i);
            if (beanConnection.isHidden()) continue;
            BeanInstance beanInstance = beanConnection.getSource();
            BeanInstance beanInstance2 = beanConnection.getTarget();
            EventSetDescriptor eventSetDescriptor = beanConnection.getSourceEventSetDescriptor();
            BeanVisual beanVisual2 = beanInstance.getBean() instanceof Visible ? ((Visible)beanInstance.getBean()).getVisual() : null;
            BeanVisual beanVisual3 = beanVisual = beanInstance2.getBean() instanceof Visible ? ((Visible)beanInstance2.getBean()).getVisual() : null;
            if (beanVisual2 == null || beanVisual == null) continue;
            Point point = beanVisual2.getClosestConnectorPoint(new Point(beanInstance2.getX() + beanInstance2.getWidth() / 2, beanInstance2.getY() + beanInstance2.getHeight() / 2));
            Point point2 = beanVisual.getClosestConnectorPoint(new Point(beanInstance.getX() + beanInstance.getWidth() / 2, beanInstance.getY() + beanInstance.getHeight() / 2));
            graphics.setColor(Color.red);
            boolean bl = true;
            if (beanInstance.getBean() instanceof EventConstraints && !((EventConstraints)beanInstance.getBean()).eventGeneratable(eventSetDescriptor.getName())) {
                graphics.setColor(Color.gray);
                bl = false;
            }
            graphics.drawLine((int)point.getX(), (int)point.getY(), (int)point2.getX(), (int)point2.getY());
            try {
                double d2 = (point.getY() - point2.getY()) / (point.getX() - point2.getX());
                d = Math.atan(d2);
            }
            catch (Exception exception) {
                d = 1.5707963267948966;
            }
            Point point3 = new Point(point2.x, point2.y);
            Point point4 = new Point((int)(7.0 * Math.cos(d)), (int)(7.0 * Math.sin(d)));
            Point point5 = point.getX() >= point2.getX() ? new Point(point3.x + point4.x, point3.y + point4.y) : new Point(point3.x - point4.x, point3.y - point4.y);
            int[] nArray = new int[]{point3.x, point5.x + (int)(7.0 * Math.cos(d + 1.5707963267948966)), point5.x + (int)(7.0 * Math.cos(d - 1.5707963267948966))};
            int[] nArray2 = new int[]{point3.y, point5.y + (int)(7.0 * Math.sin(d + 1.5707963267948966)), point5.y + (int)(7.0 * Math.sin(d - 1.5707963267948966))};
            graphics.fillPolygon(nArray, nArray2, 3);
            int n = (int)point.getX();
            n += (int)((point2.getX() - point.getX()) / 2.0);
            int n2 = (int)point.getY();
            n2 += (int)((point2.getY() - point.getY()) / 2.0) - 2;
            graphics.setColor(bl ? Color.blue : Color.gray);
            if (BeanConnection.previousLink(beanInstance, beanInstance2, i)) {
                n2 -= 15;
            }
            graphics.drawString(eventSetDescriptor.getName(), n, n2);
        }
    }

    public static Vector getClosestConnections(Point point, int n) {
        Vector<BeanConnection> vector = new Vector<BeanConnection>();
        for (int i = 0; i < CONNECTIONS.size(); ++i) {
            BeanVisual beanVisual;
            BeanConnection beanConnection = (BeanConnection)CONNECTIONS.elementAt(i);
            BeanInstance beanInstance = beanConnection.getSource();
            BeanInstance beanInstance2 = beanConnection.getTarget();
            EventSetDescriptor eventSetDescriptor = beanConnection.getSourceEventSetDescriptor();
            BeanVisual beanVisual2 = beanInstance.getBean() instanceof Visible ? ((Visible)beanInstance.getBean()).getVisual() : null;
            BeanVisual beanVisual3 = beanVisual = beanInstance2.getBean() instanceof Visible ? ((Visible)beanInstance2.getBean()).getVisual() : null;
            if (beanVisual2 == null || beanVisual == null) continue;
            Point point2 = beanVisual2.getClosestConnectorPoint(new Point(beanInstance2.getX() + beanInstance2.getWidth() / 2, beanInstance2.getY() + beanInstance2.getHeight() / 2));
            Point point3 = beanVisual.getClosestConnectorPoint(new Point(beanInstance.getX() + beanInstance.getWidth() / 2, beanInstance.getY() + beanInstance.getHeight() / 2));
            int n2 = (int)Math.min(point2.getX(), point3.getX());
            int n3 = (int)Math.max(point2.getX(), point3.getX());
            int n4 = (int)Math.min(point2.getY(), point3.getY());
            int n5 = (int)Math.max(point2.getY(), point3.getY());
            if (!(point.getX() >= (double)(n2 - n)) || !(point.getX() <= (double)(n3 + n)) || !(point.getY() >= (double)(n4 - n)) || !(point.getY() <= (double)(n5 + n))) continue;
            double d = point2.getY() - point3.getY();
            double d2 = point3.getX() - point2.getX();
            double d3 = point2.getX() * point3.getY() - point3.getX() * point2.getY();
            double d4 = Math.abs(d * point.getX() + d2 * point.getY() + d3);
            if (!((d4 /= Math.abs(Math.sqrt(d * d + d2 * d2))) <= (double)n)) continue;
            vector.addElement(beanConnection);
        }
        return vector;
    }

    public static void removeConnections(BeanInstance beanInstance) {
        int n;
        Vector vector = new Vector();
        if (beanInstance.getBean() instanceof MetaBean) {
            vector = ((MetaBean)beanInstance.getBean()).getBeansInSubFlow();
        } else {
            vector.add(beanInstance);
        }
        Vector<BeanConnection> vector2 = new Vector<BeanConnection>();
        for (n = 0; n < vector.size(); ++n) {
            BeanInstance beanInstance2 = (BeanInstance)vector.elementAt(n);
            for (int i = 0; i < CONNECTIONS.size(); ++i) {
                BeanConnection beanConnection = (BeanConnection)CONNECTIONS.elementAt(i);
                BeanInstance beanInstance3 = beanConnection.getTarget();
                BeanInstance beanInstance4 = beanConnection.getSource();
                EventSetDescriptor eventSetDescriptor = beanConnection.getSourceEventSetDescriptor();
                if (beanInstance2 == beanInstance3) {
                    try {
                        Method method = eventSetDescriptor.getRemoveListenerMethod();
                        Object object = beanInstance3.getBean();
                        Object[] objectArray = new Object[]{object};
                        method.invoke(beanInstance4.getBean(), objectArray);
                        vector2.addElement(beanConnection);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (beanInstance2 != beanInstance4) continue;
                vector2.addElement(beanConnection);
                if (!(beanInstance3.getBean() instanceof BeanCommon)) continue;
                ((BeanCommon)beanInstance3.getBean()).disconnectionNotification(eventSetDescriptor.getName(), beanInstance4.getBean());
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            CONNECTIONS.removeElement((BeanConnection)vector2.elementAt(n));
        }
    }

    public static void doMetaConnection(BeanInstance beanInstance, BeanInstance beanInstance2, final EventSetDescriptor eventSetDescriptor, final JComponent jComponent) {
        Object object = beanInstance2.getBean();
        BeanInstance beanInstance3 = null;
        final BeanInstance beanInstance4 = beanInstance;
        if (object instanceof MetaBean) {
            Vector vector = ((MetaBean)object).getSuitableTargets(eventSetDescriptor);
            if (vector.size() == 1) {
                beanInstance3 = (BeanInstance)vector.elementAt(0);
                BeanConnection beanConnection = new BeanConnection(beanInstance4, beanInstance3, eventSetDescriptor);
            } else {
                int n = 0;
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.insert(new JLabel("Select target", 0), n++);
                for (int i = 0; i < vector.size(); ++i) {
                    final BeanInstance beanInstance5 = (BeanInstance)vector.elementAt(i);
                    String string = "" + (i + 1) + ": " + beanInstance5.getBean().getClass().getName();
                    JMenuItem jMenuItem = new JMenuItem(string);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            BeanConnection beanConnection = new BeanConnection(beanInstance4, beanInstance5, eventSetDescriptor);
                            jComponent.repaint();
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    ++n;
                }
                jPopupMenu.show(jComponent, beanInstance2.getX(), beanInstance2.getY());
            }
        }
    }

    public BeanConnection(BeanInstance beanInstance, BeanInstance beanInstance2, EventSetDescriptor eventSetDescriptor) {
        this.m_source = beanInstance;
        this.m_target = beanInstance2;
        this.m_eventName = eventSetDescriptor.getName();
        Method method = eventSetDescriptor.getAddListenerMethod();
        Object object = this.m_target.getBean();
        Object[] objectArray = new Object[]{object};
        Class<?> clazz = eventSetDescriptor.getListenerType();
        if (clazz.isInstance(object)) {
            try {
                method.invoke(this.m_source.getBean(), objectArray);
                if (object instanceof BeanCommon) {
                    ((BeanCommon)object).connectionNotification(eventSetDescriptor.getName(), this.m_source.getBean());
                }
                CONNECTIONS.addElement(this);
            }
            catch (Exception exception) {
                System.err.println("[BeanConnection] Unable to connect beans");
                exception.printStackTrace();
            }
        } else {
            System.err.println("[BeanConnection] Unable to connect beans");
        }
    }

    public void setHidden(boolean bl) {
        this.m_hidden = bl;
    }

    public boolean isHidden() {
        return this.m_hidden;
    }

    public void remove() {
        EventSetDescriptor eventSetDescriptor = this.getSourceEventSetDescriptor();
        try {
            Method method = eventSetDescriptor.getRemoveListenerMethod();
            Object object = this.getTarget().getBean();
            Object[] objectArray = new Object[]{object};
            method.invoke(this.getSource().getBean(), objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.getTarget().getBean() instanceof BeanCommon) {
            ((BeanCommon)this.getTarget().getBean()).disconnectionNotification(eventSetDescriptor.getName(), this.getSource().getBean());
        }
        CONNECTIONS.remove(this);
    }

    public BeanInstance getSource() {
        return this.m_source;
    }

    public BeanInstance getTarget() {
        return this.m_target;
    }

    public String getEventName() {
        return this.m_eventName;
    }

    protected EventSetDescriptor getSourceEventSetDescriptor() {
        JComponent jComponent = (JComponent)this.m_source.getBean();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(jComponent.getClass());
            if (beanInfo == null) {
                System.err.println("[BeanConnection] Error getting bean info, source info is null.");
            } else {
                EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
                for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
                    if (eventSetDescriptorArray[i].getName().compareTo(this.m_eventName) != 0) continue;
                    return eventSetDescriptorArray[i];
                }
            }
        }
        catch (Exception exception) {
            System.err.println("[BeanConnection] Problem retrieving event set descriptor");
        }
        return null;
    }
}

