/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.AttributeExpression;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class AddExpression
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 402130384261736245L;
    private String m_infixExpression = "a1^2";
    private String m_attributeName = "expression";
    private boolean m_Debug = false;
    private AttributeExpression m_attributeExpression = null;

    public String globalInfo() {
        return "An instance filter that creates a new attribute by applying a mathematical expression to existing attributes. The expression can contain attribute references and numeric constants. Supported operators are :\n+, -, *, /, ^, log, abs, cos, exp, sqrt, floor, ceil, rint, tan, sin, (, )\nAttributes are specified by prefixing with 'a', eg. a7 is attribute number 7 (starting from 1).\nExample expression : a1^2*a5/log(a7*4.0).";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSpecify the expression to apply. Eg a1^2*a5/log(a7*4.0).\n\tSupported opperators: ,+, -, *, /, ^, log, abs, cos, \n\texp, sqrt, floor, ceil, rint, tan, sin, (, )\n\t(default: a1^2)", "E", 1, "-E <expression>"));
        vector.addElement(new Option("\tSpecify the name for the new attribute. (default is the expression provided with -E)", "N", 1, "-N <name>"));
        vector.addElement(new Option("\tDebug. Names attribute with the postfix parse of the expression.", "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setExpression(string);
        } else {
            this.setExpression("a1^2");
        }
        String string2 = Utils.getOption('N', stringArray);
        if (string2.length() != 0) {
            this.setName(string2);
        }
        this.setDebug(Utils.getFlag('D', stringArray));
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-E";
        stringArray[n++] = this.getExpression();
        stringArray[n++] = "-N";
        stringArray[n++] = this.getName();
        if (this.getDebug()) {
            stringArray[n++] = "-D";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String nameTipText() {
        return "Set the name of the new attribute.";
    }

    public void setName(String string) {
        this.m_attributeName = string;
    }

    public String getName() {
        return this.m_attributeName;
    }

    public String debugTipText() {
        return "Set debug mode. If true then the new attribute will be named with the postfix parse of the supplied expression.";
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String expressionTipText() {
        return "Set the math expression to apply. Eg. a1^2*a5/log(a7*4.0)";
    }

    public void setExpression(String string) {
        this.m_infixExpression = string;
    }

    public String getExpression() {
        return this.m_infixExpression;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        this.m_attributeExpression = new AttributeExpression();
        this.m_attributeExpression.convertInfixToPostfix(new String(this.m_infixExpression));
        super.setInputFormat(instances);
        Instances instances2 = new Instances(instances, 0);
        Attribute attribute = this.m_Debug ? new Attribute(this.m_attributeExpression.getPostFixExpression()) : (this.m_attributeName.compareTo("expression") != 0 ? new Attribute(this.m_attributeName) : new Attribute(this.m_infixExpression));
        instances2.insertAttributeAt(attribute, instances.numAttributes());
        this.setOutputFormat(instances2);
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] dArray = new double[instance.numAttributes() + 1];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            dArray[i] = instance.isMissing(i) ? Instance.missingValue() : instance.value(i);
        }
        this.m_attributeExpression.evaluateExpression(dArray);
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        instance2.setDataset(this.getOutputFormat());
        this.copyValues(instance2, false, instance.dataset(), this.getOutputFormat());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] stringArray) {
        AddExpression.runFilter(new AddExpression(), stringArray);
    }
}

