/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import java.util.Vector;
import weka.core.parser.JFlex.Interval;

public final class IntCharSet {
    private static final boolean DEBUG = false;
    private Vector intervalls;
    private int pos;

    public IntCharSet() {
        this.intervalls = new Vector();
    }

    public IntCharSet(char c) {
        this(new Interval(c, c));
    }

    public IntCharSet(Interval interval) {
        this();
        this.intervalls.addElement(interval);
    }

    public IntCharSet(Vector vector) {
        int n = vector.size();
        this.intervalls = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.add((Interval)vector.elementAt(i));
        }
    }

    private int indexOf(char c) {
        int n = 0;
        int n2 = this.intervalls.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            Interval interval = (Interval)this.intervalls.elementAt(n3);
            if (n == n2) {
                return interval.contains(c) ? n : -1;
            }
            if (c < interval.start) {
                n2 = n3 - 1;
                continue;
            }
            if (c > interval.end) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return -1;
    }

    public IntCharSet add(IntCharSet intCharSet) {
        for (int i = 0; i < intCharSet.intervalls.size(); ++i) {
            this.add((Interval)intCharSet.intervalls.elementAt(i));
        }
        return this;
    }

    public void add(Interval interval) {
        int n = this.intervalls.size();
        for (int i = 0; i < n; ++i) {
            Interval interval2 = (Interval)this.intervalls.elementAt(i);
            if (interval2.end + '\u0001' < interval.start) continue;
            if (interval2.contains(interval)) {
                return;
            }
            if (interval2.start > interval.end + '\u0001') {
                this.intervalls.insertElementAt(new Interval(interval), i);
                return;
            }
            if (interval.start < interval2.start) {
                interval2.start = interval.start;
            }
            if (interval.end <= interval2.end) {
                return;
            }
            interval2.end = interval.end;
            ++i;
            while (i < n) {
                Interval interval3 = (Interval)this.intervalls.elementAt(i);
                if (interval3.start > interval2.end + '\u0001') {
                    return;
                }
                interval2.end = interval3.end;
                this.intervalls.removeElementAt(i);
                --n;
            }
            return;
        }
        this.intervalls.addElement(new Interval(interval));
    }

    public void add(char c) {
        int n = this.intervalls.size();
        for (int i = 0; i < n; ++i) {
            Interval interval = (Interval)this.intervalls.elementAt(i);
            if (interval.end + '\u0001' < c) continue;
            if (interval.contains(c)) {
                return;
            }
            if (interval.start > c + '\u0001') {
                this.intervalls.insertElementAt(new Interval(c, c), i);
                return;
            }
            if (c + '\u0001' == interval.start) {
                interval.start = c;
                return;
            }
            interval.end = c;
            if (i + 1 >= n) {
                return;
            }
            Interval interval2 = (Interval)this.intervalls.elementAt(i + 1);
            if (interval2.start <= c + '\u0001') {
                interval.end = interval2.end;
                this.intervalls.removeElementAt(i + 1);
            }
            return;
        }
        this.intervalls.addElement(new Interval(c, c));
    }

    public boolean contains(char c) {
        return this.indexOf(c) >= 0;
    }

    public boolean equals(Object object) {
        IntCharSet intCharSet = (IntCharSet)object;
        if (this.intervalls.size() != intCharSet.intervalls.size()) {
            return false;
        }
        for (int i = 0; i < this.intervalls.size(); ++i) {
            if (this.intervalls.elementAt(i).equals(intCharSet.intervalls.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    private char min(char c, char c2) {
        return c <= c2 ? c : c2;
    }

    private char max(char c, char c2) {
        return c >= c2 ? c : c2;
    }

    public IntCharSet and(IntCharSet intCharSet) {
        IntCharSet intCharSet2 = new IntCharSet();
        int n = 0;
        int n2 = 0;
        int n3 = this.intervalls.size();
        int n4 = intCharSet.intervalls.size();
        while (n < n3 && n2 < n4) {
            Interval interval = (Interval)this.intervalls.elementAt(n);
            Interval interval2 = (Interval)intCharSet.intervalls.elementAt(n2);
            if (interval.end < interval2.start) {
                ++n;
                continue;
            }
            if (interval2.end < interval.start) {
                ++n2;
                continue;
            }
            intCharSet2.intervalls.addElement(new Interval(this.max(interval.start, interval2.start), this.min(interval.end, interval2.end)));
            if (interval.end >= interval2.end) {
                ++n2;
            }
            if (interval2.end < interval.end) continue;
            ++n;
        }
        return intCharSet2;
    }

    public void sub(IntCharSet intCharSet) {
        int n = 0;
        int n2 = 0;
        int n3 = intCharSet.intervalls.size();
        while (n < this.intervalls.size() && n2 < n3) {
            Interval interval = (Interval)this.intervalls.elementAt(n);
            Interval interval2 = (Interval)intCharSet.intervalls.elementAt(n2);
            if (interval.end < interval2.start) {
                ++n;
                continue;
            }
            if (interval2.end < interval.start) {
                ++n2;
                continue;
            }
            if (interval.start == interval2.start && interval.end == interval2.end) {
                this.intervalls.removeElementAt(n);
                ++n2;
                continue;
            }
            if (interval.start == interval2.start) {
                interval.start = (char)(interval2.end + '\u0001');
                ++n2;
                continue;
            }
            if (interval.end == interval2.end) {
                interval.end = (char)(interval2.start - '\u0001');
                ++n;
                ++n2;
                continue;
            }
            this.intervalls.insertElementAt(new Interval(interval.start, (char)(interval2.start - '\u0001')), n);
            interval.start = (char)(interval2.end + '\u0001');
            ++n;
            ++n2;
        }
    }

    public boolean containsElements() {
        return this.intervalls.size() > 0;
    }

    public int numIntervalls() {
        return this.intervalls.size();
    }

    public Interval getNext() {
        if (this.pos == this.intervalls.size()) {
            this.pos = 0;
        }
        return (Interval)this.intervalls.elementAt(this.pos++);
    }

    public IntCharSet getCaseless() {
        IntCharSet intCharSet = this.copy();
        int n = this.intervalls.size();
        for (int i = 0; i < n; ++i) {
            Interval interval = (Interval)this.intervalls.elementAt(i);
            for (char c = interval.start; c <= interval.end; c = (char)(c + '\u0001')) {
                intCharSet.add(Character.toLowerCase(c));
                intCharSet.add(Character.toUpperCase(c));
                intCharSet.add(Character.toTitleCase(c));
            }
        }
        return intCharSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{ ");
        for (int i = 0; i < this.intervalls.size(); ++i) {
            stringBuffer.append(this.intervalls.elementAt(i));
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public IntCharSet copy() {
        IntCharSet intCharSet = new IntCharSet();
        int n = this.intervalls.size();
        for (int i = 0; i < n; ++i) {
            Interval interval = ((Interval)this.intervalls.elementAt(i)).copy();
            intCharSet.intervalls.addElement(interval);
        }
        return intCharSet;
    }
}

