/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class CLOPE
extends AbstractClusterer
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -567567567567588L;
    public ArrayList<CLOPECluster> clusters = new ArrayList();
    protected double m_RepulsionDefault;
    protected double m_Repulsion = this.m_RepulsionDefault = 2.6;
    protected int m_numberOfClusters = -1;
    protected int m_processed_InstanceID;
    protected int m_numberOfInstances;
    protected ArrayList<Integer> m_clusterAssignments = new ArrayList();
    protected boolean m_numberOfClustersDetermined = false;

    public int numberOfClusters() {
        this.determineNumberOfClusters();
        return this.m_numberOfClusters;
    }

    protected void determineNumberOfClusters() {
        this.m_numberOfClusters = this.clusters.size();
        this.m_numberOfClustersDetermined = true;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tRepulsion\n\t(default " + this.m_RepulsionDefault + ")", "R", 1, "-R <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setRepulsion(Double.parseDouble(string));
        } else {
            this.setRepulsion(this.m_RepulsionDefault);
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-R");
        vector.add("" + this.getRepulsion());
        return vector.toArray(new String[vector.size()]);
    }

    public String repulsionTipText() {
        return "Repulsion to be used.";
    }

    public void setRepulsion(double d) {
        this.m_Repulsion = d;
    }

    public double getRepulsion() {
        return this.m_Repulsion;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        return capabilities;
    }

    public void buildClusterer(Instances instances) throws Exception {
        boolean bl;
        int n;
        int n2;
        this.clusters.clear();
        this.m_processed_InstanceID = 0;
        this.m_clusterAssignments.clear();
        this.m_numberOfInstances = instances.numInstances();
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            n = this.AddInstanceToBestCluster(instances.instance(n2));
            this.m_clusterAssignments.add(n);
        }
        do {
            bl = false;
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                this.m_processed_InstanceID = n2;
                n = this.MoveInstanceToBestCluster(instances.instance(n2));
                if (n == this.m_clusterAssignments.get(n2)) continue;
                bl = true;
                this.m_clusterAssignments.set(n2, n);
            }
        } while (!bl);
        this.m_processed_InstanceID = 0;
    }

    public int AddInstanceToBestCluster(Instance instance) {
        int n = -1;
        if (this.clusters.size() > 0) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (instance instanceof SparseInstance) {
                for (n2 = 0; n2 < instance.numValues(); ++n2) {
                    ++n3;
                    ++n4;
                }
            } else {
                for (n2 = 0; n2 < instance.numAttributes(); ++n2) {
                    if (instance.isMissing(n2)) continue;
                    ++n3;
                    ++n4;
                }
            }
            double d = (double)n3 / Math.pow(n4, this.m_Repulsion);
            for (n2 = 0; n2 < this.clusters.size(); ++n2) {
                CLOPECluster cLOPECluster = this.clusters.get(n2);
                double d2 = cLOPECluster.DeltaAdd(instance, this.m_Repulsion);
                if (!(d2 > d)) continue;
                d = d2;
                n = n2;
            }
        } else {
            CLOPECluster cLOPECluster = new CLOPECluster();
            this.clusters.add(cLOPECluster);
            cLOPECluster.AddInstance(instance);
            return this.clusters.size() - 1;
        }
        if (n == -1) {
            CLOPECluster cLOPECluster = new CLOPECluster();
            this.clusters.add(cLOPECluster);
            cLOPECluster.AddInstance(instance);
            return this.clusters.size() - 1;
        }
        this.clusters.get(n).AddInstance(instance);
        return n;
    }

    public int MoveInstanceToBestCluster(Instance instance) {
        int n;
        this.clusters.get(this.m_clusterAssignments.get(this.m_processed_InstanceID)).DeleteInstance(instance);
        this.m_clusterAssignments.set(this.m_processed_InstanceID, -1);
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        if (instance instanceof SparseInstance) {
            for (n = 0; n < instance.numValues(); ++n) {
                ++n3;
                ++n4;
            }
        } else {
            for (n = 0; n < instance.numAttributes(); ++n) {
                if (instance.isMissing(n)) continue;
                ++n3;
                ++n4;
            }
        }
        double d = (double)n3 / Math.pow(n4, this.m_Repulsion);
        for (n = 0; n < this.clusters.size(); ++n) {
            CLOPECluster cLOPECluster = this.clusters.get(n);
            double d2 = cLOPECluster.DeltaAdd(instance, this.m_Repulsion);
            if (!(d2 > d)) continue;
            d = d2;
            n2 = n;
        }
        if (n2 == -1) {
            CLOPECluster cLOPECluster = new CLOPECluster();
            this.clusters.add(cLOPECluster);
            cLOPECluster.AddInstance(instance);
            return this.clusters.size() - 1;
        }
        this.clusters.get(n2).AddInstance(instance);
        return n2;
    }

    public int clusterInstance(Instance instance) throws Exception {
        if (this.m_processed_InstanceID >= this.m_numberOfInstances) {
            this.m_processed_InstanceID = 0;
        }
        int n = this.m_clusterAssignments.get(this.m_processed_InstanceID);
        ++this.m_processed_InstanceID;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CLOPE clustering results\n========================================================================================\n\n");
        stringBuffer.append("Clustered instances: " + this.m_clusterAssignments.size() + "\n");
        return stringBuffer.toString() + "\n";
    }

    public String globalInfo() {
        return this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Yiling Yang and Xudong Guan and Jinyuan You");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "CLOPE: a fast and effective clustering algorithm for transactional data");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the eighth ACM SIGKDD international conference on Knowledge discovery and data mining");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2002");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "682-687");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "ACM  New York, NY, USA");
        return technicalInformation;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    public static void main(String[] stringArray) {
        CLOPE.runClusterer(new CLOPE(), stringArray);
    }

    private class CLOPECluster
    implements Serializable {
        public int N = 0;
        public int W = 0;
        public int S = 0;
        public HashMap occ = new HashMap();

        private CLOPECluster() {
        }

        public void AddItem(String string) {
            if (!this.occ.containsKey(string)) {
                this.occ.put(string, 1);
            } else {
                int n = (Integer)this.occ.get(string);
                this.occ.remove(string);
                this.occ.put(string, ++n);
            }
            ++this.S;
        }

        public void AddItem(Integer n) {
            if (!this.occ.containsKey(n)) {
                this.occ.put(n, 1);
            } else {
                int n2 = (Integer)this.occ.get(n);
                this.occ.remove(n);
                this.occ.put(n, ++n2);
            }
            ++this.S;
        }

        public void DeleteItem(String string) {
            int n = (Integer)this.occ.get(string);
            if (n == 1) {
                this.occ.remove(string);
            } else {
                this.occ.remove(string);
                this.occ.put(string, --n);
            }
            --this.S;
        }

        public void DeleteItem(Integer n) {
            int n2 = (Integer)this.occ.get(n);
            if (n2 == 1) {
                this.occ.remove(n);
            } else {
                this.occ.remove(n);
                this.occ.put(n, --n2);
            }
            --this.S;
        }

        public double DeltaAdd(Instance instance, double d) {
            double d2;
            int n = 0;
            int n2 = this.occ.size();
            if (instance instanceof SparseInstance) {
                for (int i = 0; i < instance.numValues(); ++i) {
                    ++n;
                    if ((Integer)this.occ.get(instance.index(i)) != null) continue;
                    ++n2;
                }
            } else {
                for (int i = 0; i < instance.numAttributes(); ++i) {
                    if (instance.isMissing(i)) continue;
                    ++n;
                    if ((Integer)this.occ.get(i + instance.toString(i)) != null) continue;
                    ++n2;
                }
            }
            n += this.S;
            if (this.N == 0) {
                d2 = (double)n / Math.pow(n2, d);
            } else {
                double d3 = (double)(this.S * this.N) / Math.pow(this.W, d);
                double d4 = (double)(n * (this.N + 1)) / Math.pow(n2, d);
                d2 = d4 - d3;
            }
            return d2;
        }

        public void AddInstance(Instance instance) {
            if (instance instanceof SparseInstance) {
                for (int i = 0; i < instance.numValues(); ++i) {
                    this.AddItem(instance.index(i));
                }
            } else {
                for (int i = 0; i < instance.numAttributes(); ++i) {
                    if (instance.isMissing(i)) continue;
                    this.AddItem(i + instance.toString(i));
                }
            }
            this.W = this.occ.size();
            ++this.N;
        }

        public void DeleteInstance(Instance instance) {
            if (instance instanceof SparseInstance) {
                for (int i = 0; i < instance.numValues(); ++i) {
                    this.DeleteItem(instance.index(i));
                }
            } else {
                for (int i = 0; i <= instance.numAttributes() - 1; ++i) {
                    if (instance.isMissing(i)) continue;
                    this.DeleteItem(i + instance.toString(i));
                }
            }
            this.W = this.occ.size();
            --this.N;
        }
    }
}

