/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.trees.m5.M5Base;
import weka.classifiers.trees.m5.Rule;
import weka.core.Drawable;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class M5P
extends M5Base
implements Drawable {
    static final long serialVersionUID = -6118439039768244417L;

    public M5P() {
        this.setGenerateRules(false);
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph M5Tree {\n");
        Rule rule = (Rule)this.m_ruleSet.elementAt(0);
        rule.topOfTree().graph(stringBuffer);
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String saveInstancesTipText() {
        return "Whether to save instance data at each node in the tree for visualization purposes.";
    }

    public void setSaveInstances(boolean bl) {
        this.m_saveInstances = bl;
    }

    public boolean getSaveInstances() {
        return this.m_saveInstances;
    }

    public Enumeration listOptions() {
        Enumeration enumeration = super.listOptions();
        Vector<Option> vector = new Vector<Option>();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        vector.addElement(new Option("\tSave instances at the nodes in\n\tthe tree (for visualization purposes)", "L", 0, "-L"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setSaveInstances(Utils.getFlag('L', stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 1];
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        if (this.getSaveInstances()) {
            stringArray2[n++] = "-L";
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.10 $");
    }

    public static void main(String[] stringArray) {
        M5P.runClassifier(new M5P(), stringArray);
    }
}

